;// i740tclk.asm - i740 text mode clock handler windows vxd driver

.386p
include vmm.inc
include minivdd.inc

;// data structure stored for each vm
i740tclk_cb_data struc
vm_type dd  ?  ;// vm type: 0=fullscreen, !0=windowed
clk1    db  ?  ;// i740 clock registers
clk2    db  ?  ;
clk3    db  ?  ;
valid   db  ?  ;// flag: clock registers are valid
i740tclk_cb_data ends

;// vxd control structure
Declare_Virtual_Device\
  I740TCLK, 3, 0, i740tclk_control, Undefined_Device_ID, ,\
  i740tclk_api_proc, i740tclk_api_proc

;// data
VxD_LOCKED_DATA_SEG
i740clk_cb_offset  dd  0
windows_vm_id      dd  0
vdd_vmtype_proc    dd  0
VxD_LOCKED_DATA_ENDS

VxD_ICODE_SEG
BeginProc i740tclk_sys_crit_init
        push    ebx
        ;// allocate device structure in each vm
        VMMCall _Allocate_Device_CB_Area, <<SIZE i740tclk_cb_data>, 0>
        mov     [i740clk_cb_offset], eax
        pop     ebx
        clc
        ret
EndProc i740tclk_sys_crit_init

BeginProc i740tclk_device_init
        ;// save windows vm id
        mov                   [windows_vm_id], ebx
        ;// hook VDD_Set_VMType
        GetVxDServiceOrdinal  eax, VDD_Set_VMType
        mov                   esi, offset32 i740tclk_set_vmtype
        VMMCall               Hook_Device_Service
        mov                   [vdd_vmtype_proc], esi
        clc
        ret
EndProc i740tclk_device_init
VxD_ICODE_ENDS

VxD_LOCKED_CODE_SEG
BeginProc i740tclk_control
        ;// device control dispatchers
        Control_Dispatch Sys_Critical_Init, i740tclk_sys_crit_init
        Control_Dispatch Device_Init,       i740tclk_device_init
        Control_Dispatch Set_Device_Focus,  i740tclk_set_device_focus
        clc
        ret
EndProc i740tclk_control

restore_refresh_registers:
        ;// check that vm is fullscreen
        cmp     ax, 0
        jnz     dont_restore

        ;// check that vm is not windows vm
        cmp     ebx, [windows_vm_id]
        jz      dont_restore

        ;// check that vm is crtc owner
        ;// windows sometimes sets focus or changes vm type
        ;// without switching to appropriate vm in fullscreen mode
        push    esi
        VxDCall VDD_Get_VM_Info
        pop     esi
        cmp     ebx, edi
        jnz     dont_restore

        ;// check that clock settings was saved for this vm
        mov     al, [esi.valid]
        cmp     al, 1
        jnz     dont_restore

        ;// check that controller is in text mode
        mov     dx, 3dah
        in      al, dx
        mov     dx, 3c0h
        mov     al, 10h
        out     dx, al
        inc     dl
        in      al, dx
        and     al, 01h
        cmp     al, 01h
        jz      restore_only_video

        ;// check that i740 clock registers are enabled
        mov     dx, 3cch
        in      al, dx
        and     al, 0ch
        shr     al, 2
        cmp     al, 01h
        jbe     restore_only_video

        ;// restore clock registers
        mov     dx, 3d6h
        mov     al, 0c8h
        out     dx, al
        inc     dl
        mov     al, [esi.clk1]
        out     dx, al

        mov     dx, 3d6h
        mov     al, 0c9h
        out     dx, al
        inc     dl
        mov     al, [esi.clk2]
        out     dx, al

        mov     dx, 3d6h
        mov     al, 0cbh
        out     dx, al
        inc     dl
        mov     al, [esi.clk3]
        out     dx, al

restore_only_video:
        mov     dx, 3dah
        in      al, dx
        mov     dx, 3c0h
        mov     al, 20h
        out     dx, al

dont_restore:
        ret

;// try to restore clock registers in VDD_Set_VMType and Set_Device_Focus
;// handlers
;// really it must be implemented in mini-vdd or card-vdd driver,
;// but i740 already has mini-vdd gfx.vdd, and this way does not works
BeginProc i740tclk_set_vmtype
        pushad
        ;// save vm type
        mov     esi, ebx
        add     esi, [i740clk_cb_offset]
        mov     [esi.vm_type], eax
        ;// check vm state and restore registers if appropriate
        call    restore_refresh_registers
        popad
        jmp     [vdd_vmtype_proc]
EndProc i740tclk_set_vmtype

BeginProc i740tclk_set_device_focus
        pushad
        ;// get vm type
        mov     esi, ebx
        add     esi, [i740clk_cb_offset]
        mov     eax, [esi.vm_type]
        ;// check vm state and restore registers if appropriate
        call    restore_refresh_registers
        popad
        clc
        ret
EndProc i740tclk_set_device_focus
VxD_LOCKED_CODE_ENDS

VxD_CODE_SEG
BeginProc i740tclk_api_proc
        ;// api: save clock register values passed in ch, cl, dl
        mov     esi, ebx
        add     esi, [i740clk_cb_offset]
        mov     cx,[ebp.Client_CX]
        mov     dx,[ebp.Client_DX]
        mov     [esi.clk1],ch
        mov     [esi.clk2],cl
        mov     [esi.clk3],dl
        mov     [esi.valid],1
        ret
EndProc i740tclk_api_proc
VxD_CODE_ENDS

        end
