// i740clk.c - program i740 video card clock
//
// i740clk (C) 1998,1999 Alexander Lokhan'ko <anl@mailandnews.com>,
// <alex@eunet.lt>
// please read i740clk.txt for additional information
//
// 25.11.98 v100: program misc register and clock 3d6/3d7:c8,c9,ca,cb
//                registers
// 26.11.98 v110: additional low-level clocks 32,33,34,35 Mhz
// 08.12.98 v111: additional low-level clock 37 Mhz
// 13.02.99 v120: notify i740tclk.vxd under windows for correctly restoring of
//                fullscreen text mode clocks
// 20.09.99 v121: fix notifying i740tclk.vxd under pure dos

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifdef __WATCOMC__
  unsigned char inb(short port);
  #pragma aux inb="in al,dx" parm[dx] value[al];
  void outb(short port,unsigned char data);
  #pragma aux outb="out dx,al" parm[dx][ax];
#endif

#ifdef DJGPP
  #include <pc.h>
  #define inb(port)       inportb(port)
  #define outb(data,port) outportb(port,data)
#endif

#if !defined(DOS) && !defined (__DOS__)
  static __inline__ unsigned char inb(short port){
    unsigned char data;
    __asm__ __volatile__("inb %1,%0" : "=a" (data) : "d" (port));
    return data;
  }

  static __inline__ void outb(short port,unsigned char data){
    __asm__ __volatile__("outb %0,%1" :: "a" (data) , "d" (port));
  }
#else
  int ioperm(int x,int y,int z){ return 0; }
#endif

// notify i740tclk.vxd under windows
// compiled now only under watcom c
#if defined(__WATCOMC__)

  void* vxd_api(char* name);
  #pragma aux vxd_api=\
    "mov cx,es""mov dx,di"\
    "xor bx,bx""mov ax,1684h""int 2fh"\
    "mov ax,es""cmp cx,ax""jnz ok""cmp dx,di""jnz ok""xor di,di""mov es,di""ok:"\
    parm[es di] value[es di] modify[ax bx];
  typedef void (*vxd_service)();

  static void i740tclk_notify
    (unsigned char clk1,unsigned char clk2,unsigned char clk3){
    vxd_service proc;
    proc=(vxd_service)vxd_api("I740TCLK");
    if(!proc) return;
    _asm mov ch,clk1
    _asm mov cl,clk2
    _asm mov dl,clk3
    (*proc)();
  }
#else
  static void i740tclk_notify
    (unsigned char clk1,unsigned char clk2,unsigned char clk3){}
#endif

struct i740clk_tab{
  unsigned short mhz;
  unsigned char  clk1;
  unsigned char  clk2;
  unsigned char  clk3;
};

// i740 clock programming done now with table lookup
// real version must use some mathematics for programming any frequency
static struct i740clk_tab i740clk_tab[]={
  { 3150,0x0f,0x10,0x31}, // standard win95 driver  640 x 480 75Hz
  { 3600,0x19,0x17,0x31}, // standard win95 driver  640 x 480 85Hz
  { 4000,0x04,0x03,0x31}, // standard win95 driver  800 x 600 60Hz
  { 4950,0x2c,0x1d,0x31}, // standard win95 driver  800 x 600 75Hz
  { 5625,0x14,0x32,0x35}, // standard win95 driver  800 x 600 85Hz
  { 6500,0x1f,0x20,0x21}, // standard win95 driver 1024 x 768 60Hz
  { 7875,0x1e,0x19,0x21}, // standard win95 driver 1024 x 768 75Hz
  { 9450,0x0f,0x0a,0x21}, // standard win95 driver 1024 x 768 85Hz
  {10800,0x0b,0x1e,0x25}, // standard win95 driver 1280 x1024 60Hz

  { 3204,0x7b,0x80,0x31}, // custom clock
  { 3299,0x5f,0x60,0x31}, // custom clock
  { 3400,0x31,0x30,0x31}, // custom clock
  { 3495,0x54,0x50,0x31}, // custom clock
  { 3699,0x59,0x50,0x31}, // custom clock

  {    0,   0,   0,   0}
};

// set vga clock in misc register
static void misc_clk(unsigned char clk){
  unsigned char val;
  val=inb(0x3cc);
  val&=0xf3;
  val|=clk<<2;
  outb(0x3c2,val);
}

// set value of i740 3d6/3d7 clock register
static void i740_clk(unsigned char reg,unsigned char data){
  outb(0x3d6,reg);
  outb(0x3d7,data);
}

int i740clk(unsigned short mhz){
  if(ioperm(0x3b4,0x3df-0x3b4+1,1))
    return -1;
  if(mhz==2521) misc_clk(0); else
  if(mhz==2832) misc_clk(1); else{
    unsigned char clk1,clk2,clk3;
    int i;
    for(i=0;i740clk_tab[i].mhz!=0;i++)
      if(i740clk_tab[i].mhz==mhz)
        break;
    if(!i740clk_tab[i].mhz) return -1;
    clk1=i740clk_tab[i].clk1;
    clk2=i740clk_tab[i].clk2;
    clk3=i740clk_tab[i].clk3;

    i740_clk(0xc8,clk1);
    i740_clk(0xc9,clk2);
    i740_clk(0xca,0);
    i740_clk(0xcb,clk3);
    misc_clk(2);
    i740tclk_notify(clk1,clk2,clk3);
  }
  return 0;
}

int main(int argc,char** argv){
  float fmhz;
  char smhz[10];
  unsigned long mhz;
  printf("i740clk v121 - program i740 video card clock\n"); fflush(stdout);
  if(argc<3){ printf("i740clk mhz_clock clock_num\n"); return 1; }
  // read clock frequency from command line
  // with some dumb rounding to the 2 digits after point
  fmhz=atof(argv[1]);
  sprintf(smhz,"%.2f",fmhz);
  fmhz=atof(smhz)*100.00;
  mhz=(unsigned long)fmhz;
  // set clock
  return i740clk(mhz)?2:0;
}
