/*
xzip by softguy@citiz.net
All rights reserved.
*/



#include <string>
#include <stdio.h>
#include <stdlib.h>

#ifndef ZIP_H
#define ZIP_H

#define TARBALL 1
#define TGZBALL 2
#define ZIPBALL 3
#define TB2BALL 4
#define GZBALL  5
#define BZ2BALL 6

#define NOTBALL 7



class basefile
 {protected:
  void str2ls(string s);  
  int exec(char *s1,string *s2);
  public:
  char cfn[BUFSIZ],**cls; int ils;
  basefile(char *s) {strcpy(cfn,s);}
  int newtar(char *s);
  int newtgz(char *s);
  int newzip(char *s);
  int type(char *s1);
  virtual int add(char *s) {return -1;}
  virtual int create(char *s1) {return -1;} 
  virtual int extract(char *s2,char *s3) {return -1;}
  virtual int remove(char *s2) {return -1;}
  virtual char **list() {return NULL;}
  virtual int test() {return -1;}
 };

class zfile:public basefile
 {char czip[6];
  public:
  zfile(char *s,char *c) :basefile(s) {strcpy(czip,c);}
  int test() 
   {char s[BUFSIZ]; sprintf(s,"%s -t %s ",czip, cfn); return system(s);}
  int extract(char *s2,char *s3)
   {char s1[BUFSIZ]; 
    sprintf(s1,"%s -d -c %s > %s%s",czip,cfn,s2,rindex(cfn,'/')+1);
    *rindex(s1,'.')='\0'; return system(s1); 
   }
  char **list() 
   {string s(cfn); s+="\n"; str2ls(s); return cls;}
 };
class tarfile:public basefile
 {
  public:
  tarfile(char *s) :basefile(s) {}

  int add(char *s1) 
   {char s2[BUFSIZ]; sprintf(s2,"tar -rf %s %s",cfn,s1); return system(s2);}
  int extract(char *s2,char *s3)
   {char s1[BUFSIZ]; sprintf(s1,"tar -C %s -xf %s %s",s2,cfn,s3); 
    return system(s1);
   }
  char **list() 
   {char s1[BUFSIZ]; string s2; 
    sprintf(s1,"tar -tvf %s",cfn); exec(s1,&s2); str2ls(s2); return cls;
   }
  int remove(char *s2)
   {char s1[BUFSIZ]; sprintf(s1,"tar --delete -f %s %s",cfn,s2);
    return system(s1);
   }
  int test() 
   {char s[BUFSIZ]; sprintf(s,"tar -tf %s > /dev/null",cfn); return system(s);}
 }; 

class tzfile:public basefile
 {char ctf[BUFSIZ],czip[6]; 
  public:
  tzfile(char *s,char *c):basefile(s) {strcpy(czip,c);}
  ~tzfile() {remove(ctf);}
  int add(char *s1); 
  int extract(char *s2,char *s3)
   {char s1[BUFSIZ]; sprintf(s1,"tar -C %s -xf %s %s",s2,ctf,s3);
    return system(s1);
   }
  char **list() 
   {char s1[BUFSIZ]; string s2; 
    sprintf(s1,"tar -tvf %s",ctf); exec(s1,&s2); str2ls(s2); return cls;
   }
  int remove(char *s2);
  int test();
 }; 

class zipfile:public basefile
 {
  public:
  zipfile(char *s) :basefile(s) {}
  int add(char *s1) 
   {char s2[BUFSIZ]; sprintf(s2,"zip %s %s",cfn,s1); return system(s2);}
  int extract(char *s2,char *s3)
   {char s1[BUFSIZ]; sprintf(s1,"unzip %s %s -d %s",cfn,s3,s2);
    return system(s1);
   }
  int remove(char *s2)
   {char s1[BUFSIZ]; sprintf(s1,"zip -d %s %s",cfn,s2); return system(s1);}
  char **list(); 
  int test() 
   {char s[BUFSIZ]; sprintf(s,"unzip -l %s > /dev/null",cfn); return system(s);}
 
 }; 


#endif

