/*
xzip by softguy@citiz.net
All rights reserved.
*/

#include  <X11/Intrinsic.h> 
#include  <X11/StringDefs.h> 
#include  <X11/Xaw/Form.h> 
#include  <X11/Xaw/SimpleMenu.h> 
#include  <X11/Xaw/SmeBSB.h> 
#include  <X11/Xaw/MenuButton.h> 
#include  <X11/Xaw/SmeLine.h> 
#include  <X11/Xaw/AsciiText.h> 
#include  <X11/Xaw/Viewport.h>
#include  <X11/Xaw/List.h>
#include  <X11/Xaw/Viewport.h>
#include  <X11/Xaw/Label.h>
#include  <X11/Xaw/Dialog.h>

#include "dfile.h"
#include "zip.h"
#include <string>

static char bits[9][54]={
 {0x00,0x00,0xfc,0x00,0x00,0xfc,0x00,0x00,0xfc,0xf8,0x07,0xfc,0x08,0x0c,0xfc,
 0x08,0x14,0xfc,0x08,0x3c,0xfc,0x08,0x20,0xfc,0x08,0x20,0xfc,0x08,0x20,0xfc,
 0x08,0x20,0xfc,0x08,0x20,0xfc,0x08,0x20,0xfc,0x08,0x20,0xfc,0x08,0x20,0xfc,
 0xf8,0x3f,0xfc,0x00,0x00,0xfc,0x00,0x00,0xfc},
 {0x00,0x00,0xfc,0x00,0x00,0xfc,0x00,0x00,0xfc,0x00,0x38,0xfc,0x00,0x44,0xfd,
 0x00,0x80,0xfd,0x38,0xc0,0xfd,0xc4,0x1f,0xfc,0x04,0x10,0xfc,0x04,0x10,0xfc,
 0x84,0xff,0xff,0xc4,0xff,0xfd,0xc4,0xff,0xfc,0xf4,0x7f,0xfc,0xfc,0x3f,0xfc,
 0xfc,0x1f,0xfc,0x00,0x00,0xfc,0x00,0x00,0xfc},
 {0x00,0x00,0xfc,0xe0,0x0f,0xfc,0x50,0x14,0xfc,0x88,0x22,0xfc,0xf8,0x3f,0xfc,
 0x58,0x20,0xfc,0x68,0x20,0xfc,0x58,0x20,0xfc,0x68,0x20,0xfc,0x58,0x20,0xfc,
 0x68,0x20,0xfc,0x58,0x20,0xfc,0x68,0x20,0xfc,0xd8,0x21,0xfc,0xa8,0x26,0xfc,
 0x58,0x3d,0xfc,0xff,0xff,0xff,0x00,0x00,0xfc},
 {0x00,0x00,0x00,0x00,0x40,0x00,0x00,0x20,0x00,0x00,0x10,0x00,0x00,0x09,0x00,
 0x00,0x07,0x00,0x00,0x07,0x00,0x3e,0x0f,0x00,0x62,0x00,0x00,0xa2,0x00,0x00,
 0xfa,0x01,0x00,0x02,0x01,0x00,0x7a,0x01,0x00,0x02,0x01,0x00,0x7a,0x01,0x00,
 0x02,0x01,0x00,0xfe,0x01,0x00,0x00,0x00,0x00},
 {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x30,0x00,
 0x70,0x38,0x00,0xe0,0x1c,0x00,0xc0,0x0f,0x00,0x80,0x07,0x00,0x80,0x07,0x00,
 0xc0,0x0f,0x00,0xe0,0x1c,0x00,0x70,0x38,0x00,0x30,0x30,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
 {0xff,0xff,0x03,0xff,0xff,0x03,0xff,0xff,0x03,0xff,0xc1,0x03,0xff,0x9d,0x03,
 0xff,0x5d,0x03,0xff,0x05,0x02,0xff,0xfd,0x02,0x7f,0x85,0x02,0xbf,0xfd,0x02,
 0xdf,0x85,0x02,0xed,0xfd,0x02,0xf1,0x01,0x02,0xf1,0xff,0x03,0xe1,0xff,0x03,
 0xff,0xff,0x03,0xff,0xff,0x03,0xff,0xff,0x03},

 {0x00,0x00,0xfc,0x80,0x0f,0xfc,0x60,0x30,0xfc,0x10,0x40,0xfc,0x08,0x80,0xfc,
 0x04,0x00,0xfd,0xe4,0x3f,0xfd,0xf2,0x7d,0xfe,0xea,0xbd,0xfe,0xe6,0x38,0xff,
 0x02,0x00,0xfe,0x02,0x00,0xfe,0x44,0x10,0xfd,0x84,0x0f,0xfd,0x08,0x80,0xfc,
 0x10,0x40,0xfc,0x60,0x30,0xfc,0x80,0x0f,0xfc},
 {0x00,0x00,0xfc,0xc0,0x07,0xfc,0x30,0x18,0xfc,0x08,0x20,0xfc,0x04,0x40,0xfc,
 0x02,0x80,0xfc,0x62,0x8c,0xfc,0x61,0x0c,0xfd,0x01,0x00,0xfd,0x01,0x00,0xfd,
 0x01,0x00,0xfd,0x11,0x10,0xfd,0x22,0x88,0xfc,0xc2,0x87,0xfc,0x04,0x40,0xfc,
 0x08,0x20,0xfc,0x30,0x18,0xfc,0xc0,0x07,0xfc},
 {0x00,0x00,0x00,0x80,0x0f,0x00,0x60,0x30,0x00,0x10,0x40,0x00,0x08,0x80,0x00,
 0xe4,0x38,0x01,0xe4,0x38,0x01,0xe2,0x38,0x02,0x02,0x00,0x02,0x02,0x00,0x02,
 0x02,0x07,0x02,0x82,0x0d,0x02,0x84,0x08,0x01,0x84,0x0d,0x01,0x08,0x87,0x00,
 0x10,0x40,0x00,0x60,0x30,0x00,0x80,0x0f,0x00}



};
Pixmap btb[9];

class xzip
 {
  static Widget tools[6],toplevel,let,lstat,dhelp,mzip[3]; static dfile *fd; 
  static basefile *bf; 
  
  static void mopen(Widget w,XtPointer client,XtPointer call)
   {fd->show("Open",ropen);}
  static void mnewtar(Widget w,XtPointer client,XtPointer call)
   {fd->show("New tar",rnewtar);}
  static void mnewtgz(Widget w,XtPointer client,XtPointer call)
   {fd->show("New tgz",rnewtgz);}
  static void mnewzip(Widget w,XtPointer client,XtPointer call)
   {fd->show("New zip",rnewzip);}
  static void mexit(Widget w,XtPointer client,XtPointer call);  

  static void madd(Widget w,XtPointer client,XtPointer call)
   {fd->show("Add",radd);}
  static void mdelete(Widget w,XtPointer client,XtPointer call);
  static void mextract(Widget w,XtPointer client,XtPointer call)  
   {fd->show("Extract",rextract);}

  static void msort(Widget w,XtPointer client,XtPointer call)  
   {setlstat("Please write to softguy@citiz.net to get next release!",0); }
  static void mabout(Widget w,XtPointer client,XtPointer call)
   {setlstat("xzip by softguy@citiz.net",0);}  
  static void mhelp(Widget w,XtPointer client,XtPointer call)  
   {XtPopup(dhelp, XtGrabNonexclusive);}
  static void brun(Widget w,Widget client,XtPointer call);  
  static void bcancel(Widget w,XtPointer client,XtPointer call);  
 
  static void rhelp();
  static void ropen(char *s1,char *s2);
  static void rnewtar(char *s1,char *s2);
  static void rnewtgz(char *s1,char *s2);
  static void rnewzip(char *s1,char *s2);
  static void rextract(char *s1,char *s2);
  static void radd(char *s1,char *s2);
  static void setlstat(char *s1,int w);
  static void enablemenu();
  static int name2color(Widget w, char *name);
  static void gettoken(char *s1,int n,char *s2);
  public:
  xzip(int argc,char **argv);
 };

dfile * xzip::fd=NULL;
Widget xzip::toplevel, xzip::let, xzip::lstat,xzip::dhelp, xzip::mzip[3];
Widget xzip::tools[6];
basefile * xzip::bf=NULL;

void xzip::setlstat(char *s1,int w)
 {int cb,cf,n=0; Arg wargs[10];
  if(w==0) {cb=name2color(lstat,"blue");cf=name2color(lstat,"white");}
  if(w==1) {cb=name2color(lstat,"gray");cf=name2color(lstat,"black");}
  if(w==2) {cb=name2color(lstat,"gray");cf=name2color(lstat,"red");}

  XtSetArg(wargs[n], XtNbackground, cb); n++;
  XtSetArg(wargs[n], XtNforeground, cf); n++;
  XtSetArg(wargs[n], XtNleftBitmap, btb[w+6]); n++;
  XtSetArg(wargs[n], XtNlabel, s1); n++;
  XtSetValues(lstat,wargs,n);
 }

void xzip::enablemenu()
 {Arg w1[1],w2[1]; int t=bf->type(bf->cfn);
  XtSetArg(w1[0], XtNsensitive,True);
  XtSetArg(w2[0], XtNsensitive,False);
  if(t<5) {XtSetValues(mzip[0],w1,1); XtSetValues(tools[3],w1,1);}
  else {XtSetValues(mzip[0],w2,1); XtSetValues(tools[3],w2,1);}
  if(t<5) {XtSetValues(mzip[1],w1,1); XtSetValues(tools[4],w1,1);}
  else {XtSetValues(mzip[1],w2,1); XtSetValues(tools[4],w2,1);}
  if(t<7) {XtSetValues(mzip[2],w1,1); XtSetValues(tools[5],w1,1);}
  else {XtSetValues(mzip[2],w2,1); XtSetValues(tools[5],w2,1);}
 }



void xzip::mexit(Widget w,XtPointer client,XtPointer call)
 {int i; for(i=0;i<9;i++) XFreePixmap(XtDisplay(toplevel), btb[i]);
  exit(0);
 }

void xzip::gettoken(char *s1,int n,char *s2)
 {int i,m=1; char *p,b[BUFSIZ]; 
  
  strcpy(b,s1); strtok(b," \t"); while(strtok(NULL," \t")!=NULL) m++;
  strcpy(b,s1); p=strtok(b," \t"); 
  for(i=0;i<m-n;i++) p=strtok(NULL," \t"); strcpy(s2,p); 
 }

void xzip::mdelete(Widget w,XtPointer client,XtPointer call)
 {char d[BUFSIZ]; XawListReturnStruct *l=XawListShowCurrent(let);
  if(strlen(l->string)==0) return;
  gettoken(l->string,1,d);
  if(bf->remove(d)!=0)  {setlstat("Error of Deleting",2); return;} 
  XawListChange(let,bf->list(),0,0,True);  setlstat("OK of Deleting",1);
 }



main(int argc,char **argv)
 {new xzip(argc,argv);}


xzip::xzip(int argc,char **argv)
 {Widget vp,form,entry,buttons[4], menus[4];XtAppContext appcon;  
  char *mn[]={"menu1","menu2","menu3","menu4"};
  char *bn[]={"File","Zip","Sort","Help"};
  int n,i; Arg wargs[10];

  XtSetLanguageProc(NULL, NULL, NULL);
  toplevel=XtAppInitialize(&appcon,"xzip",NULL,0,&argc,argv,NULL,NULL,0);
  form = XtCreateManagedWidget("form", formWidgetClass,toplevel, NULL, 0);

  for(i=0;i<4;i++)
   {buttons[i]=XtCreateManagedWidget(bn[i], menuButtonWidgetClass,form,NULL,0);
    n=0; XtSetArg(wargs[n], XtNmenuName, mn[i]); n++;
    if(i>0) {XtSetArg(wargs[n], XtNfromHoriz, buttons[i-1]); n++;}
    XtSetValues(buttons[i],wargs,n);
    menus[i]=XtCreatePopupShell(mn[i],simpleMenuWidgetClass,buttons[i],NULL,0);    
   }   

  for(i=0;i<9;i++)
  btb[i]=XCreateBitmapFromData(XtDisplay(toplevel),
   RootWindowOfScreen(XtScreen(toplevel)), bits[i], 18, 18);

  XtSetArg(wargs[0], XtNrightBitmap, btb[1]); 
  XtSetArg(wargs[1], XtNrightMargin, 18); 

  entry=XtCreateManagedWidget("Open", smeBSBObjectClass,menus[0], wargs, 2);
  XtAddCallback(entry, XtNcallback,mopen,NULL);
  entry=XtCreateManagedWidget("",smeLineObjectClass,menus[0], NULL, 0);
  entry=XtCreateManagedWidget("New tar", smeBSBObjectClass,menus[0], NULL, 0);
  XtAddCallback(entry, XtNcallback, mnewtar, NULL);
  XtSetArg(wargs[0], XtNrightBitmap, btb[0]); 
  entry=XtCreateManagedWidget("New tgz", smeBSBObjectClass,menus[0],wargs,2);
  XtAddCallback(entry, XtNcallback, mnewtgz, NULL);
  entry=XtCreateManagedWidget("New zip", smeBSBObjectClass,menus[0], NULL, 0);
  XtAddCallback(entry, XtNcallback, mnewzip, NULL);
  entry=XtCreateManagedWidget("",smeLineObjectClass,menus[0], NULL, 0);
  XtSetArg(wargs[0], XtNrightBitmap, btb[2]); 
  entry=XtCreateManagedWidget("Exit", smeBSBObjectClass,menus[0],wargs,2);
  XtAddCallback(entry, XtNcallback, mexit,NULL);

  XtSetArg(wargs[0], XtNrightBitmap, btb[3]); 
  mzip[0]=XtCreateManagedWidget("Add", smeBSBObjectClass,menus[1],wargs,2);
  XtAddCallback(mzip[0], XtNcallback, madd, NULL);
  XtSetArg(wargs[0], XtNrightBitmap, btb[4]); 
  mzip[1]=XtCreateManagedWidget("Delete", smeBSBObjectClass,menus[1],wargs,2);
  XtAddCallback(mzip[1], XtNcallback,mdelete,NULL);
  XtSetArg(wargs[0], XtNrightBitmap, btb[5]); 
  mzip[2]=XtCreateManagedWidget("Extract", smeBSBObjectClass,menus[1],wargs,2);
  XtAddCallback(mzip[2], XtNcallback, mextract,NULL);

  entry = XtCreateManagedWidget("Date", smeBSBObjectClass,menus[2], NULL, 0);
  XtAddCallback(entry, XtNcallback, msort, NULL);
  entry = XtCreateManagedWidget("Name", smeBSBObjectClass,menus[2], NULL, 0);
  XtAddCallback(entry, XtNcallback, msort, NULL);
  entry = XtCreateManagedWidget("Size", smeBSBObjectClass,menus[2], NULL, 0);
  XtAddCallback(entry, XtNcallback, msort, NULL);
  entry=XtCreateManagedWidget("line1", smeLineObjectClass, menus[2], NULL, 0);
  entry = XtCreateManagedWidget("Unsort", smeBSBObjectClass,menus[2],NULL, 0);
  XtAddCallback(entry, XtNcallback, msort, NULL);

  entry = XtCreateManagedWidget("Help", smeBSBObjectClass,menus[3], NULL, 0);
  XtAddCallback(entry, XtNcallback, mhelp, NULL);
  entry = XtCreateManagedWidget("About", smeBSBObjectClass,menus[3], NULL, 0);
  XtAddCallback(entry, XtNcallback, mabout, NULL);

  for(i=0;i<6;i++)
   {n=0;
    XtSetArg(wargs[n], XtNbitmap,btb[i]); n++;
    XtSetArg(wargs[n], XtNfromVert, buttons[0]); n++;
    XtSetArg(wargs[n], XtNinternalWidth,0); n++;
    XtSetArg(wargs[n], XtNinternalHeight,0); n++;
    XtSetArg(wargs[n], XtNvertDistance,0); n++;
    XtSetArg(wargs[n], XtNhorizDistance,0); n++;
    XtSetArg(wargs[n], XtNborderWidth,0); n++;
    if(i>0) {XtSetArg(wargs[n], XtNfromHoriz,tools[i-1]); n++;}
    tools[i]=XtCreateManagedWidget("",commandWidgetClass,form,wargs,n);
   }
  XtAddCallback(tools[0], XtNcallback,mnewtgz, NULL);
  XtAddCallback(tools[1], XtNcallback,mopen, NULL);
  XtAddCallback(tools[2], XtNcallback,mexit, NULL);
  XtAddCallback(tools[3], XtNcallback,madd, NULL);
  XtAddCallback(tools[4], XtNcallback,mdelete, NULL);
  XtAddCallback(tools[5], XtNcallback,mextract, NULL);

  n = 0;
  XtSetArg(wargs[n], XtNfromVert, tools[0]); n++;
  XtSetArg(wargs[n], XtNforceBars,True); n++;
  XtSetArg(wargs[n], XtNallowVert,True); n++;
  XtSetArg(wargs[n], XtNuseRight,True); n++;
  XtSetArg(wargs[n], XtNheight,HeightOfScreen(DefaultScreenOfDisplay(XtDisplay(toplevel)))*2/3);  n++;
  vp=XtCreateManagedWidget("vp",viewportWidgetClass,form,wargs,n);
  n=0;
  XtSetArg(wargs[n], XtNwidth,WidthOfScreen(DefaultScreenOfDisplay(XtDisplay(toplevel)))*2/3); n++;
  XtSetArg(wargs[n], XtNdefaultColumns,1); n++;
  XtSetArg(wargs[n], XtNlist,NULL); n++;
//  XtSetArg(wargs[0], XtNnumberStrings, 0);
  XtSetArg(wargs[n], XtNforceColumns,True); n++;
  let=XtCreateManagedWidget("",listWidgetClass,vp,wargs,n);
  n=0;
  XtSetArg(wargs[n], XtNfromVert, vp); n++;
  XtSetArg(wargs[n], XtNresizable,True); n++;
  lstat= XtCreateManagedWidget("",labelWidgetClass,form,wargs, n);
  setlstat("xzip by softguy@citiz.net",0);
  

  XtRealizeWidget(toplevel);  fd=new dfile(toplevel); bf=new basefile("");
  enablemenu(); rhelp(); XtAppMainLoop(appcon); 
 }

int xzip::name2color(Widget w, char *name)
 {Display *display; int  screen; Colormap cmap; XColor    color, exact;

  display = XtDisplay(w);  screen = DefaultScreen(display);
  cmap = DefaultColormap(display, screen);

  XAllocNamedColor(display, cmap, name,  &color, &exact);
  return(color.pixel);
 }

void xzip::radd(char *s1,char *s2)
 {char s[BUFSIZ]; strcpy(s,s1); strcat(s,s2); 
  if(bf->add(s)!=0) {setlstat("Error of Adding",2); return;}
  XawListChange(let,bf->list(),0,0,True); setlstat("OK of Adding",1); 
 }

void xzip::rnewzip(char *s1,char *s2)
 {char s[BUFSIZ]; Arg wargs[1];
  strcpy(s,s1); strcat(s,s2); 
  if(bf->type(s)!=ZIPBALL) strcat(s,".zip"); 
  if(bf->newzip(s)!=0) {setlstat("Error of Creating zip",2); return;}
  delete bf; bf=new zipfile(s);
  XawListChange(let,bf->list(),0,0,True); setlstat("OK of Creating zip",1); 
  XtSetArg(wargs[0], XtNtitle, bf->cfn); XtSetValues(toplevel,wargs,1); 
  enablemenu();
 }

void xzip::rnewtgz(char *s1,char *s2)
 {char s[BUFSIZ]; Arg wargs[1];
  strcpy(s,s1); strcat(s,s2); 
  if(bf->type(s)!=TGZBALL) strcat(s,".tgz"); 
  if(bf->newtgz(s)!=0) {setlstat("Error of Creating tgz",2); return;}
  delete bf; bf=new tzfile(s,"gzip"); bf->test();
  XawListChange(let,bf->list(),0,0,True); setlstat("OK of Creating tgz",1); 
  XtSetArg(wargs[0], XtNtitle, bf->cfn); XtSetValues(toplevel,wargs,1); 
  enablemenu();
 }

void xzip::rnewtar(char *s1,char *s2)
 {char s[BUFSIZ],*p=s; Arg wargs[1];
  strcpy(s,s1); strcat(s,s2); 
  if(bf->type(s)!=TARBALL) strcat(s,".tar"); 
  if(bf->newtar(s)!=0) {setlstat("Error of Creating tar",2); return;}
  delete bf; bf=new tarfile(s);
  XawListChange(let,bf->list(),0,0,True); setlstat("OK of Creating tar",1); 
  XtSetArg(wargs[0], XtNtitle, bf->cfn); XtSetValues(toplevel,wargs,1); 
  enablemenu();
 }



void xzip::rextract(char *s1,char *s2)
 {XawListReturnStruct *l=XawListShowCurrent(let); char d[BUFSIZ];
  if(strlen(l->string)==0) d[0]='\0'; else gettoken(l->string,1,d);
  if(bf->extract(s1,d)!=0)  {setlstat("Error of Extracting",2); return;} 
  setlstat("OK of Extracting",1);
 }
 
void xzip::ropen(char *s1,char *s2)
 {char n[BUFSIZ]; Arg wargs[1]; string s3; basefile *b;  int t;
  strcpy(n,s1); strcat(n,s2);

  t=b->type(n); 
  if(t==NOTBALL)  {setlstat("Unidentifuied file type",2); return;} 
  if(t==BZ2BALL) b=new zfile(n,"bzip2"); 
  if(t==GZBALL)  b=new zfile(n,"gzip"); 
  if(t==TGZBALL) b=new tzfile(n,"gzip"); 
  if(t==TB2BALL) b=new tzfile(n,"bzip2"); 
  if(t==TARBALL) b=new tarfile(n); 
  if(t==ZIPBALL) b=new zipfile(n); printf("t=%d\n",b->test());
  if(b->test()==0) 
   {XawListChange(let,b->list(),0,0,True);  
    XtSetArg(wargs[0], XtNtitle, b->cfn); XtSetValues(toplevel,wargs,1); 
    setlstat("OK of Opening",1); delete bf; bf=b; enablemenu(); return;
   }
  setlstat("Error of Opening",2);  delete b;
 }

void xzip::bcancel(Widget w,XtPointer client,XtPointer call)
 {XtPopdown(dhelp); }

void xzip::brun(Widget w,Widget client,XtPointer call)
 {char *s = XawDialogGetValueString(client);
  system(s); XtPopdown(dhelp); 
 }



void xzip::rhelp() 
 {Widget  dialog;Arg  wargs[10];      int  n;

  dhelp=XtVaCreatePopupShell("Help",transientShellWidgetClass,toplevel,NULL);
  dialog = XtCreateManagedWidget("dialog",dialogWidgetClass,dhelp, NULL, 0);

  n=0;
  XtSetArg(wargs[n], XtNlabel, "Help is in HTML.\nRun Netscape?\n"); n++;
  XtSetArg(wargs[n], XtNvalue, "netscape readme.html &"); n++;
  XtSetValues(dialog,wargs,n);

  XawDialogAddButton(dialog,"Run",brun,dialog);
  XawDialogAddButton(dialog,"Cancel",bcancel,NULL);
  XtRealizeWidget(dhelp);
 } 
