/*

xtar
by softguy@citiz.net

*/

#define tbwidth 18
#define tbheight 18
#define tbnum 8
static char tbbits[8][54]={
 {0x00,0x00,0xfc,0x00,0x00,0xfc,0x00,0x00,0xfc,0xf8,0x07,0xfc,0x08,0x0c,0xfc,
 0x08,0x14,0xfc,0x08,0x3c,0xfc,0x08,0x20,0xfc,0x08,0x20,0xfc,0x08,0x20,0xfc,
 0x08,0x20,0xfc,0x08,0x20,0xfc,0x08,0x20,0xfc,0x08,0x20,0xfc,0x08,0x20,0xfc,
 0xf8,0x3f,0xfc,0x00,0x00,0xfc,0x00,0x00,0xfc},
 {0x00,0x00,0xfc,0x00,0x00,0xfc,0x00,0x00,0xfc,0x00,0x38,0xfc,0x00,0x44,0xfd,
 0x00,0x80,0xfd,0x38,0xc0,0xfd,0xc4,0x1f,0xfc,0x04,0x10,0xfc,0x04,0x10,0xfc,
 0x84,0xff,0xff,0xc4,0xff,0xfd,0xc4,0xff,0xfc,0xf4,0x7f,0xfc,0xfc,0x3f,0xfc,
 0xfc,0x1f,0xfc,0x00,0x00,0xfc,0x00,0x00,0xfc},
 {0x00,0x00,0xfc,0x00,0x00,0xfc,0xfc,0x01,0xfc,0x84,0x02,0xfc,0x84,0x07,0xfc,
 0xf4,0x05,0xfc,0x84,0x3f,0xfc,0xf4,0x50,0xfc,0x84,0xf0,0xfc,0xf4,0xbe,0xfc,
 0x84,0x80,0xfc,0xfc,0xbe,0xfc,0x80,0x80,0xfc,0x80,0xbe,0xfc,0x80,0x80,0xfc,
 0x80,0xff,0xfc,0x00,0x00,0xfc,0x00,0x00,0xfc},
 {0xff,0xff,0x03,0xff,0xff,0x03,0x07,0xf0,0x03,0xfb,0xe7,0x03,0xfb,0xd7,0x03,
 0xfd,0x87,0x03,0xfd,0x7f,0x03,0xdd,0xef,0x02,0xcd,0xcf,0x02,0x05,0x83,0x02,
 0x05,0x83,0x02,0xcd,0xcf,0x02,0xdb,0xef,0x02,0xfb,0x7f,0x03,0x07,0x80,0x03,
 0xff,0xff,0x03,0xff,0xff,0x03,0xff,0xff,0x03},
 {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf8,0x01,0x00,0x20,0x03,0x00,
 0x20,0x05,0x00,0x40,0x07,0x00,0x44,0x44,0x00,0x4c,0x64,0x00,0x5f,0xf4,0x01,
 0x5f,0xf4,0x01,0x4c,0x64,0x00,0x44,0x44,0x00,0x20,0x08,0x00,0x20,0x08,0x00,
 0xf8,0x1f,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
 {0xff,0xff,0x03,0xff,0xff,0x03,0xff,0xff,0x03,0xff,0xc1,0x03,0xff,0x9d,0x03,
 0xff,0x5d,0x03,0xff,0x05,0x02,0xff,0xfd,0x02,0x7f,0x85,0x02,0xbf,0xfd,0x02,
 0xdf,0x85,0x02,0xed,0xfd,0x02,0xf1,0x01,0x02,0xf1,0xff,0x03,0xe1,0xff,0x03,
 0xff,0xff,0x03,0xff,0xff,0x03,0xff,0xff,0x03},
 {0x00,0x00,0x00,0x00,0x40,0x00,0x00,0x20,0x00,0x00,0x10,0x00,0x00,0x09,0x00,
 0x00,0x07,0x00,0x00,0x07,0x00,0x3e,0x0f,0x00,0x62,0x00,0x00,0xa2,0x00,0x00,
 0xfa,0x01,0x00,0x02,0x01,0x00,0x7a,0x01,0x00,0x02,0x01,0x00,0x7a,0x01,0x00,
 0x02,0x01,0x00,0xfe,0x01,0x00,0x00,0x00,0x00},
 {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x30,0x00,
 0x70,0x38,0x00,0xe0,0x1c,0x00,0xc0,0x0f,0x00,0x80,0x07,0x00,0x80,0x07,0x00,
 0xc0,0x0f,0x00,0xe0,0x1c,0x00,0x70,0x38,0x00,0x30,0x30,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}
};

#include  <X11/StringDefs.h>
#include  <X11/Intrinsic.h>
#include  <X11/Xaw/Form.h>
#include  <X11/Xaw/Label.h>
#include  <X11/Xaw/SimpleMenu.h>
#include  <X11/Xaw/SmeBSB.h>
#include  <X11/Xaw/MenuButton.h>
#include  <X11/Xaw/SmeLine.h>
#include  <X11/Xaw/AsciiText.h> 
#include  <X11/Xaw/Viewport.h>
#include  <X11/Xaw/List.h>

#include  <stdio.h>
#include  <stdlib.h>

#include "msgbox.h"
#include "fdbox.h"

Widget toplevel,ltar;
char *clstar[2048], ctarfile[BUFSIZ]={'\0'};
int isortby,isp;
Pixmap pmtb[tbnum];
static Atom wm_delete_window;

void mquit(Widget w,XtPointer client,XtPointer call)
 {int i; for(i=0;i<tbnum;i++) XFreePixmap(XtDisplay(toplevel), pmtb[i]);
   exit(0);
 }

static XtActionsRec xtar_actions[] = {
    { "quit",	mquit },
};

int iszip(char *c)
 {FILE *f=fopen(c,"r");  if(f==NULL) return 0;
  if(fgetc(f)!=31)  {fclose(f); return 0; }
  if(fgetc(f)!=139) {fclose(f); return 0; }
  fclose(f); return 1; 
 }

void msavepath(Widget w,XtPointer client,XtPointer call)
 {Arg warg;
  if(isp==0) {isp=1; XtSetArg(warg, XtNlabel,"X SavePath");}
  else {isp=0; XtSetArg(warg, XtNlabel,"SavePath  ");}
  XtSetValues(w,&warg,1);
 }

int addtar(char *p,char *n)
 {char b[BUFSIZ]; 
  sprintf(b,"tar -C %s -rvf %s %s%s",p,ctarfile,(isp)?p:"",n);
  if(system(b)!=0) return -1; listtar(ctarfile);
 }

void madd(Widget w,XtPointer client,XtPointer call)
 {if(ctarfile[0]=='\0') return; 
  if(iszip(ctarfile)) 
   {setmb(toplevel,"Can't add files to compressed tar files.\nPlease use File/Unzip to uncompress it first.","Error");
    return;
   }
  setfd(toplevel,".","Add",addtar);
 }

int listtar(char *t)
 {int j,i=0; FILE *f; char b[BUFSIZ]; Arg warg[1];
  sprintf(b,"tar -tv%sf %s",iszip(t)?"z":"",t);

  if(system(b)!=0) return -1;
  f=popen(b,"r");
  if(!f) {setmb(toplevel,"error","Error");return -1;}
  while(fgets(b,BUFSIZ,f)!=NULL) 
   {for(j=0;j<BUFSIZ;j++) if(b[j]=='\n') {b[j]='\0';break;}
    clstar[i]=(char *)malloc(j+1); strcpy(clstar[i],b); i++;
   } if(ferror(f)) return -1;
  if(i==0) clstar[0]=NULL; 
  XtSetArg(warg[0],XtNnumberStrings,i); XtSetValues(ltar,warg,1); 
  XawListChange(ltar,clstar,i,0,True);  isortby=0;
  pclose(f); return 0;
 }

int opentar(char *p,char *n)
 {char b[BUFSIZ]; Arg wargs[10];    
  strcpy(b,p); strcat(b,n); 
  if(listtar(b)==0) 
   {strcpy(ctarfile,b); sprintf(b,"%s - xtar by softguy@citiz.net",ctarfile);
    XtSetArg(wargs[0],XtNtitle,b); XtSetValues(toplevel,wargs,1);
   }
 }

void gettoken(char *s1,int n,char *s2)
 {int i; char *p,b[BUFSIZ]; strcpy(b,s1);
  p=strtok(b," \t"); 
  for(i=1;i<n;i++) p=strtok(NULL," \t"); strcpy(s2,p); 
 }

int cmpitem(char **c1,char **c2) 
 {char t1[BUFSIZ],t2[BUFSIZ]; 
  gettoken(*c1,isortby,t1); gettoken(*c2,isortby,t2);
  if(isortby==3) if(strlen(t1)>strlen(t2)) return 1; 
  else if (strlen(t1)<strlen(t2)) return -1; 
  return strcmp(t1,t2);
 }

void msort(Widget w,XtPointer client,XtPointer call)
 {String s1; Arg warg[1]; int j;
  if(ctarfile[0]=='\0') return;
  XtSetArg(warg[0],XtNlabel,&s1); XtGetValues(w,warg,1);
  switch(s1[0])
   {case 'N': isortby=6; break;
    case 'D': isortby=4; break;
    case 'O': isortby=2; break;
    case 'S': isortby=3; break;
    case 'U': isortby=0; listtar(ctarfile); return;
   }
  if(isortby!=0)
   {XtSetArg(warg[0],XtNnumberStrings,&j); XtGetValues(ltar,warg,1);
    qsort(clstar,j,sizeof(char *),cmpitem); 
   }
  XawListChange(ltar,clstar,j,0,True); 
 }

void mdelete(Widget w,XtPointer client,XtPointer call)
 {XawListReturnStruct *l=XawListShowCurrent(ltar);
  char t[BUFSIZ],c[BUFSIZ]; int i;
  if(l->list_index==XAW_LIST_NONE) return; 
  if(iszip(ctarfile)) 
   {setmb(toplevel,"Can't delete files in compressed tar files.\nPlease use File/Unzip to uncompress it first.","Error");   return;
   }
  gettoken(l->string,6,t); sprintf(c,"tar --delete --file=%s %s",ctarfile,t);
  if(system(c)!=0) return; listtar(ctarfile);
 }

void mopen(Widget w,XtPointer client,XtPointer call)
 {setfd(toplevel,".","Open",opentar);}

int extracttar(char *p,char *n)
 {char t[BUFSIZ],b[BUFSIZ]; XawListReturnStruct *l=XawListShowCurrent(ltar);

  if(l->list_index==XAW_LIST_NONE) t[0]='\0'; else gettoken(l->string,6,t);
  sprintf(b,"tar -C %s -xv%sf %s %s",p,iszip(ctarfile)?"z":"",ctarfile,t); 
  if(system(b)!=0) return -1; 
 }

void mextract(Widget w,XtPointer client,XtPointer call)
 {if(ctarfile[0]=='\0') return;  setfd(toplevel,".","Extract",extracttar);
 }

int newtar(char *p,char *n)
 {Arg warg[1]; int i; char b[BUFSIZ]; FILE*f;
  sprintf(b,"%s%s",p,n);  f=fopen(b,"w"); if(f==NULL) return -1;
  for(i=0;i<10240;i++) if(EOF==fputc(0,f)) {fclose(f); return -1;}
  if(fclose(f)==EOF) return -1; 
  strcpy(ctarfile,b);sprintf(b,"%s - xtar by softguy@citiz.net",ctarfile);
  XtSetArg(warg[0],XtNtitle,b); XtSetValues(toplevel,warg,1);
  listtar(ctarfile); return 0; 
 }

void mnew(Widget w,XtPointer client,XtPointer call)
 {setfd(toplevel,".","New",newtar); }

int copytar(char *p,char *n)
 {char b[BUFSIZ]; 
  sprintf(b,"cp %s %s%s",ctarfile,p,n);
  if(system(b)!=0) return -1; 
 }

void mcopy(Widget w,XtPointer client,XtPointer call)
 {if(ctarfile[0]=='\0') return; setfd(toplevel,".","Copy",copytar); }

int ziptar(char *p,char *n)
 {char b[BUFSIZ]; 
  sprintf(b,"gzip -c %s > %s%s",ctarfile,p,n);
  if(system(b)!=0) return -1; 
 }

void mzip(Widget w,XtPointer client,XtPointer call)
 {if(ctarfile[0]=='\0') return; if(iszip(ctarfile)) return; 
  setfd(toplevel,".","Zip",ziptar);
 }

int unziptar(char *p,char *n)
 {char b[BUFSIZ]; 
  sprintf(b,"gunzip -c %s > %s%s",ctarfile,p,n);
  if(system(b)!=0) return -1; opentar(p,n);
 }

void munzip(Widget w,XtPointer client,XtPointer call)
 {if(ctarfile[0]=='\0') return; if(!iszip(ctarfile)) return; 
  setfd(toplevel,".","Unzip",unziptar);
 }

void mabout(Widget w,XtPointer client,XtPointer call)
 {setmb(toplevel,"            xtar\n    by softguy@citiz.net\n\nIf you have anything to say,\nplease reach me by email.\n","About");}

void mhelp(Widget w,XtPointer client,XtPointer call)
 {setmb(toplevel,"                               Help\n\nThis program is an X interface to process tar/tgz files. It works by\ncalling tar/gzip/gunzip. Below are descriptions of menu options. If\nyou have any question, please write to softguy@citiz.net\n\nFile/New: Create a new unzipped tar file\n\nFile/Open: Open a tar or tgz file\n\nFile/Copy: Copy the working file to a path of your choice\n\nFile/Unzip: Unzip the working tgz file to a path of your choice and\nopen it\n\nFile/Zip: Zip the working tar file to a path of your choice\n\nTar/Add: Append a file to the working tar file\n\nTar/Delete: Delete a selected file in the working tar file\n\nTar/Extract: Extract the selected file to a path of your choice. If\nnone is selected, all files will be extracted.\n\nTar/SavePath: This option is used when you Tar/Add. If selected, it\nwill save the path of the file to be added.","Help");}

main(int argc,char **argv)
 {XtAppContext appcon;  
  Widget form,buttons[4],menus[4],entry,vp,tb[tbnum];
  int i, n; Arg wargs[10];    
  char *mn[]={"menu1","menu2","menu3","menu4"};
  char *bn[]={"File","Tar","Sort","Help"};

  XtSetLanguageProc(NULL, NULL, NULL);
  toplevel=XtAppInitialize(&appcon,"xtar",NULL,0,&argc,argv,NULL,NULL,0);
  XtSetArg(wargs[0], XtNtitle,"xtar by softguy@citiz.net");
  XtSetValues(toplevel,wargs,1);
  XtAppAddActions (appcon, xtar_actions, XtNumber(xtar_actions));
  XtOverrideTranslations(toplevel, 
    XtParseTranslationTable ("<Message>WM_PROTOCOLS: quit()"));


  form = XtCreateManagedWidget("form", formWidgetClass, toplevel, NULL, 0);


  for(i=0;i<4;i++)
   {n = 0;
    XtSetArg(wargs[n], XtNmenuName, mn[i]); n++;
    buttons[i]=XtCreateManagedWidget(bn[i], menuButtonWidgetClass,form,wargs, n);
    menus[i]=XtCreatePopupShell(mn[i], simpleMenuWidgetClass,buttons[i], NULL, 0);
    if(i>0)
     {n = 0;  XtSetArg(wargs[n], XtNfromHoriz, buttons[i-1]); n++;
      XtSetValues(buttons[i],wargs,n);
     }
   }     

  for(i=0;i<tbnum;i++)
   pmtb[i]=XCreateBitmapFromData(XtDisplay(toplevel),RootWindowOfScreen(XtScreen(toplevel)),
    tbbits[i], tbwidth, tbheight);

  XtSetArg(wargs[0], XtNrightBitmap, pmtb[0]); 
  XtSetArg(wargs[1], XtNrightMargin, tbwidth); 
  entry = XtCreateManagedWidget("New", smeBSBObjectClass,menus[0],wargs,2);
  XtAddCallback(entry, XtNcallback, mnew, NULL);
  XtSetArg(wargs[0], XtNrightBitmap, pmtb[1]); 
  entry = XtCreateManagedWidget("Open", smeBSBObjectClass,menus[0],wargs,2);
  XtAddCallback(entry, XtNcallback, mopen, NULL);
  XtSetArg(wargs[0], XtNrightBitmap, pmtb[2]); 
  entry = XtCreateManagedWidget("Copy", smeBSBObjectClass,menus[0],wargs,2);
  XtAddCallback(entry, XtNcallback, mcopy, NULL);
  XtSetArg(wargs[0], XtNrightBitmap, pmtb[3]); 
  entry = XtCreateManagedWidget("Unzip", smeBSBObjectClass,menus[0],wargs,2);
  XtAddCallback(entry, XtNcallback, munzip, NULL);
  XtSetArg(wargs[0], XtNrightBitmap, pmtb[4]); 
  entry = XtCreateManagedWidget("Zip", smeBSBObjectClass,menus[0],wargs,2);
  XtAddCallback(entry, XtNcallback, mzip, NULL);
  entry=XtCreateManagedWidget("line1", smeLineObjectClass, menus[0], NULL, 0);
  entry=XtCreateManagedWidget("Quit", smeBSBObjectClass, menus[0], NULL, 0);
  XtAddCallback(entry, XtNcallback, mquit, NULL);

  XtSetArg(wargs[0], XtNrightBitmap, pmtb[6]); 
  entry = XtCreateManagedWidget("Add", smeBSBObjectClass,menus[1],wargs,2);
  XtAddCallback(entry, XtNcallback, madd, NULL);
  XtSetArg(wargs[0], XtNrightBitmap, pmtb[7]); 
  entry = XtCreateManagedWidget("Delete",smeBSBObjectClass,menus[1],wargs,2);
  XtAddCallback(entry, XtNcallback, mdelete, NULL);
  XtSetArg(wargs[0], XtNrightBitmap, pmtb[5]); 
  entry = XtCreateManagedWidget("Extract",smeBSBObjectClass,menus[1],wargs,2);
  XtAddCallback(entry, XtNcallback, mextract, NULL);
  entry=XtCreateManagedWidget("line1", smeLineObjectClass, menus[1], NULL, 0);
  entry=XtCreateManagedWidget("SavePath  ", smeBSBObjectClass, menus[1], NULL, 0);
  XtAddCallback(entry, XtNcallback, msavepath, NULL);

  entry = XtCreateManagedWidget("Date", smeBSBObjectClass,menus[2], NULL, 0);
  XtAddCallback(entry, XtNcallback, msort, NULL);
  entry = XtCreateManagedWidget("Name", smeBSBObjectClass,menus[2], NULL, 0);
  XtAddCallback(entry, XtNcallback, msort, NULL);
  entry = XtCreateManagedWidget("Owner", smeBSBObjectClass,menus[2], NULL, 0);
  XtAddCallback(entry, XtNcallback, msort, NULL);
  entry = XtCreateManagedWidget("Size", smeBSBObjectClass,menus[2], NULL, 0);
  XtAddCallback(entry, XtNcallback, msort, NULL);
  entry=XtCreateManagedWidget("line1", smeLineObjectClass, menus[2], NULL, 0);
  entry = XtCreateManagedWidget("Unsort", smeBSBObjectClass,menus[2], NULL, 0);
  XtAddCallback(entry, XtNcallback, msort, NULL);

  entry = XtCreateManagedWidget("Help", smeBSBObjectClass,menus[3], NULL, 0);
  XtAddCallback(entry, XtNcallback, mhelp, NULL);
  entry = XtCreateManagedWidget("About", smeBSBObjectClass,menus[3], NULL, 0);
  XtAddCallback(entry, XtNcallback, mabout, NULL);

 
  for(i=0;i<tbnum;i++)
   {n=0;
    XtSetArg(wargs[n], XtNbitmap,pmtb[i]); n++;
    XtSetArg(wargs[n], XtNfromVert, buttons[0]); n++;
    XtSetArg(wargs[n], XtNinternalWidth,0); n++;
    XtSetArg(wargs[n], XtNinternalHeight,0); n++;
    XtSetArg(wargs[n], XtNvertDistance,0); n++;
    XtSetArg(wargs[n], XtNhorizDistance,0); n++;
    XtSetArg(wargs[n], XtNborderWidth,0); n++;
    if(i>0) {XtSetArg(wargs[n], XtNfromHoriz,tb[i-1]); n++;}
    tb[i]=XtCreateManagedWidget("",commandWidgetClass,form,wargs,n);
   }
  XtAddCallback(tb[0], XtNcallback,mnew,NULL);
  XtAddCallback(tb[1], XtNcallback,mopen,NULL);
  XtAddCallback(tb[2], XtNcallback,mcopy,NULL);
  XtAddCallback(tb[3], XtNcallback,munzip,NULL);
  XtAddCallback(tb[4], XtNcallback,mzip,NULL);
  XtAddCallback(tb[5], XtNcallback,mextract,NULL);
  XtAddCallback(tb[6], XtNcallback,madd,NULL);
  XtAddCallback(tb[7], XtNcallback,mdelete,NULL);

  n = 0;
  XtSetArg(wargs[n], XtNfromVert, tb[0]); n++;
  XtSetArg(wargs[n], XtNforceBars,True); n++;
  XtSetArg(wargs[n], XtNallowVert,True); n++;
  XtSetArg(wargs[n], XtNuseRight,True); n++;
  XtSetArg(wargs[n], XtNheight,HeightOfScreen(DefaultScreenOfDisplay(XtDisplay(toplevel)))*2/3); n++;
  vp=XtCreateManagedWidget("vp",viewportWidgetClass,form,wargs,n);
  n=0;
  XtSetArg(wargs[n], XtNwidth,WidthOfScreen(DefaultScreenOfDisplay(XtDisplay(toplevel)))*2/3); n++;
  XtSetArg(wargs[n], XtNdefaultColumns,1); n++;
  XtSetArg(wargs[n], XtNlist,clstar); n++;
  XtSetArg(wargs[n], XtNforceColumns,True); n++;
  ltar=XtCreateManagedWidget("",listWidgetClass,vp,wargs,n);

  XtRealizeWidget(toplevel);  
  wm_delete_window = XInternAtom (XtDisplay(toplevel), "WM_DELETE_WINDOW", False);
  (void) XSetWMProtocols (XtDisplay(toplevel), XtWindow(toplevel), &wm_delete_window, 1);

  XtAppMainLoop(appcon);
 }


/*
  entry=XtCreateManagedWidget("OverWrite  ", smeBSBObjectClass, menus[1], NULL, 0);
  XtAddCallback(entry, XtNcallback, moverwrite, NULL);

fillout(ldir); XtAddCallback(ldir, XtNcallback,change,NULL);

void moverwrite(Widget w,XtPointer client,XtPointer call)
 {Arg wargs[10];    
  XtSetArg(wargs[0], XtNlabel,"X OverWrite"); XtSetValues(w,wargs,1);
 }
int endswith(char *c1,char *c0)
 {int l1=strlen(c1),l0=strlen(c0); char *p=c1;
  if(l1<l0) return -1; p=p+(l1-l0); return strncasecmp(p,c0,l0);
 }

 if(endswith(c,".tgz")==0 || endswith(c,".tar.gz")==0 || 
     endswith(c,".tar.z")==0) return 0; 

  strcpy(b,"tar -tvf "); strcat(b,t); 
*/

/* if(rindex(*c1,'/')!=NULL && rindex(*c2,'/')==NULL) return -1;
  if(rindex(*c1,'/')==NULL && rindex(*c2,'/')!=NULL) return 1; */

/*
"                     xtar\n             by softguy@citiz.net\n\nThis is begware
or shareware. If you enjoy it,\nyou should pay the author $20. For my address,
\nplease send me an email.\n\n"
*/
