/*
 * tzx V1.00 - a simplier and hopefully more robust transparent executable
 * compression.
 *
 * Oleg Kibirev * April 1995 * oleg@gd.cs.CSUFresno.EDU
 *
 * This code is covered by General Public License, version 2 or any later
 * version of your choice. You should recieve file "COPYING" which contains
 * text of the license with any distribution of this program; if you don't 
 * have it, a copy is available from ftp.gnu.ai.mit.edu.
 */

#define UNTZX
#include "tzx.h"

static void do_nothing() {}

main(argc, argv)
     char **argv;
{
  char *p, *t, *basename;
  int uid = getuid(), euid = geteuid();
  int oldumask = umask(0);
  int fd, mfd, lfd, i;
  char buf[MAXPATHLEN];
  static struct sigaction sa, osa, osat;

  if(argc < 2) {
    fputs("Usage: untzx [file].\n", stderr);
    return -1;
  }

  setreuid(euid, uid);
  
  if(strchr(argv[1], '/') || !(p = getenv("PATH")))
    fd = open(argv[1], O_RDONLY);
  else {
    for(;;) {
      t = strchr(p, ':');
      if(!t)
	sprintf(buf, *p ? "%s/%s" : "%s%s", p, argv[1]);
      else if(t == p)
	strcpy(buf, argv[1]);
      else {
	memcpy(buf, p, t-p);
	buf[t-p] = '/';
	strcpy(buf + (t - p) + 1, argv[1]);
      }
      
      if((fd = open(buf, O_RDONLY)) >= 0 || !t)
	break;
      p = t + 1;
    }
  }

  if(fd < 0) {
    perror(argv[1]);
    return 127;
  }

  lseek(fd, sizeof(signature)-1, SEEK_SET);

  setreuid(uid, euid);

  if(mkdir(zdir, 0755) < 0 && errno != EEXIST) {
    perror(zdir);
    return -1;
  }

  /*
   * Refuse to get suspended while holding a lock.
   */

  sa.sa_handler = SIG_IGN;
  sa.sa_mask = 0;
  sa.sa_flags = SA_RESTART;
  sigaction(SIGTSTP, &sa, &osa);
  sigaction(SIGTTOU, &sa, &osat);
  /* I am not planning to _read_ from the terminal, it seams */


  /*
   * Get a lock.
   */

  if((lfd = open(dzmaster_lock, O_RDWR|O_CREAT, 0644)) < 0 ||
     flock(lfd, LOCK_EX) < 0) {
    perror(dzmaster_lock);
    return -1;
  }

  /*
   * Either no tzx process is active or an uncompressed program is already
   * running. In either case, it won't hurt to purge it.
   */

  unlink(dzmaster);
  
  if((mfd = open(dzmaster, O_RDWR|O_CREAT|O_EXCL, 0755)) < 0) {
    perror(dzmaster);
    return -1;
  }
    
  fcntl(fd, F_SETFD, 1);
  fcntl(mfd, F_SETFD, 1);
  fcntl(lfd, F_SETFD, 1);

  switch(i = vfork()) {
  case -1:
    perror("vfork");
    return -1;
  case 0:
    dup2(fd, 0);
    dup2(mfd, 1);
    execl(gzip, gzip, "-d", NULL);
    perror("execl");
    _exit(127);
  default: {
    int status, e;
    waitpid(i, &status, 0);
    if(!WIFEXITED(status) || (e = WEXITSTATUS(status))) {
      if(e != 127)
	fprintf(stderr, "%s exited with error code %d\n", gzip, e);
      return e;
    }
  }
  }
  
  {
    char b[2];
    /*
     * Check if this is a shell script. If so, we have to set it's argv[0]
     * to it's real location. We also have a race condition if zmaster gets
     * deleted before shell opens it. But I guess it's better than nothing.
     */
    lseek(mfd, SEEK_SET, 0);
    if(read(mfd, b, 2) == 2 && b[0] == '#' && b[1] == '!')
      argv[1] = dzmaster;
  }

  /*
   * Cleanup.
   */

  setuid(uid);
  umask(oldumask);

  /* Reset signals *only after execv succeeds* */
  if(osa.sa_handler  == SIG_DFL) osa.sa_handler  = do_nothing;
  if(osat.sa_handler == SIG_DFL) osat.sa_handler = do_nothing;
  sigaction(SIGTSTP, &osa, NULL);
  sigaction(SIGTTOU, &osat, NULL);
  close(mfd);

  execv(dzmaster, argv+1);
  perror(argv[1]);
  return 127;
}
