#include "common.h"
#include "main.h"
#include "logo.xpm"

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/wait.h>
#include <signal.h>
#include <string.h>

GtkWidget *clist;
GtkWidget *statusbar;
guint statusbar_id;
unsigned int statusbar_total;
GtkWidget *aboutwin;
char aboutboxopen;

void create_aboutwin();
GtkWidget* create_viewwin(char *fn, char *realfn);

#ifndef GTK_HAVE_FEATURES_1_1_2
#ifndef _SET_MODAL_DEFINED_
#define _SET_MODAL_DEFINED_
// From gtk+ 1.1.2's gtkwindow.c -- modified a bit
void gtk_window_set_modal (GtkWindow *window, gboolean modal)
{
  g_return_if_fail (window != NULL);
  g_return_if_fail (GTK_IS_WINDOW (window));

  /* If the widget was showed already, adjust it's grab state */
  if (GTK_WIDGET_VISIBLE(GTK_WIDGET(window)))
    {
      if (!modal)
	gtk_grab_remove (GTK_WIDGET(window));
      else if (modal)
	gtk_grab_add (GTK_WIDGET(window));
    }
}
#endif
#endif

gint delete_event(GtkWidget *widget, GdkEvent *event, gpointer data)
{
 return (FALSE);
}

void destroy (GtkWidget *widget, gpointer data)
{
gtk_main_quit ();
}

GtkWidget* new_pixmap (gchar *filename[], GdkWindow *window, GdkColor  *background)
{
  GtkWidget *wpixmap;
  GdkPixmap *pixmap;
  GdkBitmap *mask;
  pixmap = gdk_pixmap_create_from_xpm_d (window, &mask, background,filename);
  wpixmap = gtk_pixmap_new (pixmap, mask);
  gdk_pixmap_unref (pixmap);
  return wpixmap;
}

void PopStatusbar()
{
gtk_statusbar_pop(GTK_STATUSBAR(statusbar),statusbar_id);
statusbar_total--;
}

void PushStatusbar(char *desc)
{
while (statusbar_total>0) PopStatusbar();
gtk_statusbar_push(GTK_STATUSBAR(statusbar),statusbar_id,desc);
statusbar_total++;
}


#ifdef _CLISTSORT_
void clist_click_column (GtkCList *aclist, gint column, gpointer data)
{
  if (column == aclist->sort_column)
    {
      if (aclist->sort_type == GTK_SORT_ASCENDING)
	aclist->sort_type = GTK_SORT_DESCENDING;
      else
	aclist->sort_type = GTK_SORT_ASCENDING;
    }
  else
    gtk_clist_set_sort_column (aclist, column);

  gtk_clist_sort(aclist);
}
#endif

/*
 * DOES NOT WORK! blame tar
void delete_files()
{
  GList *list;
  gchar *t;
  gint row;
  FILE *f;
  pid_t pid;
  char *tmp1,*tmp2;
  char curdir[256];

  PushStatusbar("Deleting files...");
  while (gtk_events_pending()) gtk_main_iteration();

  tmp1=tempnam(NULL,"guitar");
  tmp2=tempnam(NULL,"guitar");
  f=fopen(tmp1,"w");
  list = GTK_CLIST(clist)->selection;
  while (list)
	{
	row=(gint)list->data;
    gtk_clist_get_text(GTK_CLIST(clist),row,5,&t);
    fprintf(f,"%s\n",t);
	list = list->next;
	}
  fclose(f);

  while (gtk_events_pending()) gtk_main_iteration();

  pid=fork();
  if (!pid)
    {
	f=fopen(tmp2,"w");
    fprintf(f,"#/bin/sh\n");
    fprintf(f,"tar --delete vf%c %s --files-from=%s",uncomp,ourfile,tmp1);
    fclose(f);

	chmod(tmp2,S_IRUSR | S_IWUSR | S_IXUSR);
	execlp(tmp2,tmp2,NULL);
    exit(0);
    }
  pid=wait(NULL);

  chdir(curdir);

  PopStatusbar();
  remove(tmp1); free(tmp1);
  remove(tmp2); free(tmp2);
}
*/


void view_file_real(char fn[])
{
  pid_t pid;
  FILE *f;
  char *tmp1,*tmp2;

  PushStatusbar("Viewing file...");

  tmp1=tempnam(NULL,"guitar");
  tmp2=tempnam(NULL,"guitar");

  pid=fork();
  if (!pid)
    {
	f=fopen(tmp1,"w");
    fprintf(f,"#/bin/sh\n");
	fprintf(f,"tar vfx%cO %s %s >%s",uncomp,ourfile,fn,tmp2);
    fclose(f);

	chmod(tmp1,S_IRUSR | S_IWUSR | S_IXUSR);
	execlp(tmp1,tmp1,NULL);
    exit(0);
    }
  pid=wait(NULL);

  create_viewwin(tmp2,fn);

  remove(tmp1); free(tmp1);
  remove(tmp2); free(tmp2);
}


void view_file()
{
  GList *list;
  gchar *t,*fl;
  gint row;
  char a;
  char b[256];
  
  if (GTK_CLIST(clist)->selection==NULL)
	{
    PushStatusbar("Please select a file first");
	return;
	}

while (GTK_CLIST(clist)->selection!=NULL)
  {
  a=0;
  list = GTK_CLIST(clist)->selection;
  while ((list) && (a==0))
	{
	row=(gint)list->data;
    gtk_clist_get_text(GTK_CLIST(clist),row,0,&fl);
    gtk_clist_unselect_row (GTK_CLIST(clist),row,0);
    list = GTK_CLIST(clist)->selection;

	if ((fl[0]!='d') && (fl[0]!='l'))
	  {
  	  gtk_clist_get_text(GTK_CLIST(clist),row,5,&t);
	  a=1;
	  }
	}

  if (a==0)
	{
    PushStatusbar("Please select a non-directory/non-link to view");
	return;
	}

  sprintf(b,"%s",t);
  view_file_real(b);
  }
}


void files_open_real(char fn[])
{
  pid_t pid;
  FILE *f;
  char d[7][256];
  gchar *add[7];
  unsigned int l,i;
  char ubak;
  char special;
  char *tmp1,*tmp2;

  if ((fn[0]=='/') && (fn[1]=='/')) memmove(fn,&fn[1],strlen(fn));

  if (access(fn,F_OK)!=0) // if file does not exist
	{
	PushStatusbar("File does not exist");
    return;
	}

  PushStatusbar("Opening file..");

  while (gtk_events_pending()) gtk_main_iteration();

  ubak=uncomp;
  uncomp=' ';
  l=strlen(fn);
  i=0; special=0;
  if ((fn[l-1]=='z') && (fn[l-2]=='g') && (fn[l-3]=='.')) { uncomp='z'; i=3; }
  if ((fn[l-1]=='Z') && (fn[l-2]=='.')) { uncomp='Z'; i=2; }
  if ((fn[l-1]=='2') && (fn[l-2]=='z') && (fn[l-3]=='b') && (fn[l-4]=='.')) { uncomp='I'; i=4; }

  if ((fn[l-1]=='z') && (fn[l-2]=='g') && (fn[l-3]=='t') && (fn[l-4]=='.')) { uncomp='z'; special=1; i=0; }
  if ((fn[l-1]=='p') && (fn[l-2]=='l') && (fn[l-3]=='s') && (fn[l-4]=='.')) { uncomp='I'; special=1; i=0; }

  if ((special==0) && ((fn[l-i-1]!='r') || (fn[l-i-2]!='a') || (fn[l-i-3]!='t') || (fn[l-i-4]!='.')))
	{
	PushStatusbar("Invalid filename");
	uncomp=ubak;
    return;
	}

  strcpy(ourfile,fn);
  sprintf(fn,"GuiTAR - %s",ourfile);
  gtk_window_set_title(GTK_WINDOW(win), fn);
  strcpy(fn,ourfile);

  tmp1=tempnam(NULL,"guitar");
  tmp2=tempnam(NULL,"guitar");
  pid=fork();
  if (!pid)
    {
	f=fopen(tmp1,"w");
    fprintf(f,"#/bin/sh\n");
    fprintf(f,"tar vft%c %s >%s",uncomp,fn,tmp2);
    fclose(f);

	chmod(tmp1,S_IRUSR | S_IWUSR | S_IXUSR);
	execlp(tmp1,tmp1,NULL);
    exit(0);
    }
  pid=wait(NULL);
  gtk_clist_clear(GTK_CLIST(clist));

  f=fopen(tmp2,"r");
  gtk_clist_freeze(GTK_CLIST(clist));

  while (!feof(f))  
	{
	strcpy(d[6],"");
	fscanf(f,"%s %s %s %s %s %s -> %s\n",d[0],d[1],d[2],d[3],d[4],d[5],d[6]);
	add[0]=d[0];
	add[1]=d[1];
	add[2]=d[2];
	add[3]=d[3];
	add[4]=d[4];
	add[5]=d[5];
	add[6]=d[6];
    gtk_clist_append(GTK_CLIST(clist),add);
	}

  gtk_clist_thaw(GTK_CLIST(clist));
  fclose(f);
  PopStatusbar();
  remove(tmp1); free(tmp1);
  remove(tmp2); free(tmp2);
}


void files_open(GtkWidget *w, GtkFileSelection *fs)
{
  char fn[512];

  sprintf(fn,"%s",gtk_file_selection_get_filename(GTK_FILE_SELECTION(fs)));
  gtk_object_destroy(GTK_OBJECT(fs));
  files_open_real(fn);  
}


void open_tar_dlg()
{
GtkWidget *files;

  files = gtk_file_selection_new ("Open TAR file");
  gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(files)->ok_button),"clicked",(GtkSignalFunc)files_open,files);
  gtk_signal_connect_object(GTK_OBJECT(GTK_FILE_SELECTION (files)->cancel_button),"clicked",(GtkSignalFunc)gtk_widget_destroy,GTK_OBJECT(files));
  gtk_window_set_modal(GTK_WINDOW(&GTK_FILE_SELECTION(files)->window),TRUE);
  gtk_widget_show(files);
}

void tar_extract(GtkWidget *w, GtkFileSelection *fs)
{
  GList *list;
  gchar *t;
  gint row;
  FILE *f;
  char fn[512];
  pid_t pid;
  char *tmp1,*tmp2;
  char curdir[256];

  sprintf(fn,"%s",gtk_file_selection_get_filename(GTK_FILE_SELECTION(fs)));
  gtk_object_destroy(GTK_OBJECT(fs));
  PushStatusbar("Extracting files...");
  while (gtk_events_pending()) gtk_main_iteration();

  tmp1=tempnam(NULL,"guitar");
  tmp2=tempnam(NULL,"guitar");
  f=fopen(tmp1,"w");
  list = GTK_CLIST(clist)->selection;
  while (list)
	{
	row=(gint)list->data;
    gtk_clist_get_text(GTK_CLIST(clist),row,5,&t);
    fprintf(f,"%s\n",t);
	list = list->next;
	}
  fclose(f);

  while (gtk_events_pending()) gtk_main_iteration();

  getcwd(curdir,256);
  if ((fn[0]=='/') && (fn[1]=='/')) memmove(fn,&fn[1],strlen(fn));
  chdir(fn);

  pid=fork();
  if (!pid)
    {
	f=fopen(tmp2,"w");
    fprintf(f,"#/bin/sh\n");
    fprintf(f,"tar fx%c %s --files-from=%s",uncomp,ourfile,tmp1);
    fclose(f);

	chmod(tmp2,S_IRUSR | S_IWUSR | S_IXUSR);
	execlp(tmp2,tmp2,NULL);
    exit(0);
    }
  pid=wait(NULL);

  chdir(curdir);

  PopStatusbar();
  remove(tmp1); free(tmp1);
  remove(tmp2); free(tmp2);
}

void extract_files()
{
GtkWidget *files;

  if (strcmp(ourfile,"")==0) return;
  
  files = gtk_file_selection_new ("Extract TAR file");
  gtk_widget_hide(GTK_FILE_SELECTION(files)->file_list);
  gtk_widget_hide(GTK_FILE_SELECTION(files)->fileop_del_file);
  gtk_widget_hide(GTK_FILE_SELECTION(files)->fileop_ren_file);
  gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(files)->ok_button),"clicked",(GtkSignalFunc)tar_extract,files);
  gtk_signal_connect_object(GTK_OBJECT(GTK_FILE_SELECTION (files)->cancel_button),"clicked",(GtkSignalFunc)gtk_widget_destroy,GTK_OBJECT(files));
  gtk_window_set_modal(GTK_WINDOW(&GTK_FILE_SELECTION(files)->window),TRUE);
  gtk_widget_show(files);
}

#ifdef _CLISTSELECTALL_
void select_all()
{
gtk_clist_select_all(GTK_CLIST(clist));
}

void deselect_all()
{
gtk_clist_unselect_all(GTK_CLIST(clist));
}
#endif

void create_win ()
{
  GtkWidget *vbox1;
  GtkWidget *handlebox1;
  GtkWidget *toolbar1;
  GtkWidget *label;

  win = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_container_border_width (GTK_CONTAINER (win), 2);
  gtk_window_set_title (GTK_WINDOW (win), "GuiTAR");
  gtk_window_set_policy (GTK_WINDOW (win), TRUE, TRUE, TRUE);
  gtk_window_position (GTK_WINDOW(win), GTK_WIN_POS_CENTER);
  gtk_widget_set_usize(win, 600, 300);
  gtk_signal_connect (GTK_OBJECT(win),"delete_event",GTK_SIGNAL_FUNC(delete_event),NULL);
  gtk_signal_connect (GTK_OBJECT(win),"destroy",GTK_SIGNAL_FUNC(destroy),NULL);

  vbox1 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox1);
  gtk_container_add (GTK_CONTAINER (win), vbox1);

  handlebox1 = gtk_handle_box_new ();
  gtk_widget_show (handlebox1);
  gtk_box_pack_start (GTK_BOX (vbox1), handlebox1, FALSE, FALSE, 0);

  toolbar1 = gtk_toolbar_new (GTK_ORIENTATION_HORIZONTAL, GTK_TOOLBAR_TEXT);
  gtk_widget_show (toolbar1);
  gtk_container_add (GTK_CONTAINER (handlebox1), toolbar1);
  gtk_toolbar_set_space_size(GTK_TOOLBAR(toolbar1), 10);

  gtk_toolbar_append_item(GTK_TOOLBAR(toolbar1),"Open", "Open a TAR file", "",
//			       new_pixmap (reply_xpm, win->window, &win->style->bg[GTK_STATE_NORMAL]),
			       NULL,
			       (GtkSignalFunc)open_tar_dlg, NULL);

  gtk_toolbar_append_item(GTK_TOOLBAR(toolbar1),"Extract", "Extract files", "",
			       NULL,
			       (GtkSignalFunc)extract_files, NULL);

  gtk_toolbar_append_item(GTK_TOOLBAR(toolbar1),"View", "View file", "",
			       NULL,
			       (GtkSignalFunc)view_file, NULL);

/*  gtk_toolbar_append_item(GTK_TOOLBAR(toolbar1),"Delete", "Delete files", "",
			       NULL,
			       (GtkSignalFunc)delete_files, NULL);
*/
  gtk_toolbar_append_space(GTK_TOOLBAR(toolbar1));

#ifdef _CLISTSELECTALL_
  gtk_toolbar_append_item(GTK_TOOLBAR(toolbar1),"Select all", "Select all files", "",
			       NULL,
			       (GtkSignalFunc)select_all, NULL);

  gtk_toolbar_append_item(GTK_TOOLBAR(toolbar1),"Deselect all", "Deselect all files", "",
			       NULL,
			       (GtkSignalFunc)deselect_all, NULL);

  gtk_toolbar_append_space(GTK_TOOLBAR(toolbar1));
#endif

  gtk_toolbar_append_item(GTK_TOOLBAR(toolbar1),"About", "About GuiTAR", "",
			       NULL,
			       (GtkSignalFunc)create_aboutwin, NULL);
  gtk_toolbar_append_item(GTK_TOOLBAR(toolbar1),"Quit", "Quit GuiTAR", "",
			       NULL,
			       (GtkSignalFunc)destroy, NULL);

  clist = gtk_clist_new (7);
  gtk_widget_show (clist);
  gtk_box_pack_start (GTK_BOX (vbox1), clist, TRUE, TRUE, 0);

  label = gtk_label_new("stats");
  gtk_widget_show(label);
  gtk_clist_set_column_widget(GTK_CLIST(clist), 0, label);
  gtk_label_set_justify(GTK_LABEL(label), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment(GTK_MISC(label), 0, 0);

  label = gtk_label_new("owner/group");
  gtk_widget_show(label);
  gtk_clist_set_column_widget(GTK_CLIST(clist), 1, label);
  gtk_label_set_justify(GTK_LABEL(label), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment(GTK_MISC(label), 0, 0);

  label = gtk_label_new("size");
  gtk_widget_show(label);
  gtk_clist_set_column_widget(GTK_CLIST(clist), 2, label);
  gtk_label_set_justify(GTK_LABEL(label), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment(GTK_MISC(label), 0, 0);

  label = gtk_label_new("date");
  gtk_widget_show(label);
  gtk_clist_set_column_widget(GTK_CLIST(clist), 3, label);
  gtk_label_set_justify(GTK_LABEL(label), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment(GTK_MISC(label), 0, 0);

  label = gtk_label_new("time");
  gtk_widget_show(label);
  gtk_clist_set_column_widget(GTK_CLIST(clist), 4, label);
  gtk_label_set_justify(GTK_LABEL(label), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment(GTK_MISC(label), 0, 0);

  label = gtk_label_new("file");
  gtk_widget_show(label);
  gtk_clist_set_column_widget(GTK_CLIST(clist), 5, label);
  gtk_label_set_justify(GTK_LABEL(label), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment(GTK_MISC(label), 0, 0);

  label = gtk_label_new("symlink");
  gtk_widget_show(label);
  gtk_clist_set_column_widget(GTK_CLIST(clist), 6, label);
  gtk_label_set_justify(GTK_LABEL(label), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment(GTK_MISC(label), 0, 0);

  gtk_clist_set_column_width (GTK_CLIST (clist), 0, 70);
  gtk_clist_set_column_width (GTK_CLIST (clist), 1, 80);
  gtk_clist_set_column_width (GTK_CLIST (clist), 2, 50);
  gtk_clist_set_column_width (GTK_CLIST (clist), 3, 80);
  gtk_clist_set_column_width (GTK_CLIST (clist), 4, 40);
  gtk_clist_set_column_width (GTK_CLIST (clist), 5, 160);
  gtk_clist_set_column_width (GTK_CLIST (clist), 6, 40);
  gtk_clist_set_selection_mode (GTK_CLIST (clist), GTK_SELECTION_MULTIPLE);

  gtk_clist_column_titles_show (GTK_CLIST (clist));
  gtk_clist_set_policy (GTK_CLIST (clist), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
#ifdef _CLISTSORT_
    gtk_signal_connect(GTK_OBJECT(clist),"click_column",(GtkSignalFunc)clist_click_column,NULL);
#endif

  statusbar=gtk_statusbar_new();
  gtk_widget_show(statusbar);
  gtk_box_pack_start(GTK_BOX(vbox1), statusbar, FALSE, TRUE, 0);
  statusbar_id=gtk_statusbar_get_context_id(GTK_STATUSBAR(statusbar),"statusbar");
  statusbar_total=0;

}


void close_about()
{
 gtk_widget_destroy(aboutwin);
 aboutboxopen=0;
}

void create_aboutwin ()
{
  GtkWidget *dialog_vbox1;
  GtkWidget *hbox;
  GtkWidget *label;
  GtkWidget *dialog_action_area1;
  GtkWidget *but_close;

  GtkWidget *pixmap1;
  GdkPixmap *pixmap;
  GdkBitmap *mask;
  GtkStyle *style;

if (aboutboxopen!=0) return;

  aboutwin = gtk_dialog_new ();
  gtk_object_set_data (GTK_OBJECT (aboutwin), "aboutwin", aboutwin);
  GTK_WINDOW (aboutwin)->type = GTK_WINDOW_DIALOG;
  gtk_window_set_title (GTK_WINDOW (aboutwin), "About GuiTAR (tm)");
  gtk_window_set_policy (GTK_WINDOW (aboutwin), FALSE, FALSE, TRUE);
  gtk_window_position (GTK_WINDOW (aboutwin), GTK_WIN_POS_CENTER);
  gtk_widget_realize(aboutwin);

  dialog_vbox1 = GTK_DIALOG (aboutwin)->vbox;
  gtk_widget_show (dialog_vbox1);

  hbox = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox);
  gtk_box_pack_start (GTK_BOX(dialog_vbox1), hbox, TRUE, TRUE, 0);

  style=gtk_widget_get_style(aboutwin);
  pixmap=gdk_pixmap_create_from_xpm_d(aboutwin->window,&mask,
							  &style->bg[GTK_STATE_NORMAL],(gchar **)logo_xpm);
  pixmap1=gtk_pixmap_new(pixmap,mask);
  gdk_pixmap_unref (pixmap);
  gtk_widget_show(pixmap1);
  gtk_box_pack_start(GTK_BOX(hbox),pixmap1,TRUE,TRUE,0);


  label = gtk_label_new (
"\n\
\n    GuiTAR
\n    version 0.0.3 \
\n    by Kemal 'Disq' Hadimli \
\n    <disq@bir.net.tr> \
\n \
\n    http://disq.bir.net.tr/guitar \
\n");

  gtk_widget_show (label);
  gtk_box_pack_start (GTK_BOX (hbox), label, TRUE, TRUE, 0);

  dialog_action_area1 = GTK_DIALOG (aboutwin)->action_area;
  gtk_widget_show (dialog_action_area1);

  but_close = gtk_button_new_with_label ("Close");
  gtk_widget_show (but_close);
  gtk_box_pack_start (GTK_BOX (dialog_action_area1), but_close, TRUE, TRUE, 0);
  gtk_container_border_width (GTK_CONTAINER (but_close), 5);
  gtk_signal_connect(GTK_OBJECT(but_close),"clicked",GTK_SIGNAL_FUNC(close_about),NULL);

  gtk_widget_show(aboutwin);
  aboutboxopen++;
}


GtkWidget* create_viewwin(char *fn, char *realfn)
{
  GtkWidget *viewwin;
  GtkWidget *hbox;
  GtkWidget *text;
  GtkWidget *scr;
  FILE *f;
  char c[2];
  char a[512];

  viewwin = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_widget_set_usize (viewwin, 550, 220);
  gtk_container_border_width (GTK_CONTAINER (viewwin), 2);
  gtk_window_position (GTK_WINDOW (viewwin), GTK_WIN_POS_CENTER);
  gtk_window_set_policy (GTK_WINDOW (viewwin), TRUE, TRUE, FALSE);

  sprintf(a,"View - %s/%s",ourfile,realfn);
  gtk_window_set_title (GTK_WINDOW (viewwin), a);

  gtk_signal_connect (GTK_OBJECT(viewwin),"delete_event",GTK_SIGNAL_FUNC(delete_event),NULL);
  gtk_signal_connect (GTK_OBJECT(viewwin),"destroy",GTK_SIGNAL_FUNC(gtk_widget_destroy),(gpointer)GTK_WIDGET(viewwin));
  hbox = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox);
  gtk_container_add (GTK_CONTAINER (viewwin), hbox);

  text = gtk_text_new (NULL, NULL);
  gtk_widget_show (text);
  gtk_box_pack_start (GTK_BOX (hbox), text, TRUE, TRUE, 0);

  scr = gtk_vscrollbar_new(GTK_TEXT(text)->vadj);
  gtk_widget_show (scr);
  gtk_box_pack_start (GTK_BOX (hbox), scr, FALSE, TRUE, 0);

  gtk_widget_realize(text);
  gtk_text_freeze(GTK_TEXT(text));

  f=fopen(fn,"r");
  if (f!=NULL)
	{
	c[1]=0;
    c[0]=fgetc(f);
	while (!feof(f))  
	  {
  	  gtk_text_insert(GTK_TEXT(text),NULL,NULL,NULL,c,-1);
	  c[0]=fgetc(f);
  	  }
	fclose(f);
	PopStatusbar();
	} else
	{
	PushStatusbar("Error opening temprorary file");
	}

  gtk_text_thaw(GTK_TEXT(text));

  gtk_widget_show(viewwin);
  return viewwin;
}
