//The basic V stuff was borrowed from an app that came with an earlier
//V distribution. I left most of the comments in as well.
#include "Xgzip.h"   // the header           
//===================>>> vedTextEditor::vedTextEditor <<<====================
vedTextEditor::vedTextEditor(XgzipCmdWindow* parent) :    //so I can use the
      vTextEditor((vCmdWindow*)parent)                    //V texteditor to
{                                              //display the compression info
   
}


//===================>>> vedTextEditor::~vedTextEditor <<<====================
vedTextEditor::~vedTextEditor()
{
   
}

//=========================>>> XgzipApp::NewAppWin <<<==========================
  vWindow* XgzipApp::NewAppWin(vWindow* win, char* name, int h, int w, vAppWinInfo* winInfo)
  {
    vWindow* thisWin = win;		// local copy to use
    vAppWinInfo* awinfo = winInfo;

    char *myname = name;

    UserDebug1(Build,"XgzipApp::NewAppWin(%s)\n",myname);

    if (!thisWin)			// need to new a window
      {
	thisWin = new XgzipCmdWindow(myname, h, w);
      }

    if (!awinfo)
	awinfo = new vAppWinInfo(myname);

    return vApp::NewAppWin(thisWin, myname, h, w, awinfo);
  }

//========================>>> XgzipApp::Exit <<<======================
  void XgzipApp::Exit(void)
  {
    // This is called to close all windows. If the app needs to
    // do something special, it can. Otherwise, it can call the
    // general vApp::Exit method, which will generate
    // appropriate calls the the specialized XgzipApp::CloseAppWin

    UserDebug(Build,"XgzipApp::Exit()\n");

    vApp::Exit();	// easy default behavior
  }

//=======================>>> XgzipApp::CloseAppWin <<<===========================
  void XgzipApp::CloseAppWin(vWindow* win)
  {
    // This will be called BEFORE a window has been unregistered or
    // closed.  The app can do whatever it needs to to close down
    // the data associated with this window. Then it can call the
    // general vApp::CloseAppWin to unregister and close this window.
    // Note that the win gives a handle that can be used with
    // vApp::getAppWinInfo to retrieve the AppWinInfo class.

    // Code to handle close of window (such as saving/closing a file)
    // would go here...

    // Now unregister and close the window.

    UserDebug(Build,"XgzipApp::CloseAppWin()\n");

    vApp::CloseAppWin(win);
  }

//========================>>> XgzipApp::AppCommand <<<==============================
  void XgzipApp::AppCommand(vWindow* win, ItemVal id, ItemVal val, CmdType cType)
  {
    // Any commands not processed by the window will be passed
    // along to here for default treatment.
    UserDebug1(Build,"XgzipApp::AppCmd(ID: %d)\n",id);
    vApp::AppCommand(win, id, val, cType);
  }

//###########################################################################
    static CommandObject CommandBar[] = //define what's in the command bar
      
	   {	 
	      
	{C_Button, M_Select, M_Select, "select",NoList,CA_None,isSens,NoFrame,0,0},
        {C_Button, M_Zip, M_Zip, "zip",NoList,CA_None,isSens,NoFrame,0,0},
	{C_Button, M_Unzip, M_Unzip, "unzip",NoList,CA_None,isSens,NoFrame,0,0},
	{C_Button, M_About, M_About, "About",NoList,CA_None,isSens,NoFrame,0,0},
	{C_Button, M_Exit, M_Exit, "Exit", NoList,CA_None,isSens,NoFrame, 0, 0},
        {C_Text, 99, 0, "", "",CA_None,isSens, 0, 0}, 
		{C_EndOfList,0,0,0,0,CA_None,0,0,0},
      };

static vMenu FileMenu[] = //define what's in the file menu
{
        
         {"&Select", M_Select, isSens,notChk,noKeyLbl, noKey, noSub},
         {"&Zip", M_Zip, isSens,notChk,noKeyLbl, noKey, noSub},
         {"&Unzip", M_Unzip, isSens,notChk,noKeyLbl, noKey, noSub},
         {"-", M_Line, notSens,notChk,noKeyLbl,noKey,noSub},
         {"E&xit", M_Exit, isSens,notChk,noKeyLbl,noKey,noSub},
         {NULL}
};
static vMenu HelpMenu[] =
  {
   {"&About", M_About, isSens,notChk,noKeyLbl, noKey, noSub},
   {NULL} 
  };

static vMenu MenuBar[] = //define what's in the menu bar
{
	      
        {"&File",M_File,isSens,notUsed,notUsed,noKey,&FileMenu[0]},
        {"&Help",M_Help,isSens,notUsed,notUsed,noKey,&HelpMenu[0]}, 
         {NULL}                         // end of menubar
};
 
static CommandObject Slider[] = //define the slider, used to 
                                //control the compression level
{
   
         {C_Label, 89,0,"Fastest",NoList,CA_None,isSens,NoFrame,0,0,0},
         {C_Frame, 86, 0, "",NoList,CA_None,isSens,NoFrame,0,0},
         {C_Slider, 87, 60, "",NoList,CA_Horizontal,isSens,86,0,0},
         {C_Text, 88, 0, "", "-6",CA_None,isSens, 86, 87, 0},
         {C_Label, 90,0,"Best",NoList,CA_None,isSens,NoFrame,0,0,0},
         {C_EndOfList,0,0,0,0,CA_None,0,0,0},
};  

//====================>>> XgzipCmdWindow::XgzipCmdWindow <<<====================
  XgzipCmdWindow::XgzipCmdWindow(char* name, int height, int width) :
    vCmdWindow(name, height, width)
  {
    UserDebug1(Constructor,"XgzipCmdWindow::XgzipCmdWindow(%s) Constructor\n",name) 
     //the menu pane  
     XgzipMenuPane = new vMenuPane(MenuBar);  // construct pane
     AddPane(XgzipMenuPane);
       
   //   The button pane     
    XgzipCmdPane = new vCommandPane(CommandBar); //construct pane
    AddPane(XgzipCmdPane);
       
     //the slider pane
      XgzipSliderPane = new vCommandPane(Slider); //construct pane
      AddPane(XgzipSliderPane);
     
     //the canvas pane
     vedCanvas = new vedTextEditor(this);
     AddPane(vedCanvas);
     
      ShowWindow();
  }

//====================>>> XgzipCmdWindow::XgzipCmdWindow <<<====================
  XgzipCmdWindow::XgzipCmdWindow(const XgzipCmdWindow& w) : vCmdWindow(w)
  {
    // This copy constructor is used to support the shallow destructor
    // convention used by the V framework.

    UserDebug(Constructor,"XgzipCmdWindow::XgzipCmdWindow() Copy constructor\n")
    vSysError("XgzipCmdWindow: V does not support copy constructors");
  }

//====================>>> XgzipCmdWindow::~XgzipCmdWindow <<<====================
  XgzipCmdWindow::~XgzipCmdWindow()
  {
    UserDebug(Destructor,"XgzipCmdWindow::~XgzipCmdWindow() destructor\n")

    // Now put a delete for each new in the constructor.
    delete XgzipMenuPane;
    delete XgzipCmdPane;
    delete XgzipSliderPane;
    delete vedCanvas;
     
  }


//====================>>> XgzipCmdWindow::WindowCommand <<<====================
  void XgzipCmdWindow::WindowCommand(ItemVal id, ItemVal retval, CmdType cType)
  {
     
    // route all commands through here - menus and buttons
    switch (id)
      {
	case M_About: //for the "about" notice
	  {
	    vNoticeDialog about(this);		// Used for default actions
	    about.Notice("         Xgzip\nWritten by: nerull@home.virtual-pc.com\n Copyrite (C) 1996-1997");
	    break;
	  }

	case M_Exit:
	  {
	    theApp->Exit();		// Standard action for Exit
	    break;
	  }
       case 87: //update the slider value
	   {
               sprintf(buff,"%d",retval/-11);  // convert To string
	       SetString(88,buff);      // Show value
		if(retval/-11 ==  0)  
		{
		   sprintf(buff,"%d", -1);
		   SetString(88,"-1");
		}  
	      break;
	   }
       case M_Select:
	   {
	      
	      static char* filter[] =     // define a filter list
		{
		   
		           "*.gz",                    // gzip files
		           "*",                       // all files
		             0
		};
	      
	      static int filterIndex = 0;    // to track filter picked
	char name[200] = "";
          vFileSelect fsel(this);     // instantiate
		
	  int oans = fsel.FileSelect("Select file", name, 99, filter, filterIndex);
		if (!oans && !*name) //if no file is selected
		{
		    vNoticeDialog fsnote(this); // make an instance 
		 (void)fsnote.Notice("No new file has been selected!"); //Bitch because no file is selected
		   strcpy(filename, ""); //clear the filename variable
		   oans2=NULL; //set this to 0 so if any buttons are pressed we know there is no selected file
		   SetString(99, filename); //print a blank for the filename 
		   break;
		}
	      //if a file is selected...
		filename = name; //copy filename to name so we can use it in other parts of the program
	      oans = oans2; //so we know a file has been selected
	       FILE *f;      //declare a file to hold the compression info         
	                              //Copy all the info from the window
	      strcpy(gzip_n_args, "");//into one string, and then pipe it 
	      strcpy(gzinfo1, "");    //to the system
	      strcpy(gzinfo2, "");
	      strcat(gzip_n_args, "gzip -l ");
	      strcat(gzip_n_args, filename);
	      strcat(gzip_n_args, " 2> /dev/null");
	      f = NULL; //clear the file
	      f = popen(gzip_n_args, "r"); //put the compression info into file
	      fgets(gzinfo1, 100, f);    //get compression info from the file
	      fgets(gzinfo2, 100, f);    //and then display it
	      const int maxBuff = 300;
	      char buff[maxBuff];
	      vedCanvas->resetBuff();                // ** Tell vTextEditor to init buffer
	      SetString(99, filename);    
	     vedCanvas->addLine(gzinfo1);    
	      vedCanvas->addLine(gzinfo2);     //show the compressed file info
		   vedCanvas->displayBuff();  
	      break;
	   }
	 
       case M_Zip :
	   {  
	       vNoticeDialog fnote(this);
	       if (!oans2 && !*filename){  //what to do if a file is not selected
		    
		(void)fnote.Notice("Try selecting a file first."); //bitch at the user ;)
	      break;
	       }
              strcpy(gzip_n_args, "");
	      strcat(gzip_n_args, "gzip -f ");
	      strcat(gzip_n_args, buff);     //copy all info into gzip_n_args
	      strcat(gzip_n_args, " ");      //so we can later pipe it to the system
	      strcat(gzip_n_args, filename);
	      //the following segment of code gets the selected file's extension and breaks if it is already .gz 
	      int n1;
              char extension[10];
              n1 = strlen(filename) - 3;
              strncpy(extension, filename + n1, 3);
              if (strncmp(extension, ".gz", 3) == 0)
                break;

	      system(gzip_n_args);//zip the file
	       //get all the compression info and display it
                      FILE *f;
	                    strcpy(gzip_n_args, "");
	                    strcpy(gzinfo1, "");
	                    strcpy(gzinfo2, "");
	                    strcat(gzip_n_args, "gzip -l ");
	                    strcat(gzip_n_args, filename);
	      f = popen(gzip_n_args, "r");
	      fgets(gzinfo1, 100, f);
	       fgets(gzinfo2, 100, f);
	       vedCanvas->resetBuff();
	       vedCanvas->addLine(gzinfo1);
	       vedCanvas->addLine(gzinfo2);
	       vedCanvas->displayBuff();
//add a .gz to the filename that is displayed
	      strcat(filename, ".gz");
	      SetString(99, filename);
	       break;
                  }
	 
       case M_Unzip:
	   {
	      //clear the compression info
	      vedCanvas->resetBuff();
	      vedCanvas->displayBuff();
	       vNoticeDialog fnote2(this);
               if (!oans2 && !*filename){		  
                (void)fnote2.Notice("Try selecting a file first.");//bitch if no file is selected
              break;
               }
	      //copy all the window info into one string so we can pipe it to the system
	      strcpy(gzip_n_args, "");
              strcat(gzip_n_args, "gzip -d -f ");
              strcat(gzip_n_args, filename);
	      //get the file extension and break if it is not .gz
	      int n2;
	      char extension2[10];
	      n2 = strlen(filename) - 3;
	      strncpy(extension2, filename + n2, 3);
	      if (strncmp(extension2, ".gz", 3) != 0)
	      break;
	      
              system(gzip_n_args); //unzip the file
	      //remove the .gz extension from the displayed filename
	      int blah = strlen(filename)-3;
	      char holder[blah];
	      strncpy(holder, filename, blah);
	      strcpy(filename, holder);
	      filename[blah] = '\0';
	      SetString(99, filename);
	      
	      
                   break;                              
	   }
      }
  }       
   

//###########################################################################

  // EVERY V application needs the equivalent of the following line
static XgzipApp Xgzip_App("Xgzip",1, 130, 550);	// The SDI instance of the app

//============================>>> AppMain <<<==============================
  int AppMain(int argc, char** argv)
  {
    // Use AppMain to create the main window
    (void)theApp->NewAppWin(0, "Xgzip", 130, 550);

    return 0;
  }
