/*
  port tester (for the Universal Parallel Port Interface).

  this is a visual tester ;)

  connect LED's to each port pin (via 1k resister to GND) and run
  program.

  For each port:
     - Chip1, Port A
     - Chip1, Port B
     - Chip2, Port A
     - Chip2, Port B

         the program will count from 00h to ffh. you should be able to see
         the values encode on the LEDS.

         if you see a LED not working, then you know there's a problem you
         have to fix before proceeding.

 -- jsno 6/10/2000
*/

#include <stdio.h>
#include <unistd.h>
#include "version.h"
#include "common.h"
#include "if.h"
#include "pio.h"

void test_ports(void)
{
  int x;

  set_porta_output();
  for(x = 0;x < 256;x++)
  {
    porta_data(x);
    usleep(10000);
  }

  set_portb_output();
  for(x = 0;x < 256;x++)
  {
    portb_data(x);
    usleep(10000);
  }
}

int main(void)
{
  IF_init();
  initalise_pio();

/*chip 1*/
  chip_select(CHIP1);
  test_ports();

/*chip 2*/
  chip_select(CHIP2);
  test_ports();

  deinitalise_pio();

  return 0;
}
