/****************************************************************************
* U2 and U3 Loopback tester (for the Universal Parallel Port Interface)
*
* it does this by setting the PBx port of 6821 ("Q" side of the 74688
* data comparitor) to a given value... which involves successful
* communication with 6821, and then setting the same data to port Dx of
* 6821 (the "P" side of 74688). It then tests "/PEQ" to see if they are
* the same.
*
* It then sends *different* data, to see if this is detected correctly.
* This tests wiring and data
*
* WARNING!: run this program only with parallel port interface
* osolation. Don't have any target circuits (and target IC's) plugged
* in. You can possibly root up your target IC (ie, lock it, or change it's
* sig)
*
* -- jsno 6/10/2000
****************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include "common.h"
#include "if.h"
#include "pio.h"
#include "target_2051.h"

int fail_count;

void presult(void)
{
  if(!fail_count)
    printf(" passed.\n");
  else
    printf("Failed %d times.\n",fail_count);
}

int main(void)
{
  int x;

  IF_init();
  initalise_pio();

  /*
   * do data similar test
   */
  printf("Testing for similar data..");
  fflush(stdout);
  set_portb_output();
  for(x = 0,fail_count = 0;x < 0xff;x++)
  {
    portb_data(x);

    if(read_status() & PE)
      fail_count++;
  }
  presult();

  /*
   * do data different test
   */
  printf("Testing for different data..");
  fflush(stdout);
  porta_data(0);
  for(x = 1,fail_count = 0;x < 0xff;x++)
  {
    portb_data(x);
    porta_data(0);

    if(!(read_status() & PE))
      fail_count++;
  }
  presult();

  deinitalise_pio();

  return 0;
}
