/****************************************************************************
*****************************************************************************
* The Burn Distribution, (C) Terry Porter <tjporter@odyssey.apana.org.au>
* This distribution comes under the GNU general public license agreement.
*****************************************************************************
*
* PORT IO interface routines
*
* currently only for LPT1 for the moment.
*****************************************************************************
****************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/io.h>
#include "if_misc.h"

#define BASEPORT 0x378
#define STATUS   BASEPORT + 1
#define CTRL     BASEPORT + 2
#define DATA     BASEPORT

/****************************************************************************
*
****************************************************************************/
void IF_exit_cb(void)
{
  printf("Closing ports.\n");

  if(ioperm(BASEPORT,3,0))
  {
    perror("ioperm");
    exit(-1);
  }
}

void IF_init(void)
{
  printf("Opening ports (initing IO PORT routines"
         " -- may cause system lockup).\n");

  if(getuid())
  {
    printf("You must be ROOT to use IO PORT routines. Aborting.\n");
    exit(-1);
  }

  if(atexit(IF_exit_cb) == -1)
  {
    perror("atexit()");
    exit(-1);
  }

  if(ioperm(BASEPORT,3,1))
  {
    perror ("IF_start()");
    exit(-1);
  }
}

/****************************************************************************
*
****************************************************************************/
int cntl_reg = 0x0;

/*+ Sends data to the 6821 +*/
void
port_data (int data)
{
  outb (data, DATA);
  E_clock ();
}

/*+ Read the status lines, inverted bits are corrected +*/
int
read_status (void)
{
  return inb (STATUS) ^ 0x80;
}

/*+ Turnoff any particular bit +*/
void
turnoff (int data)
{
  cntl_reg &= ~data;
  outb (cntl_reg ^ 0x0b, CTRL);
}

/*+ Turnon any particular bit +*/
void
turnon (int data)
{
  cntl_reg |= data;
  outb (cntl_reg ^ 0x0b, CTRL);
}
