/****************************************************************************
*****************************************************************************
* The Burn Distribution, (C) Terry Porter <tjporter@odyssey.apana.org.au>
* This distribution comes under the GNU general public license agreement.
*****************************************************************************
*
* /dev/burn interface library
*****************************************************************************
****************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include "if_misc.h"

/****************************************************************************
*
****************************************************************************/
int fd = -1;

void IF_exit_cb(void)
{
  printf("Closing /dev/burn.\n");

  if(fd != -1)
    close(fd);
}

void IF_init(void)
{
  printf("Opening /dev/burn (initing module routines).\n");

  if(atexit(IF_exit_cb) == -1)
  {
    perror("atexit()");
    exit(-1);
  }

  fd = open("/dev/burn",O_RDWR);
  if(fd == -1)
  {
    fprintf(stderr,"Unable to open /dev/burn, aborting.\n");
    exit(-1);
  }
}

/****************************************************************************
*
****************************************************************************/
void dataset(void)
{
  if(lseek(fd,0,SEEK_SET) == -1)
  {
    perror("dataset()");
    exit(-1);
  }
}

void ctrlset(void)
{
  if(lseek(fd,1,SEEK_SET) == -1)
  {
    perror("ctrlset()");
    exit(-1);
  }
}

void write_b(int data)
{
  if(write(fd,&data,1) == -1)
  {
    perror("write()");
    exit(-1);
  }
}

void read_b(int *data)
{
  if(read(fd,data,1) == -1)
  {
    perror("read()");
    exit(-1);
  }
}

/****************************************************************************
*
****************************************************************************/
int cntl_reg = 0x0;

void port_data(int data)
{
  dataset();
  write_b(data);
  E_clock();
}

int read_status(void)
{
  int x = 0;

  read_b(&x);
  return x ^ 0x80;
}

void turnoff(int data)
{
  cntl_reg &= ~data;
  ctrlset();
  write_b(cntl_reg ^ 0xb);
}

void turnon(int data)
{
  cntl_reg |= data;
  ctrlset();
  write_b(cntl_reg ^ 0xb);
}
