/****************************************************************************
*****************************************************************************
* The Burn Distribution, (C) Terry Porter <tjporter@odyssey.apana.org.au>
* This distribution comes under the GNU general public license agreement.
*****************************************************************************
*
* common machine independant misc. routines
*
* you will find that alot of these routines/variables are universal.
*
* If you do make a new target, please use these routines instead of
* reinventing the wheel ;).
*****************************************************************************
****************************************************************************/
#include <stdio.h>
#include <unistd.h>
#include <malloc.h>

char          *filename  = NULL;
unsigned char *image_buf = NULL;  /*this is the buffer that your
                                    target code will use*/

int           target_id = 0;      /*stores the target ID*/
int           target_size = 0;    /*stores the target address size (in bytes)*/

/****************************************************************************
* assume this will only ever ben called once. if it is to be called
* multiple times, then a free_image_buffer() func would have to be made
****************************************************************************/
void alloc_image_buffer(void)
{
  image_buf = malloc(target_size);
  if(image_buf == NULL)
  {
    perror("alloc_image_buffer()");
    exit(-1);
  }
}

/****************************************************************************
* open file, allocate image_buf and read file into it
****************************************************************************/
void read_image_from_file(void)
{
  FILE *fp  = NULL;
  int x;

  fp = fopen(filename,"r");
  if(fp == NULL)
  {
    perror("read_image_from_file()::fopen()");
    exit(-1);
  }

  alloc_image_buffer();

  /*
   * fill all locn's with 0xff, before reading file.
   * this is a requirement for some target code
   */
  for(x = 0;x < target_size;x++)
    image_buf[x] = 0xff;

  x = fread(image_buf,1,target_size,fp);
  printf("Reading image. %d bytes read.\n",x);
  if(!x)
  {
    perror("read_image_from_file()::fread()");
    exit(-1);
  }

  fclose(fp);
}

/****************************************************************************
* create file and save image to it
****************************************************************************/
void write_image_to_file(void)
{
  FILE *fp  = NULL;

  fp = fopen(filename,"w");
  if(fp == NULL)
  {
    perror("write_image_to_file()::fopen()");
    exit (-1);
  }

  if(fwrite(image_buf,1,target_size,fp) != target_size)
  {
    fprintf(stderr,"read_2051()::fwrite(). Error writing data to file.\n");
    exit(-1);
  }

  fclose(fp);
}

/****************************************************************************
* read/write tickers
*
* these are universal read/write display tickers that (should) be used
* by target routines to count the number of bytes being read/written to IC
*
* the step setting sets the intervals when information is displayed on
* screen. valid values are: 0x1,0x2,0x3,0x7,0xf,x1f etc.
****************************************************************************/
void print_read_ticker(int addr,int step)
{
  if(!(addr & step))
  {
    printf("Reading %04d..\r",addr);
    fflush(stdout);
  }
}

void print_read_ticker_final(int addr)
{
  printf("Read %04d bytes.\n",addr);
}

void print_write_ticker(int addr,int step)
{
  if(!(addr & step))
  {     
    printf("Writing %04d..\r",addr);
    fflush(stdout);
  }
}

void print_write_ticker_final(int addr)
{
  printf("Wrote %04d bytes.\n",addr);
}

/****************************************************************************
* display hex dump
*
* again, this is a universal routine used in the display_<target>()
* routines of each target module.
****************************************************************************/
void print_hex_dump(void)
{
  int addr;

  printf("\n"
         "Addr  00 01 02 03 04 05 06 07 08 09 0A 0B 0C 0D 0E 0F\n"
         "-----------------------------------------------------\n");
  for(addr = 0;addr < target_size;addr += 16)
  {
    int o;

    printf("%04X-",addr);
    for(o = 0;o < 16;o++)
      printf(" %02X",image_buf[addr + o]);
    putchar('\n');
  }
  putchar('\n');
}

/****************************************************************************
* print result
****************************************************************************/
void print_result(int failed_burn)
{
  if(failed_burn > 0)
    printf(
      "FAILED to program successfully there were %d failures **\n",
      failed_burn);
  else
    printf ("Burn Successful. File programmed and each byte verified.\n");
}
