#!/bin/sh

###############################################################
#

PATH=$PATH:/usr/local/bin

ini="%4f%33%2e%22%45%70%6c"
start="%16%22%29%73%11%31%21%3b%64"
end="%16%22%29%65%0b%34%79"
cmm="%17%07%0b%54%37%1f%1f%22%01%44%30%49%2a%03%04%19%06%0b%79"

printNozzleTest()
{
   rw p $port \
      s "$ini" \
      s "$start" \
      s "%14%3c%00%53%31%20%01%06%00%54%68%3a%06%16%13%18%0c%26%1b%45%02%19%6f" \
      s "$end"
}

cleanHead()
{
   head=$1
   case "$head" in
   left)   clean="%14%2b%09%45%24%1e%1a%01%09%1d%64%3f";;
   rigth)  clean="%14%2b%09%45%24%1e%1a%01%09%1d%64%37%06%00%06%01%1b";;
   both)   clean="%14%2b%09%45%24%1e%1a%01%09%1d%64%35%05%00";;
   *) return 1;;
   esac;
   
   rw p $port \
      s "$ini" \
      s "$start" \
      s "$clean" \
      s "$end"
}


powerOff()
{
   rw p $port \
      s "$ini" \
     s "$start" \
      s "%14%38%0a%57%20%02%3c%09%08%2a" \
      s "$end"
}

autoPowerOff()
{
   value=$1
   OK=0
   if [ "$value" = Disable ]
   then
      OK=1
      value="%10%01%16%41%27%1c%16%65"
   else
      if [ "$value" = "" ]
      then
         return 1
      fi
      if [ $value -gt 0 -a $value -lt 61 ]
      then
         value=`expr $value + 0`
         if [ $? -ne 0 ]
         then
            return 1
         fi
         OK=1
      fi
   fi
   
   if [ $OK = 1 ]
   then
      rw p $port \
         s "$ini" \
         s "$start" \
         s "$cmm" \
         s "%15%1d%11%4f%15%1f%04%0a%1c%6f%33%12%54" \
         s "$value" \
         s "%5e" \
         s "$end"
   else
      return 1
   fi
}

adjustHeadAuto()
{
   rw p $port \
      s "$ini" \
      s "$start" \
      s "%14%3c%00%53%31%20%01%06%00%54%68%35%1c%18%06%7e" \
      s "$end"
}

autoPowerOn()
{
   value=$1
   case $value in
   Disabled) value="%15%1d%11%4f%15%1f%04%0a%1c%6f%3b%49%2d%05%1a%15%0b%09%16%44%6b" ;;
   Enabled)  value="%15%1d%11%4f%15%1f%04%0a%1c%6f%3b%49%2c%02%08%16%05%00%17%2a" ;;
   *) return 1;;
   esac
   rw p $port \
      s "$ini" \
      s "$start" \
      s "$cmm" \
      s "$value" \
      s "$end"
}

resetPrinter()
{
   rw p $port \
      s "$ini" \
      s "$start" \
      s "%14%3a%00%53%20%04%79" \
      s "$end"
}

getPort()
{
   if [ -d  /proc/parport ]
   then
      parportDir=`ls /proc/parport` 2>&1 > /dev/null
      for d in $parportDir
      do
         if grep -s 'MODEL:BJC-6000;' /proc/parport/$d/autoprobe >/dev/null
         then
            port=lp$d
            return 0
         fi
      done
   fi

   if [ x$X = x ]
   then
      # device not found
      while :
      do
         echo >/dev/tty
         echo "enter port: lp0 lp1 lp2">/dev/tty
         read port
         case $port in
         lp0|lp1|lp2) return;;
         esac
      done
   else
      port=`xwChoice -title "BJC-6000 Utils" \
                       -question "choose port" \
                       -choice   lp0 "" \
                       -choice   lp1 "" \
                       -choice   lp2 "" \
                       -ok       OK`
   fi
}

doWait()
{
   if [ x$X = x ]
   then
      :
   else
      xwChoice -title "BJC-6000  Utils" \
               -wait OK "   Please wait ...   " &
   fi
}

askForTime()
{
   while :
   do
      if [ x$X = x ]
      then
         echo
         echo "enter time in minute for automatic power off"
         echo "" | awk 'END { printf("( 1 ... 60 )  : ") }'
         read time rest
      else
         time=`xwChoice -title "BJC-6000 Utils" \
                          -question "enter time in minute\nfor automatic power off\n(1...60)" \
                          -input \
                          -cancel   cancel A \
                          -ok       OK`
      fi
      case $time in 
         A) break;;
         [1-9]|[1-5][0-9]|60) doWait; autoPowerOff $time || errorMsg; break;;
      esac
   done
}

errorMsg()
{
   if [ x$X = x ]
   then
      echo "Error while reading or writing on printer"  
   else
      xwChoice -title "BJC-6000  Utils" \
               -error OK "Error while reading or writing on printer"
   fi

}

if  xwIsXrunning
then
   X=X
else
   X=
fi

getPort

if [ x$X = x ]
then
   bell=`echo a | tr 'a' '\007'`
   while :
   do
      echo
      echo "1) print nozzle check"
      echo "2) clean colour head"
      echo "3) clean black head"
      echo "4) clean both head"
      echo "5) auto adjust head"
      echo "6) power off"
      echo "7) reset printer"
      echo "8) auto power off disabled"
      echo "9) auto power off enabled"
      echo "0) quit"
      echo "enter action (1 to 9 or 0)"
      read action
 
      case $action in
      0) exit 0;;
      1) printNozzleTest || errorMsg;;
      2) cleanHead rigth || errorMsg;;
      3) cleanHead left || errorMsg;;
      4) cleanHead both || errorMsg;;
      5) adjustHeadAuto || errorMsg;;
      6) powerOff || errorMsg; exit 0;;
      7) resetPrinter || errorMsg;;
      8) autoPowerOff Disable || errorMsg;;
      8) autoPowerOff $OFFTIME;;
      esac
   done
else
   while :
   do
      action=`xwChoice -title "BJC-6000 Utils" \
                         -question "Choose action to perform" \
                         -choice "print nozzle check" p \
                         -choice "clean colour head" cc \
                         -choice "clean black head" ck \
                         -choice "clean both head" cb \
                         -choice "auto adjust head" ah \
                         -choice "power off" po \
                         -choice "reset printer" rp \
                         -choice "auto power off disabled" pd \
                         -choice "auto power off enabled" pe \
                         -cancel "QUIT" Q \
                         -ok     "OK"`
      case $action in
      Q) exit 0;;
      p)  doWait; printNozzleTest || errorMsg;;
      cc) doWait; cleanHead rigth || errorMsg;;
      ck) doWait; cleanHead left || errorMsg;;
      cb) doWait; cleanHead both || errorMsg;;
      ah) doWait; adjustHeadAuto || errorMsg;;
      po) powerOff || errorMsg; exit 0;;
      rp) doWait; resetPrinter || errorMsg;;
      pd) doWait; autoPowerOff Disable || errorMsg;;
      pe) askForTime;;
      esac
   done      
fi
