/*
 * usrmgr - Linux user manager
 * Copyright 1995 by Michael McNeil <kludge@zot.com>
 * XForms GUI adaptation by R. Mitnitksi <mitnits@shani.net>
 * Released under the GNU Public License. See COPYING for details.
 */
 
#include <stdio.h>
#include <stdlib.h>
#include <stddef.h>
#include <string.h>
#include <pwd.h>
#include <grp.h>
#include <time.h>
#include <ctype.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <sys/utsname.h>
#include <unistd.h>
#include <assert.h>
                                  
#include "forms.h"
#include "xfusermgr.h"
extern  FD_xfusermgr_top *fd_xfusermgr_top;


#define SYSTEM   1
#define NETWORK  2
#define USER     3
#define DISK     4
#define SUCCESS  1
#define FAILURE  0
 

/* we gotta change this to something more portable  */
/*  I think the following will only work on a 32 bit machine */
#define ascii_to_bin(c) ((c)>='a'?(c-59):(c)>='A'?((c)-53):(c)-'.')
#define bin_to_ascii(c) ((c)>=38?((c)-38+'a'):(c)>=12?((c)-12+'A'):(c)+'.')
 
/* Error handlers */
void no_user()
{
 fl_show_alert("User Manager","No user specified","",1);
}
void bad_user()
{
  fl_show_alert("User Manager","Invalid user","",1);
}
void bad_homedir()
{
  fl_show_alert("User Manager","Invalid home directory","",1);
}
void bad_userid()
{
  fl_show_alert("User Manager","No User id Specified","",1);
}
void bad_group()
{
  fl_show_alert("User Manager","No Group Specified","",1);
}


/* Fill the list of users */
FillUsersList()
{
  struct passwd *pw; 
  char br_line[200];

  fl_freeze_form(fd_xfusermgr_top->xfusermgr_top);
  fl_clear_browser(fd_xfusermgr_top->users);
  setpwent();
  while( pw=getpwent()){
    char *crypt();
    char *result;
    sprintf(br_line,"%s",pw->pw_name);

    if( pw->pw_passwd[0]==0){
      sprintf(br_line,"@C1%s",pw->pw_name);
      /* set the red background color here */
    }
    else
      {
	result = crypt(pw->pw_name,pw->pw_passwd);
	if( !strcmp(result, pw->pw_passwd)) {
	  /* set the yellow background color here */
	  sprintf(br_line,"@C4%s",pw->pw_name);
	}
      }
    fl_add_browser_line(fd_xfusermgr_top->users,br_line);
  }
  endpwent();
  fl_unfreeze_form(fd_xfusermgr_top->xfusermgr_top);
}

/* Bug in XForms asks for this */
void text_modify(FL_OBJECT *ob, long data)
{
}

/* callbacks for form xfusermgr_top */
void usrselc_cb(FL_OBJECT *ob, long data)
{
  struct passwd *pwd_ptr;
  struct group *group_ptr;
  gid_t gid;
  char *choice;
  char *result;
  char userid[10];
  char grpid[10];                
  char uline[20];
  char * uname;

  setpwent();
  uname= (char *)fl_get_browser_line(fd_xfusermgr_top->users,
				  fl_get_browser(fd_xfusermgr_top->users));
  if (uname[0]=='@')
    strcpy(uline, uname+3);
  else
    strcpy(uline, uname);

  while( (pwd_ptr = getpwent()) != NULL )
    {
      if( strcmp(uline,
		 pwd_ptr->pw_name) == 0 ) break;
    }
  
  fl_set_input( fd_xfusermgr_top->Ulgname_te , pwd_ptr->pw_name );
  fl_set_input( fd_xfusermgr_top->Ufname_te  , pwd_ptr->pw_gecos );
  fl_set_input( fd_xfusermgr_top->Uhmdir_te  , pwd_ptr->pw_dir);
  
  sprintf( userid, "%d", pwd_ptr->pw_uid );
  
  gid = pwd_ptr->pw_gid;
  
  group_ptr = getgrgid( gid );
  
  sprintf( grpid,  "%s", group_ptr->gr_name );
  fl_set_input( fd_xfusermgr_top->Ugroup_te, grpid );
  fl_set_input( fd_xfusermgr_top->Uusrid_te, userid );
  fl_set_input( fd_xfusermgr_top->Ushell_te, pwd_ptr->pw_shell );
  
  if( pwd_ptr->pw_passwd[0] == 0 )
    {
      fl_set_input( fd_xfusermgr_top->Upasswd_te, "NO PASSWORD");
    }
  else
    {
      result = crypt( pwd_ptr->pw_name, pwd_ptr->pw_passwd );
      if( !strcmp( result, pwd_ptr->pw_passwd )){
	fl_set_input( fd_xfusermgr_top->Upasswd_te, pwd_ptr->pw_name );
      }
      else
	{
	  fl_set_input(  fd_xfusermgr_top->Upasswd_te, "" );
	}
    }

  endpwent();
}


void Exit(FL_OBJECT *ob, long data)
{
  
  if (fl_show_question( "Really exit","User Manager?",""))
    exit(0);
}

void delete_listent(char * string)
{
  int i,k;
  char username[20];
  k=fl_get_browser_maxline(fd_xfusermgr_top->users);
  for (i=0;i<k;i++)
    {
      strcpy(username,fl_get_browser_line(fd_xfusermgr_top->users,i+1));
      if (username[0]=='@')
	{
	  if (strcmp(username+3,string)==0){
	    fl_delete_browser_line(fd_xfusermgr_top->users,i+1);
	    break;}
	}
      else 
	  if (strcmp(username,string)==0){
	    fl_delete_browser_line(fd_xfusermgr_top->users,i+1);
	    break;}
    }
}
void recolor_user(char * login,char * passwd)
{
  int i,k;
  char username[20];
  char newname[23];

  if (strcmp(login,passwd)==0)
      sprintf(newname,"@C4%s",login);
  else
    sprintf(newname,"%s",login);

  k=fl_get_browser_maxline(fd_xfusermgr_top->users);
  for (i=0;i<k;i++)
    {
      strcpy(username,fl_get_browser_line(fd_xfusermgr_top->users,i+1));
      if (username[0]=='@')
	{
	  if (strcmp(username+3,login)==0){
	    fl_replace_browser_line(fd_xfusermgr_top->users,i+1,newname);
	    break;}
	}
      else 
	  if (strcmp(username,login)==0){
	    fl_replace_browser_line(fd_xfusermgr_top->users,i+1,newname);
	    break;}
    }
}

void reset_user(FL_OBJECT *ob, long data)
{
  int i,k;
  fl_set_input( fd_xfusermgr_top->Ulgname_te , "" );
  fl_set_input( fd_xfusermgr_top->Ufname_te  , "" );
  fl_set_input( fd_xfusermgr_top->Uhmdir_te  , "" );
  fl_set_input( fd_xfusermgr_top->Ugroup_te  , "" );
  fl_set_input( fd_xfusermgr_top->Uusrid_te  , "" );
  fl_set_input( fd_xfusermgr_top->Ushell_te  , "" );
  fl_set_input( fd_xfusermgr_top->Upasswd_te , "" );
 
  fl_deselect_browser(fd_xfusermgr_top->users);
}

void rem_user(FL_OBJECT *ob, long data)
{
  int error = 0,i;
  char user[20];
  char * uline;
  struct passwd *pwd;
  FILE *fd_in, *fd_out;
  char line[1024];
  char command[1024];

  uline= (char *)fl_get_input(fd_xfusermgr_top->Ulgname_te);
  strcpy(user,uline);

  /* Get rid of junk input */
  for (i=0;i<20;i++) if (user[i]<=' ') user[i]=0;

  if( strlen( user ) == 0 ){
    no_user();
    return;
  }
  
  if(!(fd_out = fopen("/etc/ptmp", "w"))) {
    puts("Can't open /etc/ptmp, can't update password");
    exit(1);
  }
  
  if(!(fd_in = fopen("/etc/passwd", "r"))) {
    puts("Can't read /etc/passwd, can't update password");
    exit(1);
  }
  
  /* Never, ever, EVER directly read the passwd file! */
  
  setpwent();
  while(pwd = getpwent()) {
    
    /* when we find the user's line, don't print it, just continue */
    if( strcmp(pwd->pw_name,user) == 0) continue;
    
    /* actually deleting the home directory here is too dangerous,
     * what if the home directory was "/" ?
     */
    
    /* otherwise just copy it out */
    putpwent( pwd, fd_out );
    
  }
  if(error) {
    fprintf(stderr,
	    "Error while writing new password file, password not changed.");
    fclose(fd_out);
    fclose(fd_in);
    endpwent();
    unlink("/etc/ptmp");
    return;
  }
  fclose(fd_in);
  fclose(fd_out);
  endpwent();
  
  unlink("/etc/passwd.OLD");
  link("/etc/passwd", "/etc/passwd.OLD");
  unlink("/etc/passwd");
  link("/etc/ptmp", "/etc/passwd");
  unlink("/etc/ptmp");
  chmod("/etc/passwd", 0644);
  chown("/etc/passwd", 0, 0);

  /* Remove user from the scrolled list */
  delete_listent(user);

  fl_set_input( fd_xfusermgr_top->Ulgname_te , "" );
  fl_set_input( fd_xfusermgr_top->Ufname_te  , "" );
  fl_set_input( fd_xfusermgr_top->Uhmdir_te  , "" );
  fl_set_input( fd_xfusermgr_top->Ugroup_te  , "" );
  fl_set_input( fd_xfusermgr_top->Uusrid_te  , "" );
  fl_set_input( fd_xfusermgr_top->Ushell_te  , "" );
  fl_set_input( fd_xfusermgr_top->Upasswd_te , "" );


  /* unselect the list for a new entry */
  fl_deselect_browser(fd_xfusermgr_top->users);  
}



void dis_user(FL_OBJECT *ob, long data)
{

  int error = 0;
  char user[20];
  char * uline;
  struct passwd *pwd;
  FILE *fd_in, *fd_out;
  char line[1024];
  
  uline= (char *)fl_get_input(fd_xfusermgr_top->Ulgname_te);
  strcpy(user,uline);

  if( strlen( user ) == 0 ){
    no_user();
    return;
  }
  
  if(!(fd_out = fopen("/etc/ptmp", "w"))) {
    puts("Can't open /etc/ptmp, can't update password");
                exit(1);
  }
  
  if(!(fd_in = fopen("/etc/passwd", "r"))) {
    puts("Can't read /etc/passwd, can't update password");
    exit(1);
  }
  
  /* Never, ever, EVER directly read the passwd file! */
  
  setpwent();
  while(pwd = getpwent()) {
    
    /* when we find the user's line,     */
    /* stick an "*" in the passwd field  */
    if( strcmp(pwd->pw_name,user) == 0) 
      {
	strcpy( pwd->pw_passwd, "*" );
	putpwent( pwd, fd_out );
    }else
      {
	/* otherwise just copy it out */
	putpwent( pwd, fd_out );
      }

  }
  
  if(error) {
    puts("Error while writing new password file, password not changed.");
    fclose(fd_out);
    endpwent();
    unlink("/etc/ptmp");
    exit(1);
  }
  
  fclose(fd_in);
  fclose(fd_out);
  endpwent();  
  unlink("/etc/passwd.OLD");
  link("/etc/passwd", "/etc/passwd.OLD");
  unlink("/etc/passwd");
  link("/etc/ptmp", "/etc/passwd");
  unlink("/etc/ptmp");
  chmod("/etc/passwd", 0644);
  chown("/etc/passwd", 0, 0);
  fl_set_input( fd_xfusermgr_top->Upasswd_te , "" );
  recolor_user(user,"*");
}

find_unused(begin)
        int begin;
{
        int trial;
        struct passwd *pw;
        trial = begin - 1;

        while ((pw = getpwuid(++trial)) != NULL)
        {
        /* don't do anything, just keep looking */
        }

        return(trial);
}

void new_user(FL_OBJECT *ob, long data)
{
  char newusrid[10];
  
  int unused_uid = find_unused( 501 );

  sprintf( newusrid,"%d", unused_uid );
  
  fl_set_input( fd_xfusermgr_top->Ulgname_te , "" );
  fl_set_input( fd_xfusermgr_top->Ufname_te  , "" );
  fl_set_input( fd_xfusermgr_top->Uhmdir_te  , "");
  fl_set_input( fd_xfusermgr_top->Ugroup_te  , "users");
  fl_set_input( fd_xfusermgr_top->Uusrid_te  , newusrid);
  fl_set_input( fd_xfusermgr_top->Ushell_te  , "/bin/tcsh");
  fl_set_input( fd_xfusermgr_top->Upasswd_te , "" );

  /* unselect the list for a new entry */
  fl_deselect_browser(fd_xfusermgr_top->users);
}

void add_user(FL_OBJECT *ob, long data)
{
  struct passwd *pe;
  struct passwd tpw;
  struct group *gid;
  char *cryptstr;
  time_t tm;
  char salt[2];
  FILE *fd_in, *fd_out;
  char line[1024];
  
  int status = SUCCESS;
  int error = 0;
  char *lnname;
  char *fname;
  char *hmdir;
  char *tuid;
  char *tgid;
  char *shll;
  char *pswd;
  char loginname[40];
  char fullname[40];
  char homedir[40];
  char usrid[10];
  char grid[10];
  char shell[33];
  char passwd[40];
  uid_t userid;
  int update =0;
  char commandbuf[1024];                  
  int i;
  int foundit = 0;  
  
  lnname=(char *)fl_get_input( fd_xfusermgr_top->Ulgname_te);
  strncpy( loginname, lnname, 8);
/* Remove junk like CR/LF characters */

  for (i=0;i<8;i++) if (loginname[i]<=' ') loginname[i]=0;
  fl_set_input( fd_xfusermgr_top->Ulgname_te,lnname);

  tpw.pw_name = loginname;

  if( strlen( loginname ) == 0 ){
    no_user(); /* Inform that there is no username */
    return;
  }

  /* check and see if this name already exists */
  if(getpwnam( loginname ))
    {
      /* user already exists, so we update */
      update = 1;
    }
  
  /* let's make sure that the first letter is not
     an unprintable character or a space or punctuation */

  if( iscntrl(loginname[0]) || ispunct(loginname[0])
     || isspace(loginname[0]))
    {
      bad_user();
      /* then return */
      return;
    }
  hmdir=(char *)fl_get_input( fd_xfusermgr_top->Uhmdir_te);
  strcpy( homedir, hmdir );
  tpw.pw_dir = homedir;
  
  /* we do, however, care if there is no home directory */
  if( strlen( homedir ) == 0 || strcmp (homedir,"/")==0)
    {
      /* if it's zero length, then the field is blank.
	 it is theoretical that the path to the home
	 directory is just 1 byte long, say /
	 fprintf( stderr,"No home directory specified\n"); */
      bad_homedir();
      return;
    }
  if( fname = (char *)fl_get_input(fd_xfusermgr_top->Ufname_te )) {
		strcpy( fullname, fname );
		tpw.pw_gecos = fullname;

	/* not every user wants his/her name on his/her account,
	   so we don't complain if one isn't there */
	      }
  if( tuid = (char *)fl_get_input(fd_xfusermgr_top->Uusrid_te )) 
    {
      strcpy( usrid, tuid );
      if( strlen( usrid ) == 0 )
	{
	  bad_userid();
	  return;
	}
      
      userid = atoi( usrid );
      tpw.pw_uid = ( uid_t ) userid;
    }
 
  if( tgid = (char *)fl_get_input(fd_xfusermgr_top->Ugroup_te )) {
    strcpy( grid, tgid );

    /* convert the string back into a valid group id */
    if((gid = getgrnam( grid )) == NULL ){
      bad_group();
      return;
    }
    sprintf( grid,"%d", gid->gr_gid );
    
    tpw.pw_gid = gid->gr_gid;

  }
  if( shll = (char *)fl_get_input(fd_xfusermgr_top->Ushell_te )) {
    strcpy( shell, shll );
    tpw.pw_shell = shell;
  }
  
  if( pswd = (char *)fl_get_input(fd_xfusermgr_top->Upasswd_te )) {
    strcpy( passwd, pswd );
  }
  
  time(&tm);
  salt[0] = bin_to_ascii(tm & 0x3f);
  salt[1] = bin_to_ascii((tm >> 5) & 0x3f);
  tpw.pw_passwd = crypt(passwd, salt);
  
  if(!(fd_out = fopen("/etc/ptmp", "w"))) {
    puts("xusermgr: Can't open /etc/ptmp, can't update password");
    exit(1);
  }
  
  if(!(fd_in = fopen("/etc/passwd", "r"))) {
    puts("xusermgr: Can't read /etc/passwd, can't update password");
    exit(1);
  }
  
  setpwent();
  while(pe = getpwent()) {

    /* if we are updating, look for the user to update */
    if( update )
      {
	/* find the user's line and update it */
	if( strcmp(pe->pw_name,tpw.pw_name) == 0){
	  putpwent( &tpw, fd_out );
	  continue;
	}
      }

    /* otherwise just copy it out */
    putpwent( pe, fd_out );
  }
  /* if we're not updating, then add it */
  if( !update ) putpwent( &tpw, fd_out );
  
  fclose(fd_in);
  fclose(fd_out);     
  
  /* The following code borrowed shamelessly from Patrick Volkerding's
     code from his adduser utility. Eventually, I plan to change all of
     these system calls to actual unix calls.
     */
  
  if( !update ){
    /* First, we "give" the /etc/skel directory to the new user: */
    sprintf(commandbuf,"chown --recursive %d.%d /etc/skel 2> /dev/null",tpw.pw_uid,tpw.pw_gid);
    system(commandbuf);
    /* Then, we copy the files owned by the new user into the new user's home
       directory. This way, if there are already files in the user's home
       directory (say, from a backup), the ownership of those files won't be
       changed. Some say this is progress. ;^) */
    /*		sprintf(commandbuf,"( cd /etc/skel ; cp -a --verbose . %s )",homedir); */
    sprintf(commandbuf,"( cd /etc/skel ; cp -a . %s )",homedir);
    system(commandbuf);
    /* It's useful to give the new home directory a current
       creation date rather than the one from /etc/skel. */
    sprintf(commandbuf,"touch %s",homedir);
    system(commandbuf);
    /* Give this stuff back to root. By sure to put the uid/gid you want for the
       default ownership of /etc/skel into the line below if 0.0 isn't good. */
		sprintf(commandbuf,"chown --recursive 0.0 /etc/skel 2> /dev/null");
    system(commandbuf);
    sprintf(commandbuf,"touch /var/spool/mail/%s",tpw.pw_name);
    system(commandbuf);
    sprintf(commandbuf,"chown %d.mail /var/spool/mail/%s",tpw.pw_uid,tpw.pw_name);
    system(commandbuf);
    sprintf(commandbuf,"chmod 660 /var/spool/mail/%s",tpw.pw_name);
    system(commandbuf);
  }
  
  endpwent();
  
  unlink("/etc/passwd.OLD");
  link("/etc/passwd", "/etc/passwd.OLD");
  unlink("/etc/passwd");
  link("/etc/ptmp", "/etc/passwd");
  unlink("/etc/ptmp");
  chmod("/etc/passwd", 0644);
  chown("/etc/passwd", 0, 0);
  
  /* clear out all the text fields */
  fl_set_input( fd_xfusermgr_top->Ulgname_te , "" );
  fl_set_input( fd_xfusermgr_top->Ufname_te  , "" );
  fl_set_input( fd_xfusermgr_top->Uhmdir_te  , "");
  fl_set_input( fd_xfusermgr_top->Ugroup_te  , "" );
  fl_set_input( fd_xfusermgr_top->Uusrid_te  , "" );
  fl_set_input( fd_xfusermgr_top->Ushell_te  , "" );
  fl_set_input( fd_xfusermgr_top->Upasswd_te , "" );

/*  if we're not updating, add the new user 
     entry to the bottom of the list */

  if( !update )
    {
      if (strcmp(loginname,passwd)==0)
	{
	  char bline[23];
	  sprintf(bline,"@C4%s",loginname);
	  fl_add_browser_line(fd_xfusermgr_top->users,bline);
	}
      else
	fl_add_browser_line(fd_xfusermgr_top->users,loginname);
    }
  else
    {
      recolor_user(loginname,passwd);
    }
  fl_deselect_browser(fd_xfusermgr_top->users);  
}



