#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <dirent.h>
#include <fcntl.h>
#include <pwd.h>
#include <grp.h>
#include <gtk/gtk.h>

const gchar *list_item_data_key="list_item_data";
struct passwd *pp;

GtkWidget *e_login;
GtkWidget *e_pass;
GtkWidget *e_uid;
GtkWidget *e_gid;
GtkWidget *e_name;
GtkWidget *e_home;
GtkWidget *e_shell;

char *shells[256];
char *groups[256];
char g_shell[256];
int scroll_list_flag;

void get_groups()
{
  FILE* fp;
  char buf[256];
  int a=0;

  if (!(fp=fopen("/etc/group","r")))
    {
      printf("Could not open groupfile /etc/group\n");
      exit(0);
    }

  while (fgets(buf,255,fp))
    {
      groups[a] = malloc(strlen(buf)+1);
      sscanf(buf,"%s", groups[a]);
      a++;
    }
  fclose(fp);
}

void get_shells()
{
  FILE* fp;
  char buf[256];
  int a=0;

  if (!(fp=fopen("/etc/shells","r")))
    {
      printf("Could not open shellfile /etc/shells\n");
      exit(0);
    }

  while (fgets(buf,255,fp))
    {
      shells[a] = malloc(strlen(buf)+1);
      sscanf(buf,"%s", shells[a]);
      a++;
    }
  fclose(fp);
}

void check()
{
  FILE* fp;
  char buf[256];
  char tmp[256];

  if (getuid() != 0)
    {
      printf("Not superuser!\n");
      exit(0);
    }

  if (!(fp=fopen("/etc/passwd","r")))
    {
      printf("Could not open password file /etc/passwd!\n");
      exit(0);
    }

  while (fgets(buf,255,fp))
    {
      sscanf(buf,"%s",tmp);
    }
  pp=getpwnam(strtok(tmp,":"));
  sprintf(tmp,"%d",pp->pw_uid+1);
  gtk_entry_set_text (GTK_ENTRY (e_uid), tmp);
  sprintf(tmp,"%d",pp->pw_gid);
  gtk_entry_set_text (GTK_ENTRY (e_gid), tmp);
  fclose(fp);
}

void *create_skeleton(c_home,c_uid,c_gid)
{
  FILE *fp;
  int uid, gid;
  char cmd[256];
  strcpy(cmd,"cp -a /etc/skel/. ");
  strcat(cmd,(void *)c_home);

  if (!(fp=fopen((char *)c_home,"r")))
    {
      uid=atoi((void *)c_uid);
      gid=atoi((void *)c_gid);
      mkdir((void *)c_home,0755);
      chown((void *)c_home,uid,gid);
      system(cmd);
    }
  return 0;
}

void create(GtkWidget *widget, gpointer data)
{
  FILE *passwd;
  FILE *shadow;
  FILE *fp;
  int i;
  char salt[256];
  char tmp[256];
  char shell[256];
  char file_buf[256];
  char input[256];
  char *pass;
  char *c_login;
  char *c_pass;
  char *c_uid;
  char *c_gid;
  char *c_name;
  char *c_home;
  char *c_shell;

  c_login = gtk_entry_get_text (GTK_ENTRY(e_login));
  c_pass = gtk_entry_get_text (GTK_ENTRY(e_pass));
  c_uid = gtk_entry_get_text (GTK_ENTRY(e_uid));
  c_gid = gtk_entry_get_text (GTK_ENTRY(e_gid));
  c_name = gtk_entry_get_text (GTK_ENTRY(e_name));
  c_home = gtk_entry_get_text (GTK_ENTRY(e_home));
  c_shell = gtk_entry_get_text (GTK_ENTRY(e_shell));

  srandom(time(NULL));
  sprintf(tmp,"%d",(i = random()));
  pass = crypt(c_pass,strncpy(salt,tmp,2));

  sprintf(shell,"%s",g_shell);

  if (strcmp(c_shell,""))
    {
      sprintf(shell,"%s",c_shell);
    }

  if (!(fp = fopen("/etc/shadow","r")))
    {
      system("cp /etc/passwd /etc/passwd.bak");
      if (!(passwd = fopen("/etc/passwd","a")))
	{
	  printf("Could not open password file /etc/passwd!\n");
	  exit(0);
	}
      fprintf(passwd,"%s:%s:%s:%s:%s:%s:%s\n",c_login,pass,c_uid,c_gid,c_name,c_home,shell);
      fclose(passwd);
      create_skeleton(c_home,c_uid,c_gid);
    }
  else
    {
      fclose(fp);
      system("cp /etc/passwd /etc/passwd.bak");
      system("cp /etc/shadow /etc/shadow.bak");
      passwd = fopen("/etc/passwd","a");
      shadow = fopen("/etc/shadow","a");

      fp=fopen("/etc/passwd","r");

      while (fgets(file_buf,255,fp))
	{
	  sscanf(file_buf,"%s",input);
	}
      pp=getpwnam(strtok(input,":"));
      fprintf(passwd,"%s:%s:%s:%s:%s:%s:%s\n",c_login,pp->pw_passwd,c_uid,c_gid,c_name,c_home,shell);
      fprintf(shadow,"%s:%s:10000:0:0::::\n",c_login,pass);
      fclose(passwd);
      fclose(shadow);
      fclose(fp);
      create_skeleton(c_home,c_uid,c_gid);
    }
  gtk_main_quit();
}

void sigh_print_selection(GtkWidget *shell_list, gpointer func_data)
{
  struct group *gp;
  char tmp_buf[256];
  GList *dlist;
  dlist=GTK_LIST(shell_list)->selection;

  while (dlist)
    {
      GtkObject *list_item;
      gchar *item_data_string;
      list_item=GTK_OBJECT(dlist->data);
      item_data_string=gtk_object_get_data(list_item,list_item_data_key);
      //      g_print("%s\n",item_data_string);

      if (scroll_list_flag == 1)
	{
	  gp=getgrnam(strtok(item_data_string,":"));
	  sprintf(tmp_buf,"%d",gp->gr_gid);
	  gtk_entry_set_text (GTK_ENTRY (e_gid), tmp_buf);
	}

      if (scroll_list_flag == 2)
	{
	  sprintf(g_shell,"%s",item_data_string);
	  gtk_entry_set_text (GTK_ENTRY (e_shell), item_data_string);
	}

      dlist=dlist->next;
    }
}

void clear(GtkWidget *widget, gpointer data)
{
  gtk_entry_set_text (GTK_ENTRY(e_login),"");
  gtk_entry_set_text (GTK_ENTRY(e_pass),"");
  gtk_entry_set_text (GTK_ENTRY(e_uid),"");
  gtk_entry_set_text (GTK_ENTRY(e_gid),"");
  gtk_entry_set_text (GTK_ENTRY(e_name),"");
  gtk_entry_set_text (GTK_ENTRY(e_home),"");
  gtk_entry_set_text (GTK_ENTRY(e_shell),"");
}

void group_selection(GtkWidget *shell_list,gpointer func_data)
{
  scroll_list_flag=1;
  sigh_print_selection(shell_list,func_data);
}

void shell_selection(GtkWidget *shell_list,gpointer func_data)
{
  scroll_list_flag=2;
  sigh_print_selection(shell_list,func_data);
}

void destroy(GtkWidget *widget, gpointer data)
{
  gtk_main_quit();
}

int main(int argc, char *argv[])
{
  GtkWidget *window;
  GtkWidget *label;
  GtkWidget *box;
  GtkWidget *main_box;
  GtkWidget *h_box;
  GtkWidget *v_box1;
  GtkWidget *v_box2;
  GtkWidget *h_box_button;
  GtkWidget *b_create;
  GtkWidget *b_clear;
  GtkWidget *b_cancel;
  GtkWidget *menu_bar;
  GtkWidget *menu;
  GtkWidget *root_menu;
  GtkWidget *m_quit;
  GtkWidget *shell_list;
  GtkWidget *list_item;
  GtkWidget *scrolled_window;
  GtkWidget *h_box_scroll;
  GtkWidget *v_box_scroll1;
  GtkWidget *h_box_group;
  GtkWidget *v_box_group1;
  GtkWidget *v_box_group2;
  GtkWidget *scrolled_window_group;
  GtkWidget *group_list;
  GtkWidget *h_box_low;
  GtkWidget *v_box_low1;
  GtkWidget *v_box_low2;
  //  GtkWidget *separator;
  gchar buffer[64];
  guint i;
  GList *dlist;

  gtk_init (&argc, &argv);
  window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  main_box = gtk_vbox_new (FALSE, 0);
  h_box = gtk_hbox_new (FALSE, 0);
  v_box1 = gtk_vbox_new (FALSE, 0);
  v_box2 = gtk_vbox_new (FALSE, 0);
  e_login = gtk_entry_new ();
  e_pass = gtk_entry_new ();
  e_uid = gtk_entry_new ();
  e_shell = gtk_entry_new ();
  h_box_button = gtk_hbox_new (FALSE, 0);
  b_create = gtk_button_new_with_label ("CREATE");
  b_clear = gtk_button_new_with_label ("CLEAR");
  b_cancel = gtk_button_new_with_label ("CANCEL");

  //  gtk_widget_set_usize (h_box, 220, 0);
  //  gtk_widget_set_usize (main_box, 260, 240);

  gtk_window_set_title (GTK_WINDOW (window), "xuseradd 0.2.0");
  gtk_container_border_width (GTK_CONTAINER (window), 0);
  gtk_container_add (GTK_CONTAINER (window), main_box);
  gtk_widget_show (main_box);

  menu_bar = gtk_menu_bar_new();
  gtk_box_pack_start (GTK_BOX (main_box), menu_bar, TRUE, TRUE, 0);
  gtk_widget_show (menu_bar);

  root_menu = gtk_menu_item_new_with_label("Main");
  gtk_menu_bar_append (GTK_MENU_BAR (menu_bar),root_menu);
  gtk_widget_show(root_menu);

  menu = gtk_menu_new();
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (root_menu), menu);

  m_quit = gtk_menu_item_new_with_label("Quit");
  gtk_menu_append(GTK_MENU (menu),m_quit);
  gtk_signal_connect_object (GTK_OBJECT(m_quit),"activate",
			     GTK_SIGNAL_FUNC(destroy),NULL);
  gtk_widget_show (m_quit);

  box = gtk_vbox_new (FALSE, 0);
  gtk_box_pack_start (GTK_BOX (main_box), box, TRUE, TRUE, 5);
  gtk_widget_show (box);
  
  gtk_box_pack_start (GTK_BOX (main_box), h_box, TRUE, TRUE, 0);
  gtk_widget_show (h_box);
  gtk_widget_show (v_box1);
  gtk_widget_show (v_box2);
  gtk_widget_set_usize (v_box2,200,0);

  /* start horisontal box for group scroll */
  h_box_group = gtk_hbox_new (FALSE, 0);
  gtk_box_pack_start (GTK_BOX (main_box), h_box_group, TRUE, TRUE, 0);
  gtk_widget_show (h_box_group);

  v_box_group1 = gtk_vbox_new (FALSE, 0);
  gtk_box_pack_start (GTK_BOX (h_box_group), v_box_group1, TRUE, TRUE, 7);
  gtk_widget_show (v_box_group1);

  label = gtk_label_new ("Group ID");
  gtk_box_pack_start (GTK_BOX (v_box_group1), label, TRUE, TRUE, 0);
  gtk_widget_show (label);

  box = gtk_vbox_new (FALSE, 0);
  gtk_box_pack_start (GTK_BOX (v_box_group1), box, TRUE, TRUE, 25);
  gtk_widget_show (box);

  v_box_group2 = gtk_vbox_new (FALSE, 0);
  gtk_box_pack_start (GTK_BOX (h_box_group), v_box_group2, TRUE, TRUE, 5);
  gtk_widget_show (v_box_group2);
  gtk_widget_set_usize (v_box_group2,200,0);

  e_gid = gtk_entry_new ();
  gtk_box_pack_start (GTK_BOX (v_box_group2), e_gid, TRUE, TRUE, 0);
  gtk_widget_show (e_gid);

  scrolled_window_group = gtk_scrolled_window_new (NULL,NULL);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_window_group),GTK_POLICY_AUTOMATIC,GTK_POLICY_ALWAYS);
  gtk_box_pack_start (GTK_BOX (v_box_group2), scrolled_window_group, TRUE, TRUE, 0);
  gtk_widget_show (scrolled_window_group);

  group_list = gtk_list_new ();
  gtk_container_add (GTK_CONTAINER (scrolled_window_group), group_list);
  gtk_widget_show (group_list);
  gtk_signal_connect (GTK_OBJECT (group_list),"selection_changed",
		      GTK_SIGNAL_FUNC (group_selection),NULL);
  get_groups();
  i=0;
  dlist=NULL;
  while (groups[i] != 0)
    {
      GtkWidget *label;
      gchar *string;
      list_item = gtk_list_item_new_with_label(groups[i]);
      label = gtk_label_new(groups[i]);
      gtk_container_add(GTK_CONTAINER(group_list), list_item);
      gtk_widget_show (list_item);
      gtk_label_get (GTK_LABEL (label),&string);
      gtk_object_set_data(GTK_OBJECT(list_item),list_item_data_key,string);
      i++;
    }

  h_box_low = gtk_hbox_new (FALSE, 0);
  gtk_box_pack_start (GTK_BOX (main_box), h_box_low, TRUE, TRUE, 0);
  gtk_widget_show (h_box_low);

  v_box_low1 = gtk_vbox_new (FALSE, 0);
  gtk_box_pack_start (GTK_BOX (h_box_low), v_box_low1, TRUE, TRUE, -5);
  gtk_widget_show (v_box_low1);

  label = gtk_label_new ("Name");
  gtk_box_pack_start (GTK_BOX (v_box_low1), label, TRUE, TRUE, 0);
  gtk_widget_show (label);
  label = gtk_label_new ("Home");
  gtk_box_pack_start (GTK_BOX (v_box_low1), label, TRUE, TRUE, 0);
  gtk_widget_show (label);

  v_box_low2 = gtk_vbox_new (FALSE, 0);
  gtk_box_pack_start (GTK_BOX (h_box_low), v_box_low2, TRUE, TRUE, 5);
  gtk_widget_show (v_box_low2);

  e_name = gtk_entry_new();
  gtk_box_pack_start (GTK_BOX (v_box_low2), e_name, TRUE, TRUE, 0);
  gtk_widget_show (e_name);

  e_home = gtk_entry_new();
  gtk_box_pack_start (GTK_BOX (v_box_low2), e_home, TRUE, TRUE, 0);
  gtk_widget_show (e_home);

  //  separator = gtk_hseparator_new ();
  //  gtk_box_pack_start (GTK_BOX (main_box), separator, TRUE, TRUE, 0);
  //  gtk_widget_show(separator);

  h_box_scroll = gtk_hbox_new (FALSE, 0);
  gtk_box_pack_start (GTK_BOX (main_box), h_box_scroll, TRUE, TRUE, 0);
  gtk_widget_show (h_box_scroll);

  v_box_scroll1 = gtk_vbox_new (FALSE, 0);
  gtk_box_pack_start (GTK_BOX (h_box_scroll), v_box_scroll1, TRUE, TRUE, 18);
  gtk_widget_show (v_box_scroll1);

  label = gtk_label_new ("Shell");
  gtk_box_pack_start (GTK_BOX (v_box_scroll1), label, TRUE, TRUE, 0);
  gtk_widget_show (label);

  box = gtk_vbox_new (FALSE, 0);
  gtk_box_pack_start (GTK_BOX (v_box_scroll1), box, TRUE, TRUE, 25);
  gtk_widget_show (box);

  box = gtk_vbox_new (FALSE, 0);
  gtk_box_pack_start (GTK_BOX (h_box_scroll), box, TRUE, TRUE, 5);
  gtk_widget_show (box);
  gtk_box_pack_start (GTK_BOX (box), e_shell, TRUE, TRUE, 0);
  gtk_widget_show (e_shell);
  gtk_entry_set_text (GTK_ENTRY (e_shell), "/bin/bash");

  scrolled_window = gtk_scrolled_window_new (NULL,NULL);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW(scrolled_window),GTK_POLICY_AUTOMATIC,GTK_POLICY_ALWAYS);
  gtk_box_pack_start (GTK_BOX (box), scrolled_window, TRUE, TRUE, 0);
  gtk_widget_show (scrolled_window);
  gtk_widget_set_usize (scrolled_window,200,0);

  shell_list = gtk_list_new ();
  gtk_container_add (GTK_CONTAINER (scrolled_window), shell_list);
  gtk_widget_show (shell_list);
  gtk_signal_connect (GTK_OBJECT (shell_list),"selection_changed",
		      GTK_SIGNAL_FUNC (shell_selection),NULL);
  get_shells();
  //  for (i=0; i<5; i++)
  i=0;
  dlist=NULL;
  while (shells[i] != 0)
    {
      GtkWidget *label;
      gchar *string;
      strcpy(buffer,"test");
      list_item = gtk_list_item_new_with_label(shells[i]);
      label = gtk_label_new(shells[i]);
      gtk_container_add(GTK_CONTAINER(shell_list), list_item);
      gtk_widget_show (list_item);
      gtk_label_get(GTK_LABEL (label),&string);
      gtk_object_set_data(GTK_OBJECT(list_item),list_item_data_key,string);
      i++;
    }

  box = gtk_vbox_new (FALSE, 0);
  gtk_box_pack_start (GTK_BOX (main_box), box, TRUE, TRUE, 3);
  gtk_widget_show (box);

  gtk_box_pack_start (GTK_BOX (main_box), h_box_button, TRUE, TRUE, 5);

  gtk_box_pack_start (GTK_BOX (h_box), v_box1, TRUE, TRUE, 5);
  gtk_box_pack_start (GTK_BOX (h_box), v_box2, TRUE, TRUE, 5);

  label = gtk_label_new ("Login");
  gtk_box_pack_start (GTK_BOX (v_box1), label, TRUE, TRUE, 0);
  gtk_widget_show (label);

  label = gtk_label_new ("Password");
  gtk_box_pack_start (GTK_BOX (v_box1), label, TRUE, TRUE, 0);
  gtk_widget_show (label);

  label = gtk_label_new ("User ID");
  gtk_box_pack_start (GTK_BOX (v_box1), label, TRUE, TRUE, 0);
  gtk_widget_show (label);
  /*
  label = gtk_label_new ("Group ID");
  gtk_box_pack_start (GTK_BOX (v_box1), label, TRUE, TRUE, 0);
  gtk_widget_show (label);

  label = gtk_label_new ("Name");
  gtk_box_pack_start (GTK_BOX (v_box1), label, TRUE, TRUE, 0);
  gtk_widget_show (label);

  label = gtk_label_new ("Home");
  gtk_box_pack_start (GTK_BOX (v_box1), label, TRUE, TRUE, 0);
  gtk_widget_show (label);
  */

  gtk_box_pack_start (GTK_BOX (v_box2), e_login, TRUE, TRUE, 0);
  gtk_widget_show (e_login);
  //  gtk_entry_set_visibility (GTK_ENTRY(e_pass),FALSE);
  gtk_box_pack_start (GTK_BOX (v_box2), e_pass, TRUE, TRUE, 0);
  gtk_widget_show (e_pass);
  gtk_box_pack_start (GTK_BOX (v_box2), e_uid, TRUE, TRUE, 0);
  gtk_widget_show (e_uid);

  gtk_box_pack_start (GTK_BOX (h_box_button), b_create, TRUE, TRUE, 5);
  gtk_widget_show (b_create);
  gtk_box_pack_start (GTK_BOX (h_box_button), b_clear, TRUE, TRUE, 0);
  gtk_widget_show (b_clear);
  gtk_box_pack_start (GTK_BOX (h_box_button), b_cancel, TRUE, TRUE, 5);
  gtk_widget_show (b_cancel);

  //  gtk_widget_show (v_box1);
  //  gtk_widget_show (v_box2);
  //  gtk_widget_show (h_box);
  gtk_widget_show (h_box_button);
  //  gtk_widget_show (main_box);

  gtk_signal_connect (GTK_OBJECT(b_cancel),"clicked",GTK_SIGNAL_FUNC(destroy),NULL);
  gtk_signal_connect (GTK_OBJECT(b_clear),"clicked",GTK_SIGNAL_FUNC(clear),NULL);
  gtk_signal_connect (GTK_OBJECT(b_create),"clicked",GTK_SIGNAL_FUNC(create), NULL);

  check();

  gtk_widget_show (window);
  gtk_main ();
  return 0;
}



