#include "includes.h"

#ifdef _XU_SHADOW
_USER *user_lookup(char *name) {
  for (int i = 0; i<usersnum; i++)
    if (!strcmp(name,users[i].p_name))
      return (&users[i]);
  return (NULL);
}

void sdw_read(void)
{
    FILE
        *f;
    struct spwd
        *spw;
    _USER
        *up;
    char tmp[100];

    if ((f = fopen(SHADOW_FILE, "r")) == NULL)
      QMessageBox::message("Error","Error opening /etc/shadow for reading.","Ok");

    while (spw = fgetspent(f))      // read a shadow password structure
    {
        if (up = user_lookup(spw->sp_namp)) {
            shadow_cp(up, spw);             // cp the shadow info
        }
        else {
            sprintf(tmp,"No /etc/passwd entry for %s. Entry will be removed at the next `Save'-operation.", spw->sp_namp);
            QMessageBox::message("Error",tmp,"Ok");
        }
    }

    fclose(f);
}

void sdw_write()
{
    backup(SHADOW_FILE);

    FILE *f;
    spwd *spwp;

    if ((f = fopen(SHADOW_FILE, "w")) == NULL)
      QMessageBox::message("Error","Error opening /etc/shadow for writing.","Ok");

//    printf("%i users\n", usersnum);

    for (int index = 0; index < usersnum; index++)
    {
//        printf("%s, %s shadow entry\n", users[index].p_name, users[index].s_pwd ?
//                        "has a" : "without");
        if (spwp = spwstruct(&users[index]))
            putspent(spwp, f);
    }
    fclose(f);

    chmod(SHADOW_FILE, SHADOW_FILE_MASK);
}

void shadow_cp(_USER *up, spwd const *src)
{
    up->s_pwd    = strdup(src->sp_pwdp);        // cp the encrypted pwd

    up->sp_lstchg   = src->sp_lstchg;
    up->sp_min      = src->sp_min;
    up->sp_max      = src->sp_max;
    up->sp_warn     = src->sp_warn;
    up->sp_inact    = src->sp_inact;
    up->sp_expire   = src->sp_expire;
    up->sp_flag     = src->sp_flag;
}

static spwd
    s;

spwd *spwstruct(_USER *up)
{
  char tmp[100];

    if (!up->s_pwd)
    {
        sprintf(tmp,"No shadow entry for %s.", up->p_name);
        QMessageBox::message("Error",tmp,"Ok");
        return (0);
    }

    s.sp_namp   = up->p_name;
    s.sp_pwdp   = up->s_pwd;
    s.sp_lstchg = up->sp_lstchg;
    s.sp_min    = up->sp_min;
    s.sp_max    = up->sp_max;
    s.sp_warn   = up->sp_warn;
    s.sp_inact  = up->sp_inact;
    s.sp_expire = up->sp_expire;
    s.sp_flag   = up->sp_flag;

    return (&s);
}
#endif // _XU_SHADOW
