#ifdef _XU_QUOTA

#include <sys/types.h>
#include <sys/param.h>
#include <sys/stat.h>
#include <sys/file.h>
#include <linux/quota.h>
#include <errno.h>
#include <mntent.h>
#include <pwd.h>
#include <grp.h>
#include <ctype.h>
#include <stdio.h>
#include <string.h>
#include <signal.h>
#include <limits.h>
#include <paths.h>
#include "includes.h"

#if defined(__alpha__)
#include <syscall.h>
#include <asm/unistd.h>

int quotactl(int cmd, const char * special, int id, caddr_t addr)
{
	return syscall(__NR_quotactl, cmd, special, id, addr);
}
#else
#include <sys/types.h>
#define __LIBRARY__
#include <linux/unistd.h>

_syscall4(int, quotactl, int, cmd, const char *, special, int, id, caddr_t, addr);
#endif

#ifdef __cplusplus
extern "C" unsigned int sleep __P ((unsigned int __seconds));
extern "C" int fchown __P ((int __fd, __uid_t __owner, __gid_t __group));
extern "C" __off_t lseek __P ((int __fd, __off_t __offset, int __whence));
extern "C" ssize_t read __P ((int __fd, __ptr_t __buf, size_t __nbytes));
extern "C" ssize_t write __P ((int __fd, __const __ptr_t __buf, size_t __n));
extern "C" int close __P ((int __fd));
#endif

#define CORRECT_FSTYPE(type) \
(!strcmp(type,MNTTYPE_EXT2))

char *qfextension[] = INITQFNAMES;
static char *qfname = QUOTAFILENAME;
static char qfullname[PATH_MAX];

char *quotagroup = QUOTAGROUP;

char s[120];

struct quotause {
   struct quotause *next;
   long flags;
   struct dqblk dqblk;
   char fsname[MAXPATHLEN + 1];
   char qfname[1];   /* actually longer */
} *getprivs(long id, int quotatype, quotadata *q);

#define   FOUND   0x01

// all procedures
int hasquota(struct mntent *mnt, int type, char **qfnamep);
void getquota(char *uname, quotadata *q);
void setquota(char *uname, quotadata *q);
int getentry(char *name, int quotatype);
struct quotause *getprivs(long id, int quotatype, quotadata *q);
void putprivs(long id, int quotatype, struct quotause *quplist);
void freeprivs(struct quotause *quplist);
int alldigits(char *s);

/*
 * Check to see if a particular quota is to be enabled.
 */
int hasquota(struct mntent *mnt, int type, char **qfnamep)
{
   char *buf, *option, *pathname;

  if (is_quota) {
   if (!CORRECT_FSTYPE(mnt->mnt_type))
      return (0);

   if ((type == USRQUOTA) && (option = hasmntopt(mnt, MNTOPT_USRQUOTA)) != (char *)0) {
      if ((pathname = strchr(option, '=')) == (char *)0) {
         (void) sprintf(qfullname, "%s%s%s.%s", mnt->mnt_dir,
                       (mnt->mnt_dir[strlen(mnt->mnt_dir) - 1] == '/') ? "" : "/",
                       qfname, qfextension[type]);
      } else {
         /*
          * Splice this option on the start of any following option.
          */
         if ((option = strchr(++pathname, ',')) != (char *)NULL)
            *option = '\0';
         strncpy(qfullname, pathname, sizeof(qfullname));
      }
      *qfnamep = strdup(qfullname);
      return (1);
   } else
      return (0);
  }
  return (0);
}

void getquota(char *uname, quotadata *q)
{
  struct quotause *qup, *protoprivs, *curprivs;
  long id, protoid;
  int quotatype;
  char *protoname, ch;

  if (is_quota) {
    quotatype = USRQUOTA;

    if ((id = getentry(uname, quotatype)) != -1)
    {    
      curprivs = getprivs(id, quotatype, q);
      freeprivs(curprivs);
    }
  }
}

void setquota(char *uname, quotadata *q) 
{
  struct quotause *qup, *protoprivs, *curprivs;
  long id, protoid;
  int quotatype;
  char *protoname, ch;
  quotadata qa;

  if (is_quota) {
    quotatype = USRQUOTA;

    if ((id = getentry(uname, quotatype)) != -1)
    {    
      curprivs = getprivs(id, quotatype, &qa);
      curprivs->dqblk.dqb_bhardlimit = btodb(q->fhard);
      curprivs->dqblk.dqb_bsoftlimit = btodb(q->fsoft);
      curprivs->dqblk.dqb_curblocks  = btodb(q->fcur);

      curprivs->dqblk.dqb_ihardlimit = q->ihard;
      curprivs->dqblk.dqb_isoftlimit = q->isoft;
      curprivs->dqblk.dqb_curinodes  = q->icur;

      putprivs(id, quotatype, curprivs);
      freeprivs(curprivs);
    }
  }
}

/*
 * This routine converts a name for a particular quota type to an identifier.
 */
int getentry(char *name, int quotatype)
{
  if (is_quota) {
    struct passwd  *pw;
    struct group   *gr;

    if (alldigits(name))
      return (atoi(name));
    if (pw = getpwnam(name))
      return (pw->pw_uid);

    sprintf(s, "%s: no such user\n", name);
    QMessageBox::message("Error" ,s ,"Ok");  

    sleep(1);
  }
  return (-1);
}

/*
 * Collect the requested quota information.
 */
struct quotause *getprivs(long id, int quotatype, quotadata *q)
{
   struct mntent *mnt;
   struct quotause *qup = NULL, *quptail = NULL;
   FILE *fp;
   struct quotause *quphead;
   int qcmd, qupsize, fd;
   char *qfpathname;
   static int warned = 0;
   extern int errno;

  if (is_quota) {
    fp = setmntent(MNTTAB, "r");
    quphead = (struct quotause *) 0;
    qcmd = QCMD(Q_GETQUOTA, quotatype);
    while ((mnt = getmntent(fp)) != (struct mntent *) 0) {
       if (hasmntopt(mnt, MNTOPT_NOAUTO) || !hasquota(mnt, quotatype, &qfpathname))
          continue;
       qupsize = sizeof(*qup) + strlen(qfpathname);
       if ((qup = (struct quotause *) malloc(qupsize)) == (struct quotause *)NULL) {
          QMessageBox::message("Error","Out of memory.","Ok");
          exit(2);
       }
       if (quotactl(qcmd, mnt->mnt_fsname, id, (caddr_t) &qup->dqblk) != 0) {
          if ((errno == EOPNOTSUPP || errno == ENOSYS) && !warned) {
             warned++;
             QMessageBox::message("Error" ,"Quotas are not compiled into this kernel.", "Ok");
             sleep(3);
             is_quota = 0;
          }
          if ((fd = open(qfpathname, O_RDONLY)) < 0) {
            fd = open(qfpathname, O_RDWR | O_CREAT, 0640);
            if (fd < 0 && errno != ENOENT) {
              sprintf(s,"Error opening %s .",qfpathname);
              QMessageBox::message("Error","Error opening /etc/passwd.","Ok");
              free(qup);
              continue;
            }
            sprintf(s, "Creating quota file %s .",qfpathname);
            QMessageBox::message("Warning", s, "Ok");
            sleep(3);
            (void) fchown(fd, getuid(),
                   getentry(quotagroup, GRPQUOTA));
            (void) fchmod(fd, 0640);
          }
          lseek(fd, (long) (id * sizeof(struct dqblk)), L_SET);
          switch (read(fd, &qup->dqblk, sizeof(struct dqblk))) {
            case 0:/* EOF */
               /*
                * Convert implicit 0 quota (EOF) into an
                * explicit one (zero'ed dqblk)
                */
               bzero((caddr_t) & qup->dqblk,
                     sizeof(struct dqblk));
               break;

            case sizeof(struct dqblk):   /* OK */
               break;

            default:   /* ERROR */
               sprintf(s, "Error reading %s .",qfpathname);
               QMessageBox::message("Error", s, "Ok");
               close(fd);
               free(qup);
               continue;
          }
          close(fd);
       }
       strcpy(qup->qfname, qfpathname);
       strcpy(qup->fsname, mnt->mnt_fsname);
       if (quphead == NULL)
         quphead = qup;
       else
         quptail->next = qup;
       quptail = qup;
       qup->next = 0;
    }
    endmntent(fp);

    q->fhard = dbtob(qup->dqblk.dqb_bhardlimit);
    q->fsoft = dbtob(qup->dqblk.dqb_bsoftlimit);
    q->fcur  = dbtob(qup->dqblk.dqb_curblocks);

    q->ihard = qup->dqblk.dqb_ihardlimit;
    q->isoft = qup->dqblk.dqb_isoftlimit;
    q->icur  = qup->dqblk.dqb_curinodes;

    return (quphead);
  }
  return (0);
}

/*
 * Store the requested quota information.
 */
void putprivs(long id, int quotatype, struct quotause *quplist)
{
   struct quotause *qup;
   int qcmd, fd;

  if (is_quota) {
    qcmd = QCMD(Q_SETQUOTA, quotatype);
    for (qup = quplist; qup; qup = qup->next) {
      if (quotactl(qcmd, qup->fsname, id, (caddr_t) &qup->dqblk) == 0)
        continue;
      if ((fd = open(qup->qfname, O_WRONLY)) < 0) {
        sprintf(s, "Error opening %s .",qup->qfname);
        QMessageBox::message("Error", s, "Ok");
      }
      else {
        lseek(fd, (long) id * (long) sizeof(struct dqblk), 0);
        if (write(fd, &qup->dqblk, sizeof(struct dqblk)) !=
            sizeof(struct dqblk)) {
          sprintf(s, "Error writing %s .", qup->qfname);
          QMessageBox::message("Error" ,s ,"Ok");
        }
        close(fd);
      }
    }
  }
}

/*
 * Free a list of quotause structures.
 */
void freeprivs(struct quotause *quplist)
{
   struct quotause *qup, *nextqup;

  if (is_quota) {
    for (qup = quplist; qup; qup = nextqup) {
      nextqup = qup->next;
      free(qup);
    }
  }
}

/*
 * Check whether a string is completely composed of digits.
 */
int alldigits(char *s)
{
   int c;

   c = *s++;
   do {
      if (!isdigit(c))
         return (0);
   } while (c = *s++);
   return (1);
}

void quota_read(int usersnum) {
  if (is_quota)
    getquota(users[usersnum-1].p_name, &users[usersnum-1].quota);
}

void quota_write(int uid) {
  if (is_quota)
    setquota(users[uid].p_name, &users[uid].quota);
}

#endif
