#include "main.h"

int is_quota = 1;

Main::Main( QWidget *parent = 0, const char *name = 0 ) : QWidget(parent, name) {
    
    pwd_read();

#ifdef _XU_SHADOW
    sdw_read();
#endif

    pbquit = new QPushButton(this, "pbquit");

    pbquit->setText("Quit");
    pbquit->setGeometry( 5, 50, 50, 20 );
    QObject::connect(pbquit, SIGNAL(clicked()), qApp, SLOT(quit()));

    pbuser = new QPushButton(this, "pbuser");
    pbuser->setGeometry(80, 50, 100, 20);
    pbuser->setText("Select user");
    QObject::connect(pbuser, SIGNAL(clicked()), this, SLOT(user()));

    pbchange = new QPushButton(this, "pbchange");
    pbchange->setGeometry(190, 50, 100, 20);
    pbchange->setText("Save changes");
    QObject::connect(pbchange, SIGNAL(clicked()), this, SLOT(change()));

    leuser = new QLineEdit(this, "leuser");
    leuser->setGeometry(10, 100, 70, 20);
    leuser->setText("dyp");

    QLabel *l1 = new QLabel(this, "ml1");
    l1->setGeometry(10, 80, 50, 20);
    l1->setAutoResize(TRUE);
    l1->setText("User login");

    leid = new QLineEdit(this, "leid");
    leid->setGeometry(90, 100, 70, 20);
    leid->setText("101");

    QLabel *l2 = new QLabel(this, "ml2");
    l2->setGeometry(90, 80, 50, 20);
    l2->setAutoResize(TRUE);
    l2->setText("User id");

    legid = new QLineEdit(this, "legid");
    legid->setGeometry(170, 100, 70, 20);
    legid->setText("101");

    QLabel *l3 = new QLabel(this, "ml3");
    l3->setGeometry(170, 80, 50, 20);
    l3->setAutoResize(TRUE);
    l3->setText("Group id");

    lefname = new QLineEdit(this, "lefname");
    lefname->setGeometry(10, 145, 160, 20);
    lefname->setText("101");

    QLabel *l4 = new QLabel(this, "ml4");
    l4->setGeometry(10, 125, 50, 20);
    l4->setAutoResize(TRUE);
    l4->setText("Full name");

    leshell = new QLineEdit(this, "leshell");
    leshell->setGeometry(10, 190, 160, 20);
    leshell->setText("/usr/bin");

    QLabel *l5 = new QLabel(this, "ml5");
    l5->setGeometry(10, 170, 50, 20);
    l5->setAutoResize(TRUE);
    l5->setText("Shell");

    lehome = new QLineEdit(this, "lehome");
    lehome->setGeometry(10, 235, 160, 20);
    lehome->setText("/dev/null");

    QLabel *l6 = new QLabel(this, "ml6");
    l6->setGeometry(10, 215, 50, 20);
    l6->setAutoResize(TRUE);
    l6->setText("Home directory");

    leoffice1 = new QLineEdit(this, "leoffice1");
    leoffice1->setGeometry(10, 280, 160, 20);
    leoffice1->setText("");

    QLabel *l7 = new QLabel(this, "ml7");
    l7->setGeometry(10, 260, 50, 20);
    l7->setAutoResize(TRUE);
    l7->setText("Office1");

    leoffice2 = new QLineEdit(this, "leoffice2");
    leoffice2->setGeometry(10, 325, 160, 20);
    leoffice2->setText("");

    QLabel *l8 = new QLabel(this, "ml8");
    l8->setGeometry(10, 305, 50, 20);
    l8->setAutoResize(TRUE);
    l8->setText("Office2");

    leaddress = new QLineEdit(this, "leaddress");
    leaddress->setGeometry(10, 370, 160, 20);
    leaddress->setText("");

    QLabel *l9 = new QLabel(this, "ml9");
    l9->setGeometry(10, 350, 50, 20);
    l9->setAutoResize(TRUE);
    l9->setText("Address");

    leqfs = new QLineEdit(this, "leqfs");
    leqfs->setGeometry(185, 145, 70, 20);
    leqfs->setText("");

    QLabel *l10 = new QLabel(this, "ml10");
    l10->setGeometry(185, 125, 50, 20);
    l10->setAutoResize(TRUE);
    l10->setText("File soft quota");

    leqfh = new QLineEdit(this, "leqfh");
    leqfh->setGeometry(185, 190, 70, 20);
    leqfh->setText("");

    QLabel *l11 = new QLabel(this, "ml11");
    l11->setGeometry(185, 170, 50, 20);
    l11->setAutoResize(TRUE);
    l11->setText("File hard quota");

    leqfcur = new QLabel(this, "leqfcur");
    leqfcur->setGeometry(185, 235, 70, 20);
    leqfcur->setAutoResize(TRUE);
    leqfcur->setText("");

    QLabel *l14 = new QLabel(this, "ml14");
    l14->setGeometry(185, 215, 50, 20);
    l14->setAutoResize(TRUE);
    l14->setText("File usage");

    leqis = new QLineEdit(this, "leqis");
    leqis->setGeometry(185, 280, 70, 20);
    leqis->setText("");

    QLabel *l12 = new QLabel(this, "ml12");
    l12->setGeometry(185, 260, 50, 20);
    l12->setAutoResize(TRUE);
    l12->setText("iNode soft quota");

    leqih = new QLineEdit(this, "leqih");
    leqih->setGeometry(185, 325, 70, 20);
    leqih->setText("");

    QLabel *l13 = new QLabel(this, "ml13");
    l13->setGeometry(185, 305, 50, 20);
    l13->setAutoResize(TRUE);
    l13->setText("iNode hard quota");

    leqicur = new QLabel(this, "leqicur");
    leqicur->setGeometry(185, 370, 70, 20);
    leqicur->setAutoResize(TRUE);
    leqicur->setText("");

    QLabel *l15 = new QLabel(this, "ml15");
    l15->setGeometry(185, 350, 50, 20);
    l15->setAutoResize(TRUE);
    l15->setText("iNode usage");

    leslstchg = new QLineEdit(this, "leslstchg");
    leslstchg->setGeometry(290, 145, 70, 20);
    leslstchg->setText("");

    QLabel *l16 = new QLabel(this, "ml16");
    l16->setGeometry(290, 125, 50, 20);
    l16->setAutoResize(TRUE);
    l16->setText("Last change");

    lesmin = new QLineEdit(this, "lesmin");
    lesmin->setGeometry(290, 190, 70, 20);
    lesmin->setText("");

    QLabel *l17 = new QLabel(this, "ml17");
    l17->setGeometry(290, 170, 50, 20);
    l17->setAutoResize(TRUE);
    l17->setText("Min");

    lesmax = new QLineEdit(this, "lesmax");
    lesmax->setGeometry(290, 235, 70, 20);
    lesmax->setText("");

    QLabel *l18 = new QLabel(this, "ml18");
    l18->setGeometry(290, 215, 50, 20);
    l18->setAutoResize(TRUE);
    l18->setText("Max");

    leswarn = new QLineEdit(this, "leswarn");
    leswarn->setGeometry(290, 280, 70, 20);
    leswarn->setText("");

    QLabel *l19 = new QLabel(this, "ml19");
    l19->setGeometry(290, 260, 50, 20);
    l19->setAutoResize(TRUE);
    l19->setText("Warning");

    lesinact = new QLineEdit(this, "lesinact");
    lesinact->setGeometry(290, 325, 70, 20);
    lesinact->setText("");

    QLabel *l20 = new QLabel(this, "ml20");
    l20->setGeometry(290, 305, 50, 20);
    l20->setAutoResize(TRUE);
    l20->setText("Inactive");

    lesexpire = new QLineEdit(this, "lesexpire");
    lesexpire->setGeometry(290, 370, 70, 20);
    lesexpire->setText("");

    QLabel *l21 = new QLabel(this, "ml21");
    l21->setGeometry(290, 350, 50, 20);
    l21->setAutoResize(TRUE);
    l21->setText("Expire");

    selectuser(0);

    uid = 0;

#ifndef _XU_QUOTA
  if (is_quota) {
    leqfs->setEnabled(FALSE);
    leqfh->setEnabled(FALSE);
    leqfcur->setEnabled(FALSE);
    leqis->setEnabled(FALSE);
    leqih->setEnabled(FALSE);
    leqicur->setEnabled(FALSE);
    l10->setEnabled(FALSE);
    l11->setEnabled(FALSE);
    l12->setEnabled(FALSE);
    l13->setEnabled(FALSE);
    l14->setEnabled(FALSE);
    l15->setEnabled(FALSE);
  }
#endif

#ifndef _XU_SHADOW
  leslstchg->setEnabled(FALSE);
  lesmin->setEnabled(FALSE);
  lesmax->setEnabled(FALSE);
  leswarn->setEnabled(FALSE);
  lesinact->setEnabled(FALSE);
  lesexpire->setEnabled(FALSE);
  l16->setEnabled(FALSE);
  l17->setEnabled(FALSE);
  l18->setEnabled(FALSE);
  l19->setEnabled(FALSE);
  l20->setEnabled(FALSE);
  l21->setEnabled(FALSE);
#endif
}

void Main::user() {
    UserDialog *su = new UserDialog(this, "su",&uid);
    su->setGeometry(10, 10, 200, 300);
    su->show();

    selectuser(uid);
}

void Main::change() {
    FILE *passwd;
    char uname[200];

    free(users[uid].p_name);
    users[uid].p_name = (char *)malloc(strlen(leuser->text())+1);
    strcpy(users[uid].p_name, leuser->text());

    users[uid].p_uid = atoi(leid->text());
    users[uid].p_gid = atoi(legid->text());

    free(users[uid].c_name);
    users[uid].c_name = (char *)malloc(strlen(lefname->text())+1);
    strcpy(users[uid].c_name, lefname->text());

    free(users[uid].c_office1);
    users[uid].c_office1 = (char *)malloc(strlen(leoffice1->text())+1);
    strcpy(users[uid].c_office1, leoffice1->text());

    free(users[uid].c_office2);
    users[uid].c_office2 = (char *)malloc(strlen(leoffice2->text())+1);
    strcpy(users[uid].c_office2, leoffice2->text());

    free(users[uid].c_address);
    users[uid].c_address = (char *)malloc(strlen(leaddress->text())+1);
    strcpy(users[uid].c_address, leaddress->text());

    free(users[uid].p_dir);
    users[uid].p_dir = (char *)malloc(strlen(lehome->text())+1);
    strcpy(users[uid].p_dir, lehome->text());

    free(users[uid].p_shell);
    users[uid].p_shell = (char *)malloc(strlen(leshell->text())+1);
    strcpy(users[uid].p_shell, leshell->text());

#ifdef _XU_QUOTA
  if (is_quota) {
    users[uid].quota.fhard = atoi(leqfh->text());
    users[uid].quota.fsoft = atoi(leqfs->text());
    users[uid].quota.fcur  = atoi(leqfcur->text());
    users[uid].quota.ihard = atoi(leqih->text());
    users[uid].quota.isoft = atoi(leqis->text());
    users[uid].quota.icur  = atoi(leqicur->text());

    quota_write(uid);
  }
#endif

    pwd_write();
#ifdef _XU_SHADOW
    sdw_write();
#endif
}

void Main::selectuser(int id) {
    char uname[100];
    leuser->setText(users[id].p_name);

    sprintf(uname,"%i",users[id].p_uid);
    leid->setText(uname);

    sprintf(uname,"%i",users[id].p_gid);
    legid->setText(uname);

    lefname->setText(users[id].c_name);
    leshell->setText(users[id].p_shell);
    lehome->setText(users[id].p_dir);
    leoffice1->setText(users[id].c_office1);
    leoffice2->setText(users[id].c_office2);
    leaddress->setText(users[id].c_address);

#ifdef _XU_QUOTA
  if (is_quota) {
    sprintf(uname,"%li",users[id].quota.fsoft);
    leqfs->setText(uname);

    sprintf(uname,"%li",users[id].quota.fhard);
    leqfh->setText(uname);

    sprintf(uname,"%li",users[id].quota.isoft);
    leqis->setText(uname);

    sprintf(uname,"%li",users[id].quota.ihard);
    leqih->setText(uname);

    sprintf(uname,"%li",users[id].quota.fcur);
    leqfcur->setText(uname);

    sprintf(uname,"%li",users[id].quota.icur);
    leqicur->setText(uname);
  }
#endif

#ifdef _XU_SHADOW
    sprintf(uname,"%li",users[id].sp_lstchg);
    leslstchg->setText(uname);

    sprintf(uname,"%li",users[id].sp_min);
    lesmin->setText(uname);

    sprintf(uname,"%li",users[id].sp_max);
    lesmax->setText(uname);

    sprintf(uname,"%li",users[id].sp_warn);
    leswarn->setText(uname);

    sprintf(uname,"%li",users[id].sp_inact);
    lesinact->setText(uname);

    sprintf(uname,"%li",users[id].sp_expire);
    lesexpire->setText(uname);
#endif
}

void Main::about() {
    QMessageBox::message("Message","This program was created by\nDenis Y. Pershin\ndyp@iis.nsk.su","Ok");
}

#include "userdialog.moc"
#include "main.moc"

int main( int argc, char **argv )
{
    QApplication a( argc, argv );

    if (getuid()) {
      QMessageBox::message("Error","Only root allowed manage users.","Ok");
      exit(1);
    }

    Main w;

    w.resize(400,400);

    a.setMainWidget( &w );
    w.show();

    return a.exec();
}

