#ifndef _XU_INCLUDES_H_
#define _XU_INCLUDES_H_

#include <qlined.h>
#include <qpixmap.h>
#include <qlabel.h>
#include <qmsgbox.h>
#include <qpopmenu.h>
#include <qmenubar.h>
#include <qapp.h>
#include <qpushbt.h>
#include <qwidget.h>
#include <qdialog.h>
#include <qlistbox.h>

#ifdef _XU_SHADOW
#include <shadow.h>
#endif

#include <pwd.h>
#include <sys/types.h>
#include <sys/stat.h>                                                          
#include <stdlib.h>
#include <ctype.h>
#include <string.h>

#ifdef _XU_QUOTA
#include "quotatool.h"
extern int is_quota;
#endif

#define XU_BACKUP_EXT ".bak"

#define PASSWORD_FILE "/etc/passwd"
#define PASSWORD_FILE_MASK S_IRUSR | S_IRGRP | S_IROTH

#include "pwdtool.h"

typedef struct _USER {
    char
        *p_name,                        // parsed pw information
        *p_pwd,
        *p_dir,
        *p_shell,
        *c_name,                        // parsed comment information
        *c_office1,
        *c_office2,
        *c_address,
        *s_pwd;                         // parsed shadow information
    long
        sp_lstchg;                      // last password change
    signed int
        p_uid,
        p_gid,
        sp_min,                         // days until pwchange allowed.
        sp_max,                         // days before change required 
        sp_warn,                        // days warning for expiration 
        sp_inact,                       // days before  account  inactive
        sp_expire,                      // date when account expires 
        sp_flag;                        // reserved for future use
//    USERSTATE_
//        state;
#ifdef _XU_QUOTA
	quotadata quota;
#endif
} _USER;

#ifdef _XU_SHADOW
#define SHADOW_FILE "/etc/shadow"
#define SHADOW_FILE_MASK S_IRUSR
#include "sdwtool.h"
#endif

#include "misc.h"

#define XU_MAX_USERS 300
extern _USER users[XU_MAX_USERS];
extern int usersnum;

#ifdef AIX
extern "C" int getuid(void);
#else
extern "C" __uid_t getuid __P ((void));
#endif

#endif // _XU_INCLUDES_H_

