#include <stdio.h>
#include <stdlib.h>
#include <qapp.h>
#include <qpushbt.h>
#include <qcombo.h>
#include <qfont.h>
#include <qpainter.h>
#include <qmsgbox.h>
#include <qscrbar.h>
#include <qchkbox.h>
#include <qlined.h>
#include <qlabel.h>
#include "graph.h"
#include "events.h"
#include "options.h"
#include "main.h"
#include "main.moc"

MainWidget::MainWidget(QWidget *parent,const char *name) : QWidget(parent,name) {
	setMinimumSize(300,200);
	sampleRate=100;
	c00=1; c01=1; c10=1; c11=1;

	QPushButton *options=new QPushButton("Options",this,"options");
	options->setGeometry(310,5,100,25);
	connect(options,SIGNAL(clicked()),this,SLOT(options()));

	QPushButton *about=new QPushButton("About",this,"about");
	about->setGeometry(415,5,100,25);
	connect(about,SIGNAL(clicked()),this,SLOT(about()));

	QPushButton *quit=new QPushButton("Quit",this,"quit");
	quit->setGeometry(415,35,100,25);
	connect(quit,SIGNAL(clicked()),qApp,SLOT(quit()));

	graph=new GraphWidget(this,"graph");
	graph->resize(200,200);
	graph->setMaximum(4);

	select1=new QComboBox(this,"select1");
	select1->setGeometry(5,5,300,25);
	select1->setBackgroundColor(QColor(0xFF,0,0));
	fillComboBox(select1);
	connect(select1,SIGNAL(activated(int)),graph,SLOT(setCounter1(int)));

	select2=new QComboBox(this,"select2");
	select2->setGeometry(5,35,300,25);
	select2->setBackgroundColor(QColor(0,0,0xFF));
	fillComboBox(select2);
	connect(select2,SIGNAL(activated(int)),graph,SLOT(setCounter2(int)));

	scaler=new QScrollBar(MINMAX,MAXMAX-MINMAX,1,10,MAXMAX-4,QScrollBar::Vertical,this,"scale");
	connect(scaler,SIGNAL(valueChanged(int)),this,SLOT(scalerChange(int)));

	scale=new QLabel("4x",this,"scale");
	scale->setAlignment(AlignCenter);
	scale->setGeometry(310,35,100,25);
	scale->setFont(QFont("Helvetica",18,QFont::Normal));
}

void MainWidget::fillComboBox(QComboBox *combo) {
	int i;
	char buf[50];
	for(i=0;i<P5EVENTS;i++) {
		sprintf(buf,"%s (0x%x)",p5events[i].name,p5events[i].number);
		combo->insertItem(buf);
	}
}

void MainWidget::resizeEvent(QResizeEvent *event) {
	graph->setGeometry(0,64,geometry().width()-23,geometry().height()-64);
	scaler->setGeometry(geometry().width()-20,64,20,geometry().height()-64);
}

void MainWidget::about() {
	QMessageBox m;
	m.setText("Pentium(TM) Profiler v0.3\n"
	 "with support for MSRs\n\n"
	 "Written in 1997 by Stephan Meyer.\n"
	 "<Stephan.Meyer@munich.netsurf.de>\n"
	 "Needed kernel patches are included.\n\n"
	 "This program is covered by the GPL license.");
	m.show();
}

void MainWidget::options() {
	OptionsDialog *d;
	char buf[10];
	d=new OptionsDialog(this,"d");
	sprintf(buf,"%i",sampleRate);
	d->sr->setText(buf);
	d->c00->setChecked(c00);
	d->c01->setChecked(c01);
	d->c10->setChecked(c10);
	d->c11->setChecked(c11);
	if (d->exec()) {
		sampleRate=atoi(d->sr->text());
		if (!sampleRate) sampleRate=100;
		graph->setSampleRate(sampleRate);
		c00=d->c00->isChecked();
		c01=d->c01->isChecked();
		c10=d->c10->isChecked();
		c11=d->c11->isChecked();
		graph->setActive(0,c00,c01);
		graph->setActive(1,c10,c11);
	}
	delete d;
}

void MainWidget::scalerChange(int n) {
	char buf[10];
	graph->setMaximum(MAXMAX-n);
	sprintf(buf,"%ix",MAXMAX-n);
	scale->setText(buf);
}

int main(int argc,char **argv) {
	QApplication a(argc,argv);
	MainWidget w;
	w.resize(520,120);
	a.setMainWidget(&w);
	w.show();
	return a.exec();
}

