#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <unistd.h>
#include <qapp.h>
#include <qwidget.h>
#include <qpainter.h>
#include <qevent.h>
#include <qtimer.h>
#include <qmsgbox.h>
#include "events.h"
#include "graph.h"
#include "graph.moc"

int fileclose(int fd) {
	return close(fd);
}

int min(int a,int b) {
	return (a<b)?a:b;
}

int max(int a,int b) {
	return (a>b)?a:b;
}

GraphWidget::GraphWidget(QWidget *parent,const char *name) : QWidget(parent,name) {
	int i;
	QMessageBox m;

	handle=open("/dev/msr",O_RDWR);
	if (handle==-1) {
		m.setText("Could not open /dev/msr!\n"
		 "Check if you have MSR support enabled in the kernel and\n"
		 "if the device file has correct permissions.");
		m.show();
		qApp->quit();
	}

	currentWidth=geometry().width();
	currentSize=sizeof(DataPoints)*currentWidth;
	for (i=0;i<3;i++) {
		counters[i].index=0;
		counters[i].mask=0x00C0;
		counters[i].data=(DataPoints *)malloc(currentSize);
		memset(counters[i].data,0,currentSize);
	}
	for (i=0;i<currentWidth;i++) *counters[2].data[i]=1;
	currentPosition=0;

	timer=new QTimer(this,"timer");
	connect(timer,SIGNAL(timeout()),this,SLOT(getDataPoint()));
	timer->start(100);
	initCounter(0);
	initCounter(1);
	oldCycles=newCycles=readCycles();
}

GraphWidget::~GraphWidget() {
	int i;
	timer->stop();
	fileclose(handle);
	for (i=0;i<3;i++) { free(counters[i].data); }
}

void GraphWidget::setMaximum(int n) {
	currentMax=n;
	repaint();
}

void GraphWidget::setActive(int c,int c0,int c1) {
	counters[c].mask=(c1<<7) | (c0<<6);
	initCounter(c);
}

void GraphWidget::setSampleRate(int r) {
	timer->stop();
	timer->start(r);
}

unsigned long int GraphWidget::readCycles() {
	char buf[8];
	unsigned long int c;
	lseek(handle,0x10,0);
	read(handle,&buf,8);
	memcpy(&c,&buf[4],4);
	return c;
}

void GraphWidget::initCounter(int index) {
	char buf[8];
	unsigned long int i;
	memset(counters[index].data,0,currentSize);
	lseek(handle,0x11,0);
	read(handle,&buf,8);
	i=counters[index].mask | counters[index].index;
	if (index) memcpy(&buf[6],&i,2); else memcpy(&buf[4],&i,2);
	write(handle,&buf,8);
	counters[index].oldCounter=0;
}

void GraphWidget::paintEvent(QPaintEvent *event) {
	int i,h,x1,x2;
	char buf[20];
	QPainter painter;

	painter.begin(this);
	x1=event->rect().left(); x2=event->rect().right();
	h=geometry().height()-1;

	painter.setPen(QPen(QColor(0xFF,0,0),1));
	painter.moveTo(x1-1,h-(*counters[0].data[x1-1])*h*currentMax/(*counters[2].data[x1-1]));
	for (i=x1;i<=x2;i++)
	  painter.lineTo(i,h-(*counters[0].data[i])*h*currentMax/(*counters[2].data[i]));

	painter.setPen(QPen(QColor(0,0,0xFF),1));
	painter.moveTo(x1-1,h-(*counters[1].data[x1-1])*h*currentMax/(*counters[2].data[x1-1]));
	for (i=x1;i<=x2;i++)
	  painter.lineTo(i,h-(*counters[1].data[i])*h*currentMax/(*counters[2].data[i]));

	if ((currentPosition>=x1) && (currentPosition<=x2)) {
		painter.setPen(QPen(QColor(0,0,0),1));
		painter.drawLine(currentPosition+1,0,currentPosition+1,h);
	}
	painter.end();
}

void GraphWidget::resizeEvent(QResizeEvent *event) {
	int i,j,os,ow;
	DataPoints *tmp;

	if (currentWidth==geometry().width()) return;

	os=currentSize;
	ow=os/sizeof(DataPoints);
	currentWidth=geometry().width();
	currentSize=sizeof(DataPoints)*currentWidth;

	for (i=0;i<3;i++) {
		tmp=(DataPoints *)malloc(currentSize);
		if (os>currentSize)
		  memcpy(tmp,counters[i].data+ow-currentWidth,currentSize); else {
			if (i!=2) memset(tmp,0,currentSize-os); else
			 for (j=0;j<(currentWidth-ow);j++) *tmp[j]=1;
			memcpy(tmp+currentWidth-ow,counters[i].data,os);
		}
		free(counters[i].data);
		counters[i].data=tmp;
	}
	if (currentPosition>=currentWidth) currentPosition=0;
}

void GraphWidget::setCounter1(int number) {
	counters[0].index=p5events[number].number;
	initCounter(0);
}

void GraphWidget::setCounter2(int number) {
	counters[1].index=p5events[number].number;
	initCounter(1);
}

void GraphWidget::getDataPoint() {
	char buf[8];
	unsigned long int d,i,j,dc;

	oldCycles=newCycles;
	newCycles=readCycles();
	dc=newCycles-oldCycles;
	*counters[2].data[currentPosition]=dc;

	lseek(handle,0x12,0);
	read(handle,&buf,8);
	memcpy(&d,&buf[4],4);
	if (counters[0].oldCounter) i=d-counters[0].oldCounter; else i=0;
	counters[0].oldCounter=d;
	*counters[0].data[currentPosition]=i;

	lseek(handle,0x13,0);
	read(handle,&buf,8);
	memcpy(&d,&buf[4],4);
	if (counters[1].oldCounter) j=d-counters[1].oldCounter; else j=0;
	counters[1].oldCounter=d;
	*counters[1].data[currentPosition]=j;

	repaint(max(0,currentPosition-1),0,2,geometry().height(),TRUE);
	currentPosition++;
	if (currentPosition>=currentWidth) currentPosition=0;
}

