/*
 *  struct.h  -- header file for apcupsd package
 *
 *  apcupsd.c -- Simple Daemon to catch power failure signals from a
 *               BackUPS, BackUPS Pro, or SmartUPS (from APCC).
 *            -- Now SmartMode support for SmartUPS and BackUPS Pro.
 *
 *  Copyright (C) 1996-99 Andre M. Hedrick
 *                        <hedrick@astro.dyer.vanderbilt.edu>
 *  All rights reserved.
 *
 */

/*
 *                     GNU GENERAL PUBLIC LICENSE
 *                        Version 2, June 1991
 *
 *  Copyright (C) 1989, 1991 Free Software Foundation, Inc.
 *                           675 Mass Ave, Cambridge, MA 02139, USA
 *  Everyone is permitted to copy and distribute verbatim copies
 *  of this license document, but changing it is not allowed.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/*
 *  IN NO EVENT SHALL ANY AND ALL PERSONS INVOLVED IN THE DEVELOPMENT OF THIS
 *  PACKAGE, NOW REFERRED TO AS "APCUPSD-Team" BE LIABLE TO ANY PARTY FOR
 *  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING
 *  OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF ANY OR ALL
 *  OF THE "APCUPSD-Team" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  THE "APCUPSD-Team" SPECIFICALLY DISCLAIMS ANY WARRANTIES, INCLUDING,
 *  BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 *  FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 *  ON AN "AS IS" BASIS, AND THE "APCUPSD-Team" HAS NO OBLIGATION TO PROVIDE
 *  MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 *
 *  THE "APCUPSD-Team" HAS ABSOLUTELY NO CONNECTION WITH THE COMPANY
 *  AMERICAN POWER CONVERSION, "APCC".  THE "APCUPSD-Team" DID NOT AND
 *  HAS NOT SIGNED ANY NON-DISCLOSURE AGREEMENTS WITH "APCC".  ANY AND ALL
 *  OF THE LOOK-A-LIKE ( UPSlink(tm) Language ) WAS DERIVED FROM THE
 *  SOURCES LISTED BELOW.
 *
 */

/*********************************************************************/

#ifndef _APC_STRUCT_H
#define _APC_STRUCT_H

typedef enum {
	NO_CABLE=0,     /* Default Disable            */
	CUSTOM_SIMPLE,  /* SIMPLE cable simple        */
	APC_940_0020B,  /* APC cable number 940-0020B */
	APC_940_0023A,  /* APC cable number 940-0023A */
	CUSTOM_SMART,   /* SMART cable smart          */
	APC_940_0024B,  /* APC cable number 940-0024B */
	APC_940_0024C,  /* APC cable number 940-0024C */
	APC_940_0024G,	/* APC cable number 940-0024G */
	APC_940_0095A,  /* APC cable number 940-0095A */
	APC_940_0095C,  /* APC cable number 940-0095C */
	APC_NET,        /* Ethernet Link              */
	APC_940_00XXX   /* APC cable number UNKNOWN   */
} UpsCable;

/* The order of these UpsModes is important!! */
typedef enum {
	NO_UPS=0,   /* Default Disable      */
	BK,         /* Simple Signal        */
	SHAREBASIC, /* Simple Signal, Share */
	NETUPS,     /*                      */
	BKPRO,      /* SubSet Smart Signal  */
	VS,         /* SubSet Smart Signal  */
	NBKPRO,     /* Smarter BKPRO Signal */
	SMART,      /* Smart Signal         */
	MATRIX,     /* Smart Signal         */
	SHARESMART  /* Smart Signal, Share  */
} UpsMode;

typedef enum {
	NO_CLASS=0,
	STANDALONE,     /**/
	SHARESLAVE,     /**/
	NETSLAVE,       /**/
	SHAREMASTER,    /**/
	NETMASTER,      /**/
	SHARENETMASTER  /**/
} ClassMode;

typedef enum {
	NO_SHARE_NET=0,
	DISABLE,    /* Disable Share or Net UPS  */
	SHARE,      /* ShareUPS Internal         */
	NET,        /* NetUPS                    */
	SHARENET    /* Share and Net, Master     */
} ShareNetMode;

typedef enum {
	NO_LOGON=0,   
	NEVER,      /* Disable Setting NoLogon               */
	TIMEOUT,    /* Based on TIMEOUT + 10 percent         */
	PERCENT,    /* Based on PERCENT + 10 percent         */
	MINUTES,    /* Based on MINUTES + 10 percent         */
	ALWAYS      /* Stop All New Login Attempts. but ROOT */
} NoLoginMode;

typedef struct geninfo {
	char *name;		/* JHNC: name mustn't contain whitespace */
	char *long_name;
	int type;
} GENINFO; /* for static declaration of data */

typedef struct internalgeninfo {
	char name[MAXSTRING];	/* JHNC: name mustn't contain whitespace */
	char long_name[MAXSTRING];
	int type;
} INTERNALGENINFO; /* for assigning into upsinfo */

typedef struct slaveinfo {
	char name[MAXSTRING];
	int present;
	char magic[MAXSTRING];
	int socket;
	struct sockaddr_in addr;
} SLAVEINFO;

typedef	struct upsinfo {
	int fd;
	char argvalue[MAXSTRING];

	unsigned long UPSlink_flags;

	int ShutDown;
	int BatteryUp;

	INTERNALGENINFO cable;
	INTERNALGENINFO enable_access;
	INTERNALGENINFO enable_http;
	INTERNALGENINFO nologin;
	INTERNALGENINFO mode;
	INTERNALGENINFO class;
	INTERNALGENINFO sharenet;

	int LineUp;
	int OldLineUp;
	int BattUp;
	int OldBattUp;
	int LineDown;
	int OldLineDown;

	int LineLevel;

	char nine[8];
	char eight[8];
	unsigned int seven;
	char G[8];
	char X[8];
	double BatLoad;
	double LineMin;
	double LineMax;
	double UPSLoad;
	double LineFreq;
	double LineVoltage;
	double OutputVoltage;
	double UPSTemp;
	double BattVoltage;
	unsigned int Status;
	double TimeLeft;

	int annoy;
	int maxtime;
	int delay;
	int nologin_time;
	int nologin_file;
	int proctime;
	int logtime;
	int reports;
	int nettime;
	int percent;
	int runtime;

	char sensitivity[8];
	int wakeup;
	int sleep;

	char selftest[8];
	int lotrans;
	int hitrans;
	int minon;
	int lowbatt;

	char beepstate[8];
	char name[MAXSTRING];

	char device[MAXSTRING];          /**/
	char control_path[MAXSTRING];    /**/
	char powerout[MAXSTRING];        /* Warning, There is Power problems.      */
	char onbatt[MAXSTRING];          /* Warning, System running on UPS.        */
	char failing[MAXSTRING];         /* Battery Power Failing, Normal Shutdown.*/
	char timeout[MAXSTRING];         /* Online Battery Timeout, Normal Shutdown.*/
	char loadlimit[MAXSTRING];       /* Online Battery Limit, Normal Shutdown. */
	char runlimit[MAXSTRING];        /* Normal Shutdown. */
	char doshutdown[MAXSTRING];      /* Perform Normal Shutdown.               */
	char mainsback[MAXSTRING];       /* Power is back up.                      */
	char waitasec[MAXSTRING];        /* Attempting to halt shutdown.           */
	char annoyme[MAXSTRING];         /* Power Problems, Log Off System Now!!!! */
	char emergency[MAXSTRING];       /* Emergency, Possible Battery Failure!!!!*/
	char changeme[MAXSTRING];        /* Emergency, Batteries Have Failed!!!!   */
	char restartme[MAXSTRING];       /* Emergency, Restart UPS gone to long!!! */
	char remote_shutdown[MAXSTRING]; /* Remote Call Shutdown, Normal Shutdown. */

	char batt_cmd[FILENAME_MAX];     /**/
	char time_cmd[FILENAME_MAX];     /**/
	char load_cmd[FILENAME_MAX];     /**/
	char limit_cmd[FILENAME_MAX];    /**/
	char pwr_cmd[FILENAME_MAX];      /**/
	char ret_cmd[FILENAME_MAX];      /**/
	char remote_cmd[FILENAME_MAX];   /**/
	char reboot_cmd[FILENAME_MAX];   /**/

	int httpport;                    /* TCP port for apchttp */

	int NetUpsPort;                  /* Our communication port */
	char master_name[FILENAME_MAX];  /**/
	int slave_bool;                  /**/
	SLAVEINFO slaves[MAXSLAVES];     /* Slaves description */
	int slave_count;                 /**/
	int send_slaves_urg;            /* Flag: send to slaves, urgent. */

	char lockpath[FILENAME_MAX];     /* BSC, made static -RF */
	int lockfile;                    /* BSC */

	char usermagic[MAXSTRING];       /* More Security */

	int load;                        /**/
	int timedout;                    /**/
	int timelout;                    /**/
	int emergencydown;               /**/
	int remotedown;                  /**/

	int remote_state;                /**/
} UPSINFO;

typedef struct datainfo {
	char apcmagic[APC_MAGIC_SIZE];
	int update_master_config;
	int get_master_status;
	int slave_status;
	int call_master_shutdown;
	char accessmagic[ACCESS_MAGIC_SIZE];
} DATAINFO;

typedef struct configinfo {
	int new_annoy;
	int new_maxtime;
	int new_delay;
#ifdef __NOLOGIN
	int new_nologin;
#endif /* __NOLOGIN */
	int new_proctime;
	int new_logtime;
	int new_nettime;
	int new_percent;

	char new_batt_cmd[FILENAME_MAX];    /**/
	char new_time_cmd[FILENAME_MAX];    /**/
	char new_load_cmd[FILENAME_MAX];    /**/
	char new_pwr_cmd[FILENAME_MAX];     /**/
	char new_ret_cmd[FILENAME_MAX];     /**/
	char new_remote_cmd[FILENAME_MAX];  /**/
} CONFIGINFO;

/* number of magic strings in netdata structure */
#define NUM_MAGIC 2
/* number of ints in netdata structure */
#define NUM_INT 13

/*
 * DO NOT CHANGE THE LOCATION OF THE CONTENTS OF THIS STRUCT!!!!
 */

typedef struct netdata {
	char apcmagic[APC_MAGIC_SIZE];
	int status;
	int lowbatt;
	int battery;
	int shutdown;
	int load;
	int timeout;
	int runtime;
	int nologin;
	int emergency;
	int remote;
	char usermagic[APC_MAGIC_SIZE];
	int order;
	int check_time;
	int release_me;
} NETDATA;

#if defined(_SEM_SEMUN_UNDEFINED)
union semun {
	int val;                           /* value for SETVAL */
	struct semid_ds *buf;              /* buffer for IPC_STAT & IPC_SET */
	unsigned short int *array;         /* array for GETALL & SETALL */
	struct seminfo *__buf;             /* buffer for IPC_INFO */
};
#endif

#endif /* _APC_STRUCT_H */
