/*
 *  extern.h  -- header file for apcupsd package
 *
 *  apcupsd.c -- Simple Daemon to catch power failure signals from a
 *               BackUPS, BackUPS Pro, or SmartUPS (from APCC).
 *            -- Now SmartMode support for SmartUPS and BackUPS Pro.
 *
 *  Copyright (C) 1996-99 Andre M. Hedrick
 *                        <hedrick@astro.dyer.vanderbilt.edu>
 *  All rights reserved.
 *
 */

/*
 *                     GNU GENERAL PUBLIC LICENSE
 *                        Version 2, June 1991
 *
 *  Copyright (C) 1989, 1991 Free Software Foundation, Inc.
 *                           675 Mass Ave, Cambridge, MA 02139, USA
 *  Everyone is permitted to copy and distribute verbatim copies
 *  of this license document, but changing it is not allowed.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/*
 *  IN NO EVENT SHALL ANY AND ALL PERSONS INVOLVED IN THE DEVELOPMENT OF THIS
 *  PACKAGE, NOW REFERRED TO AS "APCUPSD-Team" BE LIABLE TO ANY PARTY FOR
 *  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING
 *  OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF ANY OR ALL
 *  OF THE "APCUPSD-Team" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  THE "APCUPSD-Team" SPECIFICALLY DISCLAIMS ANY WARRANTIES, INCLUDING,
 *  BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 *  FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 *  ON AN "AS IS" BASIS, AND THE "APCUPSD-Team" HAS NO OBLIGATION TO PROVIDE
 *  MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 *
 *  THE "APCUPSD-Team" HAS ABSOLUTELY NO CONNECTION WITH THE COMPANY
 *  AMERICAN POWER CONVERSION, "APCC".  THE "APCUPSD-Team" DID NOT AND
 *  HAS NOT SIGNED ANY NON-DISCLOSURE AGREEMENTS WITH "APCC".  ANY AND ALL
 *  OF THE LOOK-A-LIKE ( UPSlink(tm) Language ) WAS DERIVED FROM THE
 *  SOURCES LISTED BELOW.
 *
 */

#ifndef _APC_EXTERN_H
#define _APC_EXTERN_H

/*********************************************************************/
/* Function ProtoTypes                                               */
/*********************************************************************/

extern UPSINFO myUPS;

/*
 * Time related variables
 */
extern time_t last_time_on_line;
extern time_t last_time_annoy;
extern time_t last_time_nologon;
extern time_t last_time_delay;
extern time_t last_time_procfs;
extern time_t last_time_logging;
extern time_t last_time_net;

/*
 * Serial bits
 */
extern int le_bit;
extern int dtr_bit;
extern int rts_bit;
extern int st_bit;
extern int sr_bit;
extern int cts_bit;
extern int cd_bit;
extern int rng_bit;
extern int dsr_bit;

/*
 * File opened
 */
extern FILE *procfile;
extern FILE *logfile;

extern int debug_net;

extern int flags;
extern int killcount;

extern struct termios oldtio;
extern struct termios newtio;

extern int child_pid[MAX_THREADS];

/*
 * In apcupsd.c
 */
extern void powerfail (int ok);
extern void logonfail (int ok);
extern int make_file (const char *s);
extern int remove_file (const char *s);

extern void thread_terminate (int sig);
extern void clean_threads (void);
extern void terminate (int sig);
extern void clear_files (void);
extern void make_pid (void);

/*
 * In apcserial.c
 */
extern int setup_serial (UPSINFO *ups, int killpwr);
extern void kill_serial (UPSINFO *ups, int killpwr);
extern int check_serial (UPSINFO *ups);
extern void prep_serial (UPSINFO *ups);

#ifndef NEW_THREADS
extern void do_serial (UPSINFO *ups);
#else /* NEW_THREADS */
extern void timer_serial (int sig);
extern void do_serial (void);
#endif /* NEW_THREADS */

/*
 * In apcaction.c
 */
extern void timer_action (int sig);
extern void do_action (void);

/*
 * In apclock.c
 */
extern int create_lockfile (UPSINFO *ups, int killpwr);
extern void delete_lockfile (UPSINFO *ups);

/*
 * In apcnet.c
 */
extern int write_struct_net (int wsocketfd, struct netdata *write_struct, size_t size);
extern int read_struct_net (int rsocketfd, struct netdata *read_struct, size_t size);
extern void log_struct (struct netdata *logstruct);

extern int reconnect_master (UPSINFO *ups, int who);
extern int prepare_master (UPSINFO *ups);
extern void send_to_slaves (UPSINFO *ups);
extern int send_to_each (UPSINFO *ups, int who);

extern int reconnect_slave (UPSINFO *ups);
extern int prepare_slave (UPSINFO *ups);
extern int get_from_master (UPSINFO *ups);
extern void kill_net (UPSINFO *ups, int killpwr);

#ifndef NEW_THREADS
extern void do_net (UPSINFO *ups);
#else /* NEW_THREADS */
extern void timer_net (int sig);
extern void do_net (void);
extern void timer_slaves (int sig);
extern void do_slaves (void);
#endif /* NEW_THREADS */

/*
 * In apcpipe.c
 */
extern int pipe_requests (UPSINFO *ups);
extern int pipe_reconfig (UPSINFO *ups, CONFIGINFO *config);
extern int pipe_master_status (UPSINFO *ups);
extern int pipe_call_shutdown (UPSINFO *ups);
extern int pipe_slave_reconnect (UPSINFO *ups);
extern int pipe_slave_release (UPSINFO *ups);

/*
 * In apcconfig.c
 */
extern void zero_ups_struct (UPSINFO *ups);
extern int check_for_config (char *argvalue, UPSINFO *ups);

/*
 * In apcsetup.c
 */
extern char *setup_ups_model_V_codes (char *s, UPSINFO *ups);
extern char *setup_ups_model_b_codes (char *s, UPSINFO *ups);
extern void setup_ups_model (UPSINFO *ups);
extern void setup_ups_name (UPSINFO *ups);

extern char *setup_ups_string (UPSINFO *ups, char cmd, char *setting);
extern int setup_ups_single (UPSINFO *ups, char cmd, int single);
extern int setup_ups_bubble (UPSINFO *ups, char cmd, int setting);

extern void setup_ups_sensitivity (UPSINFO *ups);
extern void setup_ups_wakeup (UPSINFO *ups);
extern void setup_ups_sleep (UPSINFO *ups);
extern void setup_ups_lo_xfer (UPSINFO *ups);
extern void setup_ups_hi_xfer (UPSINFO *ups);
extern void setup_ups_chargepoint (UPSINFO *ups);
extern void setup_ups_alarm (UPSINFO *ups);
extern void setup_ups_lowbatt (UPSINFO *ups);
extern void setup_ups_selftest (UPSINFO *ups);

extern void setup_UPSlink_flags (UPSINFO *ups);
extern void setup_extended (UPSINFO *ups);

/*
 * In apcreports.c
 */
extern int updating_procfs (FILE *file, UPSINFO *ups);
extern int updating_logs (FILE *file, UPSINFO *ups);
extern int logprintf (char *fmt, ...);

#ifdef NEW_THREADS
extern void logopen(void);
extern void logclose(void);
extern void logmess(char *message);
extern void logerr(char *message);

extern int get_upsstat(char *buf, UPSINFO *ups);

extern void timer_reports (int sig);
extern void do_reports (void);
#endif /* NEW_THREADS */

/*
 * In apcsmart.c
 */
extern void sig_alarm (int sig);
extern int getline (char *s, UPSINFO *ups);
extern void UPSlinkCheck (UPSINFO *ups);
extern char *smart_poll (char cmd, UPSINFO *ups);
extern int fillUPS (UPSINFO *ups);
extern void test_status_bits (UPSINFO *ups);

/*
 * In apcsignal.c
 */
extern void init_timer (int timer, void (*fnhandler)(int));
extern void init_signals (void);
extern void init_thread_signals (void);
extern void restore_signals (void);
extern void sleep_forever (void);
extern void wait_for_termination (void);

/*
 * In apcipc.c
 */
extern int init_ipc (void);
extern int attach_ipc (void);
extern int detach_ipc (void);
extern int destroy_ipc (void);

extern int create_semaphore (void);
extern int attach_semaphore (void);
extern int destroy_semaphore (void);

extern int create_shmarea (void);
extern int attach_shmarea (void);
extern int detach_shmarea (void);
extern int destroy_shmarea (void);

extern int read_shmarea (UPSINFO *ups);
extern int write_shmarea (UPSINFO *ups);
extern int read_andlock_shmarea (UPSINFO *ups);
extern int write_andunlock_shmarea (UPSINFO *ups);
extern UPSINFO *lock_shmups (void);
extern void unlock_shmups (void);

/*
 * In apcexec.c
 */
extern int start_thread (void(*action)(void));

/*
 * In apchttp.c
 */
extern void httpcleanup (void);
extern void http (void);
extern void do_http (void);

#endif /* _APC_EXTERN_H */
