/*
 *  defines.h -- header file for apcupsd package
 *
 *  apcupsd.c -- Simple Daemon to catch power failure signals from a
 *               BackUPS, BackUPS Pro, or SmartUPS (from APCC).
 *            -- Now SmartMode support for SmartUPS and BackUPS Pro.
 *
 *  Copyright (C) 1996-99 Andre M. Hedrick
 *                        <hedrick@astro.dyer.vanderbilt.edu>
 *  All rights reserved.
 *
 */

/*
 *                     GNU GENERAL PUBLIC LICENSE
 *                        Version 2, June 1991
 *
 *  Copyright (C) 1989, 1991 Free Software Foundation, Inc.
 *                           675 Mass Ave, Cambridge, MA 02139, USA
 *  Everyone is permitted to copy and distribute verbatim copies
 *  of this license document, but changing it is not allowed.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/*
 *  IN NO EVENT SHALL ANY AND ALL PERSONS INVOLVED IN THE DEVELOPMENT OF THIS
 *  PACKAGE, NOW REFERRED TO AS "APCUPSD-Team" BE LIABLE TO ANY PARTY FOR
 *  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING
 *  OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF ANY OR ALL
 *  OF THE "APCUPSD-Team" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  THE "APCUPSD-Team" SPECIFICALLY DISCLAIMS ANY WARRANTIES, INCLUDING,
 *  BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 *  FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 *  ON AN "AS IS" BASIS, AND THE "APCUPSD-Team" HAS NO OBLIGATION TO PROVIDE
 *  MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 *
 *  THE "APCUPSD-Team" HAS ABSOLUTELY NO CONNECTION WITH THE COMPANY
 *  AMERICAN POWER CONVERSION, "APCC".  THE "APCUPSD-Team" DID NOT AND
 *  HAS NOT SIGNED ANY NON-DISCLOSURE AGREEMENTS WITH "APCC".  ANY AND ALL
 *  OF THE LOOK-A-LIKE ( UPSlink(tm) Language ) WAS DERIVED FROM THE
 *  SOURCES LISTED BELOW.
 *
 */

#ifndef _APC_DEFINES_H
#define _APC_DEFINES_H

#ifdef __freebsd__
#define APCCONF			"/usr/local/etc/apcupsd.conf"
#define UPS_STAT		"/var/log/apcupsd.status"
#define PWRFAIL			"/var/run/powerfail"
#endif /* __freebsd__ */

#ifndef APCCONF
#define APCCONF			"/etc/apcupsd.conf"
#endif

#ifndef UPS_STAT
#define UPS_STAT		"/etc/apcupsd.status"
#endif

#ifndef PWRFAIL
#define PWRFAIL			"/etc/powerfail"
#endif

#define NOLOGIN			"/etc/nologin"
#define APCPID			"/var/run/apcupsd.pid"
#define LOG_FILE		"/var/log/apcupsd.log"
#define APC_RE_NET		"/tmp/apcupsd.re-net"
#define APC_LOCK_PREFIX		"/LCK.."
#define LOCK_DEFAULT		"/var/lock"

#define APC_MAGIC		"apcupsd-linux-4.0"

/*
 * length of APC_MAGIC for convenience - includes NULL termination
 * APC_MAGIC_SIZE is nice to define here, but
 * power/include/apc_struct.h requires this.  Now there are
 * interdependencies among the include files.  This can easily be
 * solved with include magic or the sizes here can just be inserted
 * *.h files and strlen() can be used in *.c files - although this
 * just migrates the hard-coded number to a place away from where
 * it makes sense.  I vote for doing the include magic . . .
 */
/*
 * JHNC-FIXME (remove/replace this comment once fixed)
 * What's wrong with just using sizeof ?
 *
 * Sizeof is an operator that act on the object:
 *
 * #define PPP "12345" -> sizeof(PPP) == 6 (sizeof(string))
 * char *ppp = "12345" -> sizeof(ppp) == 4 (sizeof(char *))
 *
 * Be warned.
 *
 * -RF
 */
#define APC_MAGIC_SIZE		sizeof(APC_MAGIC)
#define ACCESS_MAGIC		"apcaccess-linux-4.0"

/*
 * length of ACCESS_MAGIC for convenience - includes NULL termination ditto
 */
#define ACCESS_MAGIC_SIZE	sizeof(ACCESS_MAGIC)

/*
 * JHNC:
 * This string should be the first line of the configuration file.
 * Then if we change the format later, we can just change this string.
 * Also, we could write code to use/convert out-of-date config files.
 */
#define APC_CONFIG_MAGIC	"## apcupsd.conf v1.0 ##"

#define POWERFAIL		"POWER FAILURE"
#define REDO_NET		"RESET NET"

#define ACCESS_FIFO		"/tmp/apcaccess_fifo"
#define PIPE_FIFO		"/tmp/apcpipe_fifo"

#define MAXSTRING		256
#define MESSAGELEN		256
#define MAXTOKENLEN		80
#define MAXSLAVES		20

#define DEFAULT_SPEED		B2400

#define GO_ON_BATT		'W'
#define GO_ON_LINE		'X'
#define LIGHTS_TEST		'A'
#define FAILURE_TEST		'U'

/*
 * Future additions for contolled discharing of batteries
 * extend lifetimes.
 */

#define DISCHARGE		'D'
#define CHARGE_LIM		25

#define UPS_ENABLED		'?'
#define UPS_ON_BATT		'!'
#define UPS_ON_LINE		'$'
#define BATT_LOW		'%'
#define BATT_OK			'+'
#define UPS_GARBAGE		'|'
#define UPS_TRAILOR		':'
#define UPS_LF			'\n'
#define UPS_CR			'\r'
/*
 * For apclock.c functions
 *
 * -RF
 */
#define LCKSUCCESS		0 /* lock file does not exist so go */
#define LCKERROR		1 /* lock file not our own and error encountered */
#define LCKEXIST		2 /* lock file is our own lock file */
#define LCKNOLOCK		3 /* lock file not needed: APC_NET */

/*
 * Generic defines for boolean return values.
 *
 * -RF
 */
#define SUCCESS			0 /* Function successfull */
#define FAILURE			1 /* Function failure */

/* These seem unavoidable :-( */
#ifndef TRUE
#	define TRUE            1
#endif
#ifndef FALSE
#	define FALSE           0
#endif

/*
 * IPC defines.
 */
#define SEM_ID			0x00FEED00
#define SHM_ID			0x10FEED01
/*
 * Only 1 semaphore
 */
#define SEMNUM			0

/*
 * Schedule times for all the threads in seconds.
 * For now I have set up all of them at 10 seconds but in the future we will
 * fine tune the times for better performance.
 */
#define TIMER_SERIAL		10
#define TIMER_NET		10
#define TIMER_SLAVES		10
#define TIMER_REPORTS		10
#define TIMER_ACTION		10

#define MAX_THREADS		7

#endif /* _APC_DEFINES_H */
