/*
 * parse.c - Parsing of the configuration file
 *
 * Copyright (c) 1995 Pavel Korensky
 * All rights reserved.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 * 
 * IN NO EVENT SHALL PAVEL KORENSKY BE LIABLE TO ANY PARTY FOR
 * DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
 * OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF PAVEL
 * KORENSKY HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * PAVEL KORENSKY SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND PAVEL KORENSKY HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 */

/*	
 * Version:
 *	
 * $Id: parse.c,v 1.2 1995/11/07 12:40:46 root Exp root $
 *	
 *	
 * History:
 *	
 * $Log: parse.c,v $
 * Revision 1.2  1995/11/07  12:40:46  root
 * Version 0.5 Beta uploaded to the sunsite
 *
 * Revision 1.1  1995/11/01  15:24:07  root
 * Initial revision
 *
 *	
 */	


#include "apcd.h"
#include "version.h"

static char *version="$Id: parse.c,v 1.2 1995/11/07 12:40:46 root Exp root $";

int parse_config()
{
	FILE	*cf;
	char	*buffer;
		
	if((cf = fopen(CONFIGFILENAME,"r")) == NULL) {
		fprintf(stderr,"\n Cannot open configuration file %s\n",CONFIGFILENAME);
		return(0);
	}
	buffer=calloc(255,sizeof(char));
	while(fgets(buffer,100,cf)) {
		if(buffer[0]!='#') {
			if(strncmp("PORT",buffer,4) == 0) {
				sscanf(buffer,"%*s %s",use_port);
#ifdef DEBUGGING
				printf("PORT %s\n",use_port);
#endif
				slave=2;			/* I must be master */
			}
			if(strncmp("TIMEOUT",buffer,7) == 0) {
				sscanf(buffer,"%*s %d",&power_timer);
#ifdef DEBUGGING
				printf("TIMEOUT %d\n",power_timer);
#endif
				slave=2;
			}
			if(strncmp("LOGTIMEOUT",buffer,10) == 0) {
				sscanf(buffer,"%*s %d",&log_timer);
#ifdef DEBUGGING
				printf("LOGTIMEOUT %d\n",log_timer);
#endif
				slave=2;
			}
			if(strncmp("LOGFILENAME",buffer,11) == 0) {
				sscanf(buffer,"%*s %s",logfilename);
#ifdef DEBUGGING
				printf("LOGFILENAME %s\n",logfilename);
#endif
				slave=2;
			}
						        

			if(strncmp("SLAVE",buffer,5) == 0) {
				if(num_slaves <= MAX_SLAVES) {
					sscanf(buffer,"%*s %s",slaves[num_slaves++]);
#ifdef DEBUGGING
					printf("SLAVE %s   %d of %d\n",slaves[num_slaves-1],num_slaves,MAX_SLAVES);
#endif
				}
			}
			if(strncmp("MASTER",buffer,6) == 0) {
				if(slave != 0) {
					printf("I can't be both MASTER and SLAVE\n");
					return(0);
				}
				sscanf(buffer,"%*s %s",master_name);
#ifdef DEBUGGING
				printf("MASTER %s\n",master_name);
#endif
				slave=1;
			}
		}
	}

#ifdef DEBUGGING
	if(slave==1) printf("I am slave\n");
	if(slave==2) printf("I am master\n");
	if(slave==0) printf("slave variable is 0 !!!\n");
#endif

	fclose(cf);
	return (slave);
}
	
