/* 	$Id: xsignal.c,v 1.10 1998/01/30 13:33:39 pirx Exp $	 */

/*
 * Author: Achim Bangert (abangert@ix.urz.uni-heidelberg.de)
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <signal.h>
#include <sys/resource.h>
#include <ctype.h>
#include <assert.h>
#include <errno.h> 
/* 1998/01/30 added after bug report from 
   Christoph Lameter <christoph@lameter.com> */

#include <X11/cursorfont.h>
#include <X11/IntrinsicP.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/SimpleMenP.h>
#include <X11/Xaw/Sme.h>
#include <X11/Xaw/SmeP.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/SmeLine.h>
#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/TextP.h>
#include "Listsel.h"
#include "SmeCascade.h"

#include "global.h"
#include "xtop.h"
#include "xsignal.h"

static Widget signal_shell;
static Widget to_minus, by_minus;

static void clear_report(Widget w, XtPointer client, XtPointer call)
/* reset report text */
{
  XawTextBlock del_block;
  int length;

  del_block.firstPos = 0;
  del_block.length = 0;
  del_block.ptr = "";
  del_block.format = XawFmt8Bit;
  XawTextDisableRedisplay(report_text);
  XtVaSetValues(report_text, XtNeditType, XawtextEdit, NULL);
  length = ((TextWidget) report_text)->text.lastPos;
  XawTextSetInsertionPoint(report_text, 0);
  XawTextReplace(report_text, 0, length, &del_block);
  XtVaSetValues(report_text, XtNeditType, XawtextRead, NULL);
  XawTextEnableRedisplay(report_text); 
}

void append_string2report(String addendum)
/* append string to report text */
{
  XawTextBlock add_block;
  int length;

  add_block.firstPos = 0;
  add_block.length = strlen(addendum);
  add_block.ptr = addendum;
  add_block.format = XawFmt8Bit;
  XawTextDisableRedisplay(report_text);
  XtVaSetValues(report_text, XtNeditType, XawtextAppend, NULL);
  length = ((TextWidget) report_text)->text.lastPos;
  XawTextReplace(report_text, length, length, &add_block);
  XawTextSetInsertionPoint(report_text, length + add_block.length);
  XtVaSetValues(report_text, XtNeditType, XawtextRead, NULL);
  XawTextEnableRedisplay(report_text); 
}

static void signal_callback(Widget w, XtPointer client, XtPointer call)
/* send signal to selected processes */
{

#define LEN 1024

  int signal2send = (int) client;
  process_info_ptr p = &procinfo;
  int *selection;
  char buffer[LEN];

  selection = XlswGetSelection(proc_selector);
  if(*selection == XlswINVALID_INDEX)
    {
      XBell(app_display, 50);
      append_string2report(app_resources.nothing_selected_error);
      return;
    }
  while(*selection != XlswINVALID_INDEX)
    {
      if(kill(p->table[*selection]->pid, signal2send))
	switch(errno)
	  {
	  case EINVAL: /* invalid signal */
	    snprintf(buffer, LEN, app_resources.signal_invalid_error, 
		     signal2send, p->table[*selection]->pid);
	    break;
	  case ESRCH:  /* pid does not exist or belongs to zombie */
	    snprintf(buffer, LEN, app_resources.signal_process_error, 
		     signal2send, p->table[*selection]->pid);
	    break;
	  case EPERM:  /* no permission to send signal */
	    snprintf(buffer, LEN, app_resources.signal_permission_error, 
		     signal2send, p->table[*selection]->pid);
	  }
      else
	snprintf(buffer, LEN, app_resources.signal_success, 
		 signal2send, p->table[*selection]->pid);
      append_string2report(buffer);
      ++selection;
    }

#undef LEN

}

static void renice_callback(Widget w, XtPointer client, XtPointer call)
/* renice selected processes */
{

#define LEN 1024

  int renice2 = (int) client;
  process_info_ptr p = &procinfo;
  int *selection;
  Boolean relative;
  char buffer[LEN];

  selection = XlswGetSelection(proc_selector);
  if(*selection == XlswINVALID_INDEX)
    {
      XBell(app_display, 50);
      append_string2report(app_resources.nothing_selected_error);
      return;
    }
  /* take renice2 relative to processes nice value */
  relative = (renice2 < 0);
  w = XawSimpleMenuGetActiveEntry(XtParent(XtParent(w)));
  if(w == to_minus || w == by_minus)
    renice2 = -renice2;
  while(*selection != XlswINVALID_INDEX)
    {
      int niceness;

      niceness = (relative) ? p->table[*selection]->nice - renice2 : renice2;
      /* since setpriority can legitimately return -1 clear errno */
      errno = 0;
      if(setpriority(PRIO_PROCESS, p->table[*selection]->pid, niceness) == -1
	 && errno)
	switch(errno)
	  {
	  case ESRCH:  /* pid does not exist or belongs to zombie */
	    snprintf(buffer, LEN, app_resources.renice_process_error, 
		     p->table[*selection]->pid, niceness);
	    break;
	  case EPERM:  /* no permission to affect stranger's process */
	    snprintf(buffer, LEN, app_resources.renice_permission_error, 
		     p->table[*selection]->pid, niceness);
	    break;
	  case EACCES:  /* no permission to lower priority */
	    snprintf(buffer, LEN, app_resources.renice_access_error, 
		     p->table[*selection]->pid, niceness);
	  }
      else
	snprintf(buffer, LEN, app_resources.renice_success, 
		 p->table[*selection]->pid, niceness);
      append_string2report(buffer);
      ++selection;
    }

#undef LEN

}

static void resource2signal_menu(String resource)
/* build signal menu from application resource */
{
  char buffer[128];
  char label[32];
  int signal2send, count;
  int num_read, num_left;

  count = 0;
  for(num_left = strlen(resource); num_left > 0; num_left -= num_read)
    {
      num_read = -1;
      sscanf(resource, "%30[^:\n]:%d\n%n", label, &signal2send, &num_read);
      if(num_read == -1)
	if(strncmp(label, OPTION_SEPARATOR, strlen(OPTION_SEPARATOR)) == 0)
	  {
	    XtCreateManagedWidget("separator", smeLineObjectClass, 
				  signal_shell, NULL, 0);
	    /*
	     * move cursor to begin of next line
	     */
	    sscanf(resource, "%30[^\n]\n%n", label, &num_read);
	    resource += num_read;
	    continue;
	  }
	else
	  {
	    String param = buffer;
	    Cardinal num_param = 1;
	    
	    snprintf(buffer, 128, "\"%s\" in line %d of", resource, count);
	    XtAppErrorMsg(app_context, "conversionFailed", "xtopSignalMenu", 
			  "XtopError", "Conversion of entry %s signalMenu " 
			  "resource failed", &param, &num_param);
	  }
      if(0 < signal2send && signal2send < NSIG)
	{
	  Widget w;

	  sprintf(buffer, "sendSignal%d", signal2send);
	  w = XtVaCreateManagedWidget(buffer, smeBSBObjectClass, signal_shell,
				      XtNlabel, label, NULL);
	  XtAddCallback(w, XtNcallback, signal_callback, 
			(XtPointer) signal2send);
	  ++count;
	}
      else
	{
	  String param = buffer;
	  Cardinal num_param = 1;

	  snprintf(buffer, 128, "%d labeled \"%s\"", signal2send, label);
	  XtAppWarningMsg(app_context, "unknownSignal", "xtopSignalMenu", 
			  "XtopError", "Unknown signal %s ignored",
			  &param, &num_param);
	}
      resource += num_read;
    }
}

void create_affect_menu(void)
/* create menu providing ways to affect the selected processes */
{
  Widget w;
  Widget shell;
  Widget renice_shell, to_shell, by_shell;
  Arg arglist[3];
  Cardinal n;
  char buffer[8];
  int i;

  w = XtCreateManagedWidget("affectButton", menuButtonWidgetClass, 
			    button_bar, NULL, 0);
  shell = XtCreatePopupShell("affectShell", simpleMenuWidgetClass, w, NULL, 0);
  XtVaSetValues(w, XtNmenuName, "affectShell", NULL);
  signal_shell = 
    XtCreatePopupShell("signalShell", simpleMenuWidgetClass, shell, NULL, 0);
  /*
   * construct menu from application resource
   */
  resource2signal_menu(app_resources.signal_menu);
  renice_shell = 
    XtCreatePopupShell("reniceShell", simpleMenuWidgetClass, shell, NULL, 0);
  to_shell = XtCreatePopupShell("toShell", simpleMenuWidgetClass, 
				renice_shell, NULL, 0);
  for(i = 0; i < 21; ++i)
    {
      sprintf(buffer, "to%02d", i);
      w = XtCreateManagedWidget(buffer, smeBSBObjectClass, to_shell, NULL, 0);
      XtAddCallback(w, XtNcallback, renice_callback, (XtPointer) i);
    }
  by_shell = XtCreatePopupShell("byShell", simpleMenuWidgetClass, 
				renice_shell, NULL, 0);
  for(i = 1; i <= 10; i += i - (i % 2) + 1)
    {
      sprintf(buffer, "by%02d", i);
      w = XtCreateManagedWidget(buffer, smeBSBObjectClass, by_shell, NULL, 0);
      XtAddCallback(w, XtNcallback, renice_callback, (XtPointer) -i);
    }
  n = 0;
  XtSetArg(arglist[n], XtNrightMargin, 20); n++;
  XtSetArg(arglist[n], XtNcascadeBitmap, arrow_bitmap); n++;
  XtSetArg(arglist[n], XtNsubmenuShell, to_shell); n++;
  assert(n <= XtNumber(arglist));
  XtCreateManagedWidget("toPlus", smeCascadeObjectClass, renice_shell,
			arglist, n);
  to_minus = 
    XtCreateManagedWidget("toMinus", smeCascadeObjectClass, renice_shell,
			  arglist, n);
  XtSetArg(arglist[n - 1], XtNsubmenuShell, by_shell);
  XtCreateManagedWidget("byPlus", smeCascadeObjectClass, renice_shell,
			arglist, n);
  by_minus = 
    XtCreateManagedWidget("byMinus", smeCascadeObjectClass, renice_shell,
			  arglist, n);
  XtSetArg(arglist[n - 1], XtNsubmenuShell, signal_shell);
  XtCreateManagedWidget("signal", smeCascadeObjectClass, shell, arglist, n);
  XtSetArg(arglist[n - 1], XtNsubmenuShell, renice_shell);
  XtCreateManagedWidget("renice", smeCascadeObjectClass, shell, arglist, n);
  w = XtCreateManagedWidget("clearReport", smeBSBObjectClass, shell, NULL, 0);
  XtAddCallback(w, XtNcallback, clear_report, NULL);
}








