/* 	$Id: global.h,v 1.7 1998/01/20 14:53:20 pirx Exp $	 */

/*
 * Author: Achim Bangert (abangert@ix.urz.uni-heidelberg.de)
 */

#ifndef GLOBAL_H
#define GLOBAL_H

#include "proc/readproc.h"

#define DEFAULT_REFRESH 5000
#define XtRField "Field"
#define NUM_FIELDS 27
#define OPTION_SEPARATOR "-"
#define KB_PER_PAGE (1 << (PAGE_SHIFT - 10))

typedef enum {
  P_UID = 0, P_PID, P_PPID, P_TTY, P_TTYL, P_TIME, P_CTIME, P_PRI, P_NICE,
  P_PAGEIN, P_TSIZ, P_DSIZ, P_SIZE, P_TRS, P_RSS, P_SWAP, P_SHARE, P_DT, 
  P_FLAGS, P_WCHAN, P_SWCHAN, P_STAT, P_USER, P_COMMAND, P_COMMANDLINE, 
  P_PCPU, P_PMEM, P_END
} field_id_t;

typedef struct {
  String display_menu;
  String signal_menu;
  String filt_pid_headline;
  String filt_tty_headline;
  String filt_uid_headline;
  String filt_stat_headline;
  String sel_tty_headline;
  String sel_uid_headline;
  String sel_stat_headline;
  String nothing_selected_error;
  String signal_invalid_error;
  String signal_process_error;
  String signal_permission_error;
  String signal_success;
  String renice_process_error;
  String renice_permission_error;
  String renice_access_error;
  String renice_success;
  int refresh_interval;
  Boolean print_version_flag;
} AppResources;

extern AppResources app_resources;

typedef struct field_info_s {
  int map[NUM_FIELDS];
  int shown_fields[NUM_FIELDS];
  char header[1024];
  int num_fields;
  int num_shown;
} field_info_t, *field_info_ptr;

extern field_info_t fieldinfo;

extern char *field_names[];
extern char *field_headers[];

typedef struct int_list_s {
  int *list;
  int num_allocated;
  int num_used;
} int_list_t, *int_list_ptr;

typedef struct string_list_s {
  String *list;
  int num_allocated;
  int num_used;
} string_list_t, *string_list_ptr;

typedef struct pid_list_s {
  int fields[3];
  pid_t *list;
  int num_allocated;
} pid_list_t, *pid_list_ptr;

typedef struct dev_list_s {
  int fields[1];
  dev_t *list;
  int num_allocated;
} dev_list_t, *dev_list_ptr;

typedef struct uid_list_s {
  int fields[2];
  uid_t *list;
  int num_allocated;
  int num_used;
} uid_list_t, *uid_list_ptr;

typedef struct history_list_s {
  int pid;
  int time;
} history_list_t, *history_list_ptr;

#define PROC_FILL (PROC_FILLMEM | PROC_FILLCMD | PROC_FILLTTY | PROC_FILLUSR)

typedef struct process_info_s {
  proc_t **table;
  String *str;
  history_list_ptr histlist;
  int num_allocated;
  int num_used;
  int num_hist;
} process_info_t, *process_info_ptr;

extern process_info_t procinfo;

#define NUM_FILTERS 8

#define FILT_PID    0
#define FILT_SELECT 1
#define FILT_TTY    2
#define FILT_UID    3
#define FILT_OWN    4
#define FILT_STAT   5
#define FILT_ANYTTY 6
#define FILT_NONE   7

#define PROC_NONE   0x1
#define PROC_SELECT (PROC_PID | PROC_NONE)
#define PROC_OWN    (PROC_UID | PROC_NONE)

typedef struct filter_info_s {
  int proc_flag[NUM_FILTERS];
  pid_list_t pid;
  dev_list_t tty;
  uid_list_t uid;
  char stat[6];
  string_list_t str;
} filter_info_t, *filter_info_ptr;

extern filter_info_t filtinfo;

#define MAX(a, b) (((a) > (b)) ? (a) : (b))
#define MIN(a, b) (((a) < (b)) ? (a) : (b))

extern XtAppContext app_context;
extern Display *app_display;
extern Screen *app_screen;
extern Pixmap tick_bitmap;
extern Pixmap arrow_bitmap;
extern XtIntervalId refresh_timer;
extern Atom _XA_WM_PROTOCOLS;
extern Atom _XA_WM_DELETE_WINDOW;
extern Widget app_shell;
extern Widget button_bar;
extern Widget proc_selector;
extern Widget report_text;

#endif
















