/* * Last edited: Dec 12 17:28 1992 (mauch) */
/*
 * $Log:	xhchat.c,v $
 * Revision 2.9  92/12/13  14:38:21  kdh
 * fixed some bugs (ReadConfigFile,Xhchat)
 * new options: idle-colors
 *              bell in xhchat
 *              automatic toplevel width (font width)
 *              dynamic column number
 *              activity light
 * 
 * Revision 2.8  92/12/10  12:37:57  kdh
 * some bug fixes
 * activity light
 * 
 * Revision 2.8  92/11/16  10:24:34  kdh
 *  file hierarchy changed, new x-based talk, bug-fixes
 * 
 * $Id: xhchat.c,v 2.9 92/12/13 14:38:21 kdh Exp $
 */

/*

Copyright (C) 1992 Klaus Hartenstein

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted, provided
that the above copyright notice appear in all copies and that both that
copyright notice and this permission notice appear in supporting
documentation.  This software is provided "as is" without express or
implied warranty.

*/


#include "xhchat.h"
#include "globaldefs.h"
#include <sys/types.h>
#ifndef _BSD_COMPAT
#define _BSD_COMPAT
#endif
#include <signal.h>


/********************************************************************************/
/* returns the type of the keysym */

int KeyType(keysym, num)
     char *keysym;
     int num;
{
  if(strstr(keysym, "Delete")!=NULL)    return DEL;
  if(strstr(keysym, "BackSpace")!=NULL) return BS;
  if(strstr(keysym, "Return")!=NULL)    return RET;
  if(strstr(keysym, "Left")!=NULL)      return LEFT;
  if(strstr(keysym, "Right")!=NULL)     return RIGHT;
  if(strstr(keysym, "Up")!=NULL)        return UP;
  if(strstr(keysym, "Down")!=NULL)      return DOWN;
  if(Cntrl==True){
    if(keysym[0]=='d') return CTRL_D;    /* del char    */
    if(keysym[0]=='k') return CTRL_K;    /* del to eoln */
    if(keysym[0]=='c') return CTRL_C;    /* exit        */
    return OTHER;
  }
  else
    if(num==0)
      return OTHER;
    else
      return NORM;
}
/********************************************************************************/
/* sets global control-variable */

void SetControl(keysym, mode)
     char *keysym;
     int mode;
{
  if(strstr(keysym, "Control") != NULL){
    if(mode==PRESS){
    Cntrl=True;
    }
    else{
      Cntrl=False;
    }
  }
}
/********************************************************************************/
/* adds a char to the widget w at position pos */

AddChar(w, pos, c)
     Widget w;
     XawTextPosition pos;
     char *c;
{
  XawTextBlock txt;
  txt.firstPos=0;
  txt.format=FMT8BIT;
  txt.length=strlen(c);
  txt.ptr=c;
  XawTextReplace(w, pos, pos, &txt);
  XawTextSetInsertionPoint(w, pos+txt.length);
}
/********************************************************************************/
/* deletes the char left to pos */

DeleteCharLeft(w, pos)
     Widget w;
     XawTextPosition pos;
{
  XawTextBlock txt;
  txt.firstPos=0;
  txt.format=FMT8BIT, 
  txt.length=0;
  XawTextReplace(w, pos-1, pos, &txt);
  XawTextSetInsertionPoint(w, pos-1);
}
/********************************************************************************/
/* deletes the char right to pos */

DeleteCharRight(w, pos)
     Widget w;
     XawTextPosition pos;
{
  XawTextBlock txt;
  txt.firstPos=0;
  txt.format=FMT8BIT, 
  txt.length=0;
  XawTextReplace(w, pos, pos+1, &txt);
  XawTextSetInsertionPoint(w, pos);
}
/********************************************************************************/
/* deletes all up to the end of the line in pos */

DeleteLine(w, pos)
     Widget w;
     XawTextPosition pos;
{
  XawTextPosition found;
  XawTextBlock txt1, txt2;
  txt1.firstPos=0;
  txt1.format=FMT8BIT, 
  txt1.length=1;
  txt1.ptr="\n";
  txt2.firstPos=0;
  txt2.format=FMT8BIT, 
  txt2.length=0;
  found=XawTextSearch(w, XawsdRight, &txt1);
  if(found==pos)
    DeleteCharRight(w, pos);
  else if(found!=XawTextSearchError)
    XawTextReplace(w, pos, found, &txt2);
  else
    XawTextReplace(w, pos, 1000000, &txt2);
  XawTextSetInsertionPoint(w, pos);
}
/********************************************************************************/
/* deletes all until the next space */

DeleteWord(w, pos)
     Widget w;
     XawTextPosition pos;
{
  XawTextPosition found;
  XawTextBlock txt1, txt2;
  txt1.firstPos=0;
  txt1.format=FMT8BIT, 
  txt1.length=1;
  txt1.ptr=" ";
  txt2.firstPos=0;
  txt2.format=FMT8BIT, 
  txt2.length=0;
  found=XawTextSearch(w, XawsdRight, &txt1);
  if(found==pos)
    DeleteCharRight(w, pos);
  else if(found!=XawTextSearchError)
    XawTextReplace(w, pos, found, &txt2);
  else
    XawTextReplace(w, pos, 1000000, &txt2);
  XawTextSetInsertionPoint(w, pos);
}
/********************************************************************************/
/* clears the widget w */

void DeleteAll(w)
     Widget w;
{
  XawTextPosition first;
  XawTextBlock txt;
  txt.firstPos=0;
  txt.format=FMT8BIT, 
  txt.length=0;
  first=XawTextTopPosition(w);
  XawTextReplace(w, first, 100000, &txt);
}
/********************************************************************************/
/* exit program */

void do_quit(w,  client_data,  call_data)
     Widget w;
     XtPointer client_data,  call_data;
{
  XtDestroyApplicationContext(app_con_xhchat);
  kill(getppid(),SIGUSR2);
  exit(0);
}
/********************************************************************************/
/* toggle wrap mode of textwidgets */

void do_wrap(w,  client_data,  call_data)
     Widget w;
     XtPointer client_data,  call_data;
{
  static Boolean status1=False;
  static Boolean status2=False;
  Boolean *status;
  Widget s, d;
  if((int)client_data == SOURCE1){
    d=drain1;
    s=source1;
    status=(Boolean *)&status1;
  }
  else{
    d=drain2;
    s=source2;
    status=(Boolean *)&status2;
  }
  if(*status==False){
    *status=True;
    XtVaSetValues(s,XtNwrap,XawtextWrapWord,NULL);
    XtVaSetValues(d,XtNwrap,XawtextWrapWord,NULL);
  }
  else{
    *status=False;
    XtVaSetValues(s,XtNwrap,XawtextWrapNever,NULL);
    XtVaSetValues(d,XtNwrap,XawtextWrapNever,NULL);
  }
}
/********************************************************************************/
/* callback to clear all */

void do_clear(w,  client_data,  call_data)
     Widget w;
     XtPointer client_data,  call_data;
{
  Widget s, d;
  if((int)client_data == SOURCE1){
    d=drain2;
    s=source1;
  }
  else{
    d=drain1;
    s=source2;
  }
  DeleteAll(s);
  DeleteAll(d);
}
/********************************************************************************/
/* main event handler for keypresses */

void do_keypress(w, client_data, event)
     Widget w;
     XtPointer client_data;
     XEvent *event;
{
  XComposeStatus compose;
  Widget drain;
  char cp[100];
  char keysym[256];
  KeySym ks;
    int i;
  XawTextPosition insert;
  if(w==source1){
    drain=drain2;
  }
  else{
    drain=drain1;
  }
  memset(cp, 0, 100);
  insert=XawTextGetInsertionPoint(w);
  if(event->type==2){
    i=XLookupString(&(event->xkey), cp, 100, &ks,&compose);
    if(ks == 0) return;
    strcpy(keysym,XKeysymToString(ks));
    if(i==0)
      SetControl(keysym, PRESS);
    switch(KeyType(keysym, i)){
    case CTRL_D:
      DeleteCharRight(w, insert);
      DeleteCharRight(drain, insert);
      break;
    case CTRL_K:
      DeleteLine(w, insert);
      DeleteLine(drain, insert);
      break;
    case CTRL_C:
      do_quit(NULL,NULL,NULL);
      break;
    case CTRL_P:
      break;
    case CTRL_N:
      break;
    case CTRL_F:
      break;
    case CTRL_B:
      break;
    case RET:
      AddChar(w, insert, "\n");
      AddChar(drain, insert, "\n");
      break;
    case DEL:
      DeleteCharLeft(w, insert);
      DeleteCharLeft(drain, insert);
      break;
    case BS:
      DeleteCharLeft(w, insert);
      DeleteCharLeft(drain, insert);
      break;
    case NORM:
      AddChar(w, insert, cp);
      AddChar(drain, insert, cp);
      break;
    case OTHER:
      break;
    default:
      break;
    }
  }
}
/********************************************************************************/
/* event handler for key release */

void do_keyrelease(w, client_data, event)
     Widget w;
     XtPointer client_data;
     XEvent *event;
{
  XComposeStatus compose;
  
  Widget drain;
  XawTextPosition insert;
  int i;
  char keysym[256];
  KeySym ks;
  char cp[100];
  if(w==source1){
    drain=drain2;
  }
  else{
    drain=drain1;
  }
  memset(cp, 0, 100);
  i=XLookupString(&(event->xkey), cp, 100, &ks , &compose);
  if(ks == 0) return;
  if(i==0){
    strcpy(keysym,XKeysymToString(ks));
    SetControl(keysym, RELEASE);
  }
  insert=XawTextGetInsertionPoint(w);
  XawTextSetInsertionPoint(drain, insert);
}
/********************************************************************************/
void KeyDownAction(w, event, params, num_params)
     Widget w;
     XButtonEvent *event;
     String *params;
     Cardinal num_params;
{
  do_keypress(w,NULL,event);
}
void KeyUpAction(w, event, params, num_params)
     Widget w;
     XButtonEvent *event;
     String *params;
     Cardinal num_params;
{
  do_keyrelease(w,NULL,event);
}
/********************************************************************************/
void do_buttonpress(w, client_data, event)
     Widget w;
     XtPointer client_data;
     XEvent *event;
{
  char *CutBuffer;
  int nbytes;
  int insert;
  Widget drain;
  if(w==source1){
    drain=drain2;
  }
  else{
    drain=drain1;
  }
  if(event->xbutton.button==Button2){
    if((CutBuffer=XFetchBuffer(XtDisplay(w),&nbytes,0)) != NULL){
      insert=XawTextGetInsertionPoint(w);
      AddChar(w,insert,CutBuffer);
      AddChar(drain,insert,CutBuffer);
    }
  }
}
/********************************************************************************/
/* rings the bell */

void do_bell(w,  client_data,  call_data)
     Widget w;
     XtPointer client_data,  call_data;
{
  XBell(d1,0);
  XBell(d2,0);
}
/********************************************************************************/  
void do_buttonmotion(w, client_data, event)
     Widget w;
     XtPointer client_data;
     XEvent *event;
{
}
/********************************************************************************/  
Xhchat(disp, argc, argv, top)
     char *disp;
     int argc;
     char **argv;
     Widget top;
{
  Arg args[2];
  int n=0;
  char str[256];
  Display *homeDisp = XtDisplay(top);
  strcpy(str,homeDisp->display_name);
  app_con_xhchat =  XtCreateApplicationContext();
  XtAppAddActions(app_con_xhchat,text_actions,XtNumber(text_actions));
  XtAppSetFallbackResources(app_con_xhchat,fallback_res);
  if((d1 = XtOpenDisplay(app_con_xhchat,
			str,
			 "xhchat",
			 "Xhchat",
			 (XrmOptionDescRec *)NULL, 0,
			 (Cardinal *)&argc, argv))==NULL){
    fprintf(stderr, "Cannot open display: %s\n",homeDisp->display_name);
    do_quit(NULL,NULL,NULL);
  } 
  if((d2 = XtOpenDisplay(app_con_xhchat,
			 disp,
			 "xhchat",
			 "Xhchat",
			 (XrmOptionDescRec *)NULL, 0,
			 (Cardinal *)&argc, argv))==NULL){
    fprintf(stderr, "Cannot open display %s\n", argv[1]);
    do_quit(NULL,NULL,NULL);
  }
  XBell(d1,0);
  XBell(d2,0);
  username=(char *)getenv("USER");
  sprintf(labelstring,"From: %s To: %s",username,d2->display_name);
  XtSetArg(args[n], XtNx, XHCHAT_INITX); n++;
  XtSetArg(args[n], XtNy, XHCHAT_INITY); n++;
  top1   = XtAppCreateShell("xhchat",
			    "Xhchat",
			    applicationShellWidgetClass,
			    d1, args, n);
  top2   = XtAppCreateShell("xhchat",
			    "Xhchat",
			    applicationShellWidgetClass,
			    d2, args, n);
  
  lbl_1  =XCreateBitmapFromData(d1,
				RootWindowOfScreen(XtScreen(top1)),
				lbl_bits,
				lbl_width,
				lbl_height);
  lbl_2  =XCreateBitmapFromData(d2,
				RootWindowOfScreen(XtScreen(top2)),
				lbl_bits,
				lbl_width,
				lbl_height);
  paned1 = XtVaCreateManagedWidget("top1", panedWidgetClass,
				   top1, NULL);
  paned2 = XtVaCreateManagedWidget("top2", panedWidgetClass,
				   top2, NULL);
  XtVaSetValues(paned1,XtNshowGrip,False,NULL);    /* shit! */
  XtVaSetValues(paned2,XtNshowGrip,False,NULL);
  box1   = XtVaCreateManagedWidget("top1", boxWidgetClass, paned1, NULL);
  box2   = XtVaCreateManagedWidget("top2", boxWidgetClass, paned2, NULL);
  cmd    = XtVaCreateManagedWidget("Exit", commandWidgetClass, box1, NULL);
  XtAddCallback(cmd, XtNcallback, do_quit, NULL);
  cmd    = XtVaCreateManagedWidget("Exit", commandWidgetClass, box2, NULL); 
  XtAddCallback(cmd, XtNcallback, do_quit, NULL);
  cmd    = XtVaCreateManagedWidget("Clear", commandWidgetClass, box1, NULL);
  XtAddCallback(cmd, XtNcallback, do_clear, (XtPointer)SOURCE1);
  cmd    = XtVaCreateManagedWidget("Clear", commandWidgetClass, box2, NULL); 
  XtAddCallback(cmd, XtNcallback, do_clear, (XtPointer)SOURCE2);
  cmd    = XtVaCreateManagedWidget("Wrap", toggleWidgetClass, box1,
				    NULL);
  XtAddCallback(cmd, XtNcallback, do_wrap, (XtPointer)SOURCE1);
  cmd    = XtVaCreateManagedWidget("Wrap", toggleWidgetClass, box2,
				    NULL); 
  XtAddCallback(cmd, XtNcallback, do_wrap, (XtPointer)SOURCE2);
  cmd    = XtVaCreateManagedWidget("Bell", commandWidgetClass, box1, NULL); 
  XtAddCallback(cmd, XtNcallback, do_bell, (XtPointer)NULL);
  cmd    = XtVaCreateManagedWidget("Bell", commandWidgetClass, box2, NULL); 
  XtAddCallback(cmd, XtNcallback, do_bell, (XtPointer)NULL);
  cmd    = XtVaCreateManagedWidget("", labelWidgetClass, box1,
				   XtNbitmap,lbl_1,
				   XtNborderWidth,0,NULL); 
  cmd    = XtVaCreateManagedWidget("", labelWidgetClass, box2,
				   XtNbitmap,lbl_2,
				   XtNborderWidth,0,NULL); 
  cmd    = XtVaCreateManagedWidget(labelstring, labelWidgetClass, box1,
				   XtNborderWidth, 0, NULL);
  cmd    = XtVaCreateManagedWidget(labelstring, labelWidgetClass, box2,
				   XtNborderWidth, 0, NULL);
  form1  = XtVaCreateManagedWidget("top1", formWidgetClass, paned1, NULL);
  form2  = XtVaCreateManagedWidget("top2", formWidgetClass, paned2, NULL);
  source1= XtVaCreateManagedWidget("source", asciiTextWidgetClass, 
				   form1, 
				   XtNheight,  XHCHAT_HEIGHT / 2,
				   XtNeditType, XawtextEdit,
				   XtNscrollVertical, XawtextScrollWhenNeeded, 
				   XtNscrollHorizontal, XawtextScrollWhenNeeded, 
				   XtNwidth,  XHCHAT_WIDTH, NULL);
  drain1 = XtVaCreateManagedWidget("drain", asciiTextWidgetClass, 
				   form1, 
				   XtNdisplayNonprinting, True, 
				   XtNfromVert, source1, 
				   XtNeditType, XawtextEdit, 
				   XtNscrollVertical, XawtextScrollWhenNeeded, 
				   XtNscrollHorizontal, XawtextScrollWhenNeeded, 
				   XtNheight,  XHCHAT_HEIGHT / 2, 
				   XtNwidth,  XHCHAT_WIDTH, NULL);
  source2 =XtVaCreateManagedWidget("source", asciiTextWidgetClass, 
				   form2, 
				   XtNheight,  XHCHAT_HEIGHT / 2, 
				   XtNdisplayNonprinting, True, 
				   XtNeditType, XawtextEdit, 
				   XtNscrollVertical, XawtextScrollWhenNeeded, 
				   XtNscrollHorizontal, XawtextScrollWhenNeeded, 
				   XtNwidth,  XHCHAT_WIDTH, NULL);
  drain2 = XtVaCreateManagedWidget("drain", asciiTextWidgetClass, 
				   form2, 
				   XtNfromVert, source2, 
				   XtNdisplayNonprinting, True, 
				   XtNeditType, XawtextEdit, 
				   XtNscrollVertical, XawtextScrollWhenNeeded, 
				   XtNscrollHorizontal, XawtextScrollWhenNeeded, 
				   XtNheight,  XHCHAT_HEIGHT / 2, 
				   XtNwidth,  XHCHAT_WIDTH, NULL);  
  XtUninstallTranslations(drain1);
  XtUninstallTranslations(drain2);
  XtUninstallTranslations(source1);
  XtUninstallTranslations(source2);

  /* private translations for text-widgets */
  XtOverrideTranslations(source1, XtParseTranslationTable(txt_trans));
  XtOverrideTranslations(source2, XtParseTranslationTable(txt_trans));
  XtOverrideTranslations(drain1,  XtParseTranslationTable(drain_txt_trans));
  XtOverrideTranslations(drain2,  XtParseTranslationTable(drain_txt_trans));
  XtVaSetValues(source1,XtNaccelerators,XtParseAcceleratorTable(txt_trans),NULL);
  XtVaSetValues(source2,XtNaccelerators,XtParseAcceleratorTable(txt_trans),NULL);
  XtAddEventHandler(source1, ButtonPressMask, False, do_buttonpress, NULL);
  XtAddEventHandler(source2, ButtonPressMask, False, do_buttonpress, NULL);
  XtInstallAccelerators(form1,source1);
  XtInstallAccelerators(form2,source2);
  XtRealizeWidget(top1);
  XtRealizeWidget(top2);
  XtAppMainLoop(app_con_xhchat);
}




