/* $Log:	util.c,v $
 * Revision 2.9  92/12/13  14:41:09  kdh
 * fixed some bugs (ReadConfigFile,Xhchat)
 * new options: idle-colors
 *              bell in xhchat
 *              automatic toplevel width (font width)
 *              dynamic column number
 *              activity light
 * 
 * Revision 2.8  92/12/10  12:37:46  kdh
 * some bug fixes
 * activity light
 * 
 */

/*

Copyright (C) 1992 Klaus Hartenstein

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted, provided
that the above copyright notice appear in all copies and that both that
copyright notice and this permission notice appear in supporting
documentation.  This software is provided "as is" without express or
implied warranty.

*/


#include "xhtalk.h"

/********************************************************************************/
/* print error messages for future error handling */

void Error(str)
     char *str;
{
  fprintf(stderr,"xhtalk error: %s\n",str);
}

/********************************************************************************/
/* private mem-allocation */

char *MyCalloc(nelem, elsize)
     size_t nelem;
     size_t elsize;
{
  char *rtn;
  if((rtn = (char *)calloc(nelem,elsize)) == NULL){
    Error("not enough memory");
    exit(1);
  }
  else
    return rtn;
}
void  *MyRealloc(ptr, size)
     void *ptr;
     size_t size;
{
  void *rtn;
  if((rtn = (void *)realloc(ptr,size)) == NULL){
    Error("not enough memory");
    exit(1);
  }
  else
    return rtn;
}
/********************************************************************************/
/* Create graphics context for activity light */

void CreateGC(w)
     Widget w;
{
  XGCValues values;
  values.function = GXcopy;
  lineGC = XtGetGC(w,GCFunction,&values);
}
/********************************************************************************/
/* create several birtmaps.. */

void CreatePixmaps()
{
  l_cons_PM  =XCreateBitmapFromData(XtDisplay(toplevel),
				    RootWindowOfScreen(XtScreen(toplevel)),
				    l_cons_bits,
				    l_cons_width,
				    l_cons_height);
  l_tty_PM  =XCreateBitmapFromData(XtDisplay(toplevel),
				   RootWindowOfScreen(XtScreen(toplevel)),
				   l_tty_bits,
				   l_tty_width,
				   l_tty_height);

#ifndef HAS_XPM
  LabelPM   =XCreateBitmapFromData(XtDisplay(toplevel),
				   RootWindowOfScreen(XtScreen(toplevel)),
				   xh_bits,
				   xh_width,
				   xh_height);
  activityPM=XCreatePixmapFromBitmapData(XtDisplay(toplevel),
					 RootWindowOfScreen(XtScreen(toplevel)),
					 activity_bits,
					 activity_width,
					 activity_height,
					 WhitePixelOfScreen(XtScreen(toplevel)),
					 BlackPixelOfScreen(XtScreen(toplevel)),
					 DefaultDepthOfScreen(XtScreen(toplevel)));
#else
  (void)XpmCreatePixmapFromData(XtDisplay(toplevel),
				RootWindowOfScreen(XtScreen(toplevel)),
				ColorXh,
				&LabelPM,
				NULL,NULL);
  (void)XpmCreatePixmapFromData(XtDisplay(toplevel),
				RootWindowOfScreen(XtScreen(toplevel)),
				activity,
				&activityPM,
				NULL,NULL);
#endif
  IconPM    =XCreatePixmapFromBitmapData(XtDisplay(toplevel),
					 RootWindowOfScreen(XtScreen(toplevel)),
					 xhtalk_icon_BM_bits,
					 xhtalk_icon_BM_width,
					 xhtalk_icon_BM_height,
					 BlackPixelOfScreen(XtScreen(toplevel)),
					 WhitePixelOfScreen(XtScreen(toplevel)),
					 DefaultDepthOfScreen(XtScreen(toplevel)));
}
/********************************************************************************/
/* sets color of commandwidget depending on idlevalue */

void SetColor(w,idlevalue, useColor)
     Widget w;
     int idlevalue;
     Boolean useColor;
{
  if(useColor == True){
    if(( idlevalue >= (Idle/3)) && (idlevalue < ((Idle/3)*2)) && (Idle > 0)){
      XtVaSetValues(w,XtNbackground,IdleColors.idleTwo,NULL);
      return;
    }
    if((idlevalue >= ((Idle/3)*2)) && (Idle > 0)){
      XtVaSetValues(w,XtNbackground,IdleColors.idleThree,NULL);
      return;
    }
    XtVaSetValues(w,XtNbackground, IdleColors.idleOne,NULL);
  }
}
      
    
  
    
  
     
     
