/*

Copyright (C) 1992 Klaus Hartenstein

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted, provided
that the above copyright notice appear in all copies and that both that
copyright notice and this permission notice appear in supporting
documentation.  This software is provided "as is" without express or
implied warranty.

*/

%{
# undef output(c)
/*******************************************************************************/
/* Neudefinition der Funktionen fuer File- Output...                           */
/* (kein output)
/*******************************************************************************/
void output(c)
char c;
{
}

int posix_yylineno = 1;

%}
%START COMMENT TXT
%%

\n			posix_yylineno++;
"/*".*"*/"              ;
"/*".*                  { BEGIN COMMENT;}
<COMMENT>.*"*/"         { BEGIN 0;}
<COMMENT>.*             ;


\"\"                     { 
                           strcpy(yylval.sym,"");
                           return(STRING);
                         }


"\""                    { BEGIN TXT; }
<TXT>\"                 { 
                           strcpy(yylval.sym,"");
                           return(STRING);
                         }

<TXT>[^"]*\"            { if(yytext[yyleng-1]=='\n')
                            {yytext[yyleng-2]='\0';
                              yyleng++;yyleng++;
                            }
                          else
                            {yytext[yyleng-1]='\0';
                             yyleng++;
                            }
                           BEGIN 0;
                           yylval.sym=yytext;
                           return(STRING);
                         }

"host"\n?    return(HOST);
"name"\n?    return(NAME);
[{},]        return(*yytext);

%%
#if 0
yywrap()
{
	return(FALSE);
}
#endif
