
/* $Id: finger.c,v 2.9 92/12/13 14:37:39 kdh Exp $
 * $Log:	finger.c,v $
 * Revision 2.9  92/12/13  14:37:39  kdh
 *  fixed some bugs (ReadConfigFile,Xhchat)
 *  new options: idle-colors
 *               bell in xhchat
 *               automatic toplevel width (font width)
 *               dynamic column number
 *               activity light
 * 
 * Revision 2.8  92/12/10  12:37:04  kdh
 * some bug fixes
 * activity light
 * 
 * Revision 2.8  92/11/16  10:22:35  kdh
 *  file hierarchy changed, new x-based talk, bug-fixes
 * 
 * Revision 2.7  92/10/23  14:08:10  kdh
 * display idle time in buttons
 * 
 * Revision 2.6  92/10/19  16:27:48  kdh
 * New function AddLabel (closes memory leak)
 * 
 * Revision 2.5  92/10/14  08:59:04  kdh
 * memory leak closed
 * 
 * Revision 2.4  92/10/07  12:01:50  kdh
 * replaced strdup->calloc/strcpy
 * wrong index in read_input_from_stdin() corrected
 * 
 * Revision 2.2  92/10/07  12:01:04  kdh
 * *** empty log message ***
 * 
 * Revision 2.1  92/09/25  00:31:41  kdh
 * initial new version with selfmade finger
 * 
 */

/*

Copyright (C) 1992 Klaus Hartenstein

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted, provided
that the above copyright notice appear in all copies and that both that
copyright notice and this permission notice appear in supporting
documentation.  This software is provided "as is" without express or
implied warranty.

*/

/********************************************************************************/
/*                         finger routines for xhtalk                           */
/********************************************************************************/

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <errno.h>
#include <unistd.h>
#include <fcntl.h>
#include <stdio.h>
#include <setjmp.h>
#include "xhtalk.h"

#define DATA "\r\n"     /* data sending to host at port */
#define FINGERPORT 79


jmp_buf env1, env2;                                     /* process state        */
char actHost[256];                                      /* for debug mode       */

extern List *NamesList;

FList  *FingerList;                     /* List, containing all fingerresults   */

extern char *MyCalloc();

/********************************************************************************/
/* pseudo 'interrupt handler' */

void do_alarm()
{
/* do nothing, just interrupt system call: connect */
  if(Debug==True)
    fprintf(stderr,"timeout: connect or request or write data to parent %s\n",actHost);
  fflush(stderr);
  longjmp(env1,0);
}
/********************************************************************************/
/* exit forked child process, called by a SIGKILL from parent */
  
void do_exit()
{
  XtDestroyApplicationContext(app_con);
  exit(0);
}
/********************************************************************************/
/* write results of finger's to stdout -> piped to parent process */

void WriteList(WhichList)
     FList *WhichList;
{
  char str[100];
  for(;WhichList;WhichList = WhichList->next){
    if((strstr(WhichList->Line,"Login") == 0) &&
       (strstr(WhichList->Line,"logged")) == 0){
      sscanf(WhichList->Line,"%s",str);
      if(IsNameInList(NamesList, str))             /* send only important data */
	fprintf(stdout,"%s!%s|",WhichList->Host,WhichList->Line);
    }
  }
}
/********************************************************************************/
/* creates a socket on port 79  opens a connection to the host  */
/* hname, sends a \r\n and receives the finger data             */

int IPC_Finger(hname)
     char *hname;
{
  int sock;
  FILE *fp;
  struct sockaddr_in server;
  struct hostent *hp;
  char buf[1024];
  char *hostname ; /* = (char *)strdup(hname);*/
  long address = 0;
  
  hostname = (char *)MyCalloc(1,strlen(hname)+1);
  strcpy(hostname,hname);
  
  if(Debug==True){
    strcpy(actHost,hname);                             /* for debug mode        */
    fprintf(stderr,"finger [%s]...\n",actHost);        /* get address of host   */
  }
  if (((*hname >= '0') && (*hname <= '9'))){
    address = (long)inet_addr(hname);
    hp = gethostbyaddr(&address, 4, AF_INET);
  }
  else{
    hp = gethostbyname(hname);
  }
  if(hp == 0){
    if(Debug==True)
      fprintf(stderr, "%s unknown host0\n", hname);
    return -1;
  }
  
  memset((char *)&server, 0 , sizeof(server));    /* init values for socket     */
  bcopy(hp->h_addr,&server.sin_addr,4);
  server.sin_port = htons(FINGERPORT); 
  server.sin_family = AF_INET;

                                                 /* create socket               */
  sock = socket(AF_INET, SOCK_STREAM, 0);
  if(sock < 0){
    if(Debug==True)
      perror("opening socket");
    return -1;
  }
  
  alarm(TimeOut);                                /* set alarm for timeout       */
                                                 /*   connect                   */
  if(!setjmp(env1)){                             /* interrrupt...               */
    
    if(connect(sock,(struct sockaddr *)&server, sizeof server) < 0){
      if(Debug==True)
	perror("connecting stream socket");
      return -1;
    }
  }
  else {
    alarm(0);
    return;
  }
  alarm(0);
                                 /* send request <RET> to finger daemon of host  */
  alarm(TimeOut);
  
  if(write(sock, DATA, strlen(DATA)) < 0)
    if(Debug==True)
      perror("write data");
  
  if(!setjmp(env1)){                            /* interrupt                    */
    
    fp = fdopen(sock,"r");
    while(fgets(buf, 1024,fp) != NULL)
      AppendLine(&FingerList,buf,hostname);     /* read finger info into list   */
  }
  else {
    alarm(0);
    return;
  }
  alarm(0);                                      /* reset alarm                 */
  fclose(fp);
  close(sock);
  free(hostname);
  return 0;
}
/********************************************************************************/
/* main function of child process */

void FingerAllHosts(){
  char *cp;
  List *dummy = HostList;
  int i;
  FingerList=NULL;
/*  fcntl(fileno(stdout),F_SETFL,O_NDELAY);*//* non-blocking mode              */
  signal(SIGALRM,do_alarm);                  /* interrupt mechanism            */
  signal(SIGKILL,do_exit);                   /* kill signal from parent process*/
  for(;dummy;dummy=dummy->next)              /* for each host in host-list     */
    IPC_Finger(dummy->Host);                 /* do finger-request              */
  alarm(TimeOut);
  strcpy(actHost,"< stdout buffer too small");/* as error message for write fail*/
  if(!setjmp(env1)){ 
    kill(getppid(),SIGUSR1);                 /* send 'ready' to parent process */
    WriteList(FingerList);                   /* write result to stdout (piped) */
    fprintf(stdout,ENDSYMBOL);               /* write end-symbol to stdout     */
    fflush(stdout);                          /* nothing left?                  */
  }
  else
    fprintf(stderr,"output buffer too small\n");
    
  alarm(0);
  DeleteFList(&FingerList);                  /* clear list                     */
                                             /* not absolute necessary         */
  exit(0);
}

