/*
 * $Log:	callbacks.c,v $
 * Revision 2.9  92/12/13  14:35:31  kdh
 * 
 * Revision 2.8  92/11/16  10:18:25  kdh
 * file hierarchy changed, new x-based talk, bug-fixes
 * 
 * $Id: callbacks.c,v 2.9 92/12/13 14:35:31 kdh Exp $
 */

/*

Copyright (C) 1992 Klaus Hartenstein

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted, provided
that the above copyright notice appear in all copies and that both that
copyright notice and this permission notice appear in supporting
documentation.  This software is provided "as is" without express or
implied warranty.

*/

/********************************************************************************/
/*                      actions and callback procedures                         */
/********************************************************************************/


#include "xhtalk.h"

static int SelectedWidget = 0;    /* stores the number of the last selected w   */

/********************************************************************************/
/* action procedure             */
/* places the infosh at pointer */

void PlaceShell(w, event, params, num_params)
     Widget w;
     XButtonEvent *event;
     String *params;
     Cardinal num_params;
{
  Dimension x,y, rx, ry, wx, wy, wh;
  Dimension num;                                         /* number of widget */
  XtVaGetValues(toplevel, XtNx, &x, XtNy, &y, NULL);
  XtTranslateCoords(w, x, y, (Position *)&rx, (Position *)&ry);
  XtVaGetValues(w, XtNx, &wx, XtNy, &wy, XtNheight, &wh, NULL);
  if(strcmp(params[0],"INFO") == 0)
    XtVaSetValues(infosh,XtNx, x, XtNy, wy+y+wh , NULL);
  else{
    XtVaGetValues(w,XtNcornerRoundPercent,&num,NULL);
#ifdef DO_XHCHAT
    if(UI[(int)num].onConsole==False)
#ifdef XHCHAT_ALWAYS
      XtVaSetValues(chatW,XtNsensitive,True,NULL);
#else      
      XtVaSetValues(chatW,XtNsensitive,False,NULL);
#endif
    else
      XtVaSetValues(chatW,XtNsensitive,True,NULL);
#endif
    XtVaSetValues(selectsh,XtNx, x, XtNy, wy+y+wh , NULL);
  }
}
/********************************************************************************/
/* action procedure             */
/* places the infosh at pointer */

void PopupShell(w, event, params, num_params)
     Widget w;
     XButtonEvent *event;
     String *params;
     Cardinal num_params;
{
  String mname;
  Dimension num=0;
  char str[256];
  XtVaGetValues(w,XtNcornerRoundPercent,&num,NULL);
  sprintf(str,"%s\n%s",UI[(int)num].TalkCmd,UI[(int)num].FingerLine);
  XtVaSetValues(FiLiW,XtNlabel,str,NULL);
  if(strcmp(params[0],"INFO") == 0)  
    XtPopup(infosh,XtGrabNone);
  else
    XtPopup(selectsh,XtGrabNonexclusive);
}
/********************************************************************************/
/* action procedure             */
/* places the infosh at pointer */

void PopdownShell(w, event, params, num_params)
     Widget w;
     XButtonEvent *event;
     String *params;
     Cardinal num_params;
{
  if(strcmp(params[0],"INFO") == 0)
    XtPopdown(infosh);
  else
    XtPopdown(selectsh);
}
/********************************************************************************/
/* action procedure               */
/* sets the global SelectedWidget */

void SetGlobalWidgetNum(w, event, params, num_params)
     Widget w;
     XButtonEvent *event;
     String *params;
     Cardinal num_params;
{
  Dimension num;
  XtVaGetValues(w,XtNcornerRoundPercent,&num,NULL);
  SelectedWidget = (int)num;
}


/********************************************************************************/
/* callback procedure                */
/* handle selection of dialog widget */

void SelectDialog(w,client_data, call_data)
     Widget w;
     XtPointer client_data, call_data;
{
  if((int)client_data == QUIT){
    kill(ChildID,SIGKILL);
    XtDestroyApplicationContext(app_con);
    exit(0);
  } else if ((int)client_data == KICK) {
    DoFinger();
    XtPopdown(dlgshell);
  } else XtPopdown(dlgshell);
}
/********************************************************************************/
/* callback procedure  */
/* pops up info-dialog */

void PopupDlg(w, client_data, call_data)
     Widget w;
     XtPointer client_data, call_data;
{
  Position x,y,xx,yy;
  XtVaGetValues(box,XtNx,&x,XtNy,&y,NULL);
  XtTranslateCoords(toplevel,x,y,&xx,&yy);
  XtVaSetValues(dlgshell,XtNx,xx,XtNy,yy,NULL);
  XtPopup(dlgshell,XtGrabExclusive);
}
/********************************************************************************/
/* calls an xhchat to the selected display */
/* in the background with a fork           */

#ifdef DO_XHCHAT
void DoXhchat(d)
     char *d;
{
  int pid;
  if(pid = fork() , pid == 0){
    Xhchat(d,0,NULL, toplevel);
  }
  else if(pid<0)
    fprintf(stderr,"could not fork xhchat\n");
}
#endif
/********************************************************************************/
/* callback procedure             */
/* callback procedure for buttons */

void SelectMenu(w, client_data, call_data)
     Widget w;
     XtPointer client_data, call_data;
{
  Display *disp;
  XtAppContext context;
  int i=0;
  char outstr[255];
#ifdef DO_XHCHAT
  if((int)client_data == CHAT){
#ifdef XHCHAT_ALWAYS
    if(1){
#else
    if(UI[SelectedWidget].onConsole==True){
#endif
      context=XtCreateApplicationContext();
      if((disp = XtOpenDisplay(context,
			       UI[SelectedWidget].Display,
			       "xchat",
			       "Xchat",
			       (XrmOptionDescRec *)NULL, 0,
			       (Cardinal *)&i,NULL)) != NULL){
	XtCloseDisplay(disp);
	XtDestroyApplicationContext(context);
	DoXhchat(UI[SelectedWidget].Display);
	return;
      }
    }
  }
#endif
  if((int)client_data == USERDEF){
    sprintf(outstr,"%s %s&",UserDefinedProg,UI[SelectedWidget].TalkCmd);
    system(outstr);
    return;
  }
  /* default talk */
  sprintf(outstr,TALK_TERM_CMD,
	  TALK_WIDTH, TALK_HEIGHT,
	  UI[SelectedWidget].TalkCmd,
	  UI[SelectedWidget].TalkCmd,
	  UI[SelectedWidget].TalkCmd);
  system(outstr);
}

/********************************************************************************/
/* Draws a small arrow in the xhtalk label if child is running */

void UpdateLabel(w,client_data,event)
     Widget w;
     XtPointer client_data;
     XEvent *event;
{
  if((ActivityLight == True) && ChildIsRunning){
    XCopyArea (XtDisplay(w), activityPM, XtWindow(w), lineGC, 0,0,6,5,2,2);
  }
}
/********************************************************************************/
/* forces a redisplay of xhtalk label */

void Redisplay(w)
     Widget w;
{
  if(ActivityLight == True){
    if(!ChildIsRunning){
      XClearArea(XtDisplay(w), XtWindow(w), 2,2,6,5,True);
    }
    else
      XCopyArea (XtDisplay(w), activityPM, XtWindow(w), lineGC,
		 0, 0, 6, 5, 2, 2);
    do_events();
  }
}
  
/********************************************************************************/
/* recalculates the number of chars displayed in command widgets */

void SetNumChars(w,client_data,event)
     Widget w;
     XtPointer client_data;
     XEvent *event;
{
  Dimension topwidth;
  int i;
  int oldNumChars = NumChars;
  XtVaGetValues(toplevel,XtNwidth,&topwidth,NULL);
#if XtSpecificationRelease >= 5
  NumChars = (((int)topwidth -10 ) / FontWidth) -6;
#else
  NumChars = (((int)topwidth ) / FontWidth) -8;
#endif
  if(NumChars < MIN_CHARS) NumChars = MIN_CHARS;
  if(NumChars != oldNumChars)
    for(i=0;i<NumW;i++){
      XtVaSetValues(w_arr[i],XtNlabel,CreateLabelString(
							UI[i].TalkCmd,
							UI[i].onConsole,
							AddInfo,
							UI[i].Idle),NULL);
    }
}  

