
/* Sept, 17. 92                                   */
/* $Id: xhtalk.y,v 2.9 92/12/13 14:39:45 kdh Exp $
 * $Log:	xhtalk.y,v $
 * Revision 2.9  92/12/13  14:39:45  kdh
 * fixed some bugs (ReadConfigFile,Xhchat)
 * new options: idle-colors
 *              bell in xhchat
 *              automatic toplevel width (font width)
 *              dynamic column number
 *              activity light
 * 
 * Revision 2.8  92/12/10  12:23:09  kdh
 * some bug fixes made
 * 
 * Revision 2.8  92/11/16  10:20:04  kdh
 *  file hierarchy changed, new x-based talk, bug-fixes
 * 
 * Revision 2.7  92/10/23  14:07:52  kdh
 * display idle time in buttons
 * 
 * Revision 2.6  92/10/19  16:26:57  kdh
 * New function AddLabel (closes memory leak)
 * 
 * Revision 2.5  92/10/14  08:58:49  kdh
 * memory leak closed
 * 
 * Revision 2.4  92/10/07  11:58:56  kdh
 * replaced strdup->calloc/strcpy
 * wrong index in read_input_from_stdin() corrected
 * 
 * Revision 2.3  92/09/30  10:52:22  kdh
 * new finger method
 * 
 * Revision 2.2  92/09/30  10:51:36  kdh
 * fork error fixed
 * 
 * Revision 2.1  92/09/25  00:31:27  kdh
 * initial new version with selfmade finger
 * 
 */
/********************************************************************************/
/* main file of xhtalk
 * autor: Klaus Hartenstein                                                     */
/********************************************************************************/

/*
  
Copyright (C) 1992 Klaus Hartenstein

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted, provided
that the above copyright notice appear in all copies and that both that
copyright notice and this permission notice appear in supporting
documentation.  This software is provided "as is" without express or
implied warranty.

*/


/********************************************************************************/
/* yacc syntax-definition for config file */

%{
#include "xhtalk.h"
%}

%union
{
  char *sym;
}


%start sourcetext                         /* start symbol  */
  
%token <sym> STRING
%token HOST
%token NAME
  
%%
sourcetext: HOST '{' hostlist '}' NAME '{' namelist '}' 
          | NAME '{' namelist '}' HOST '{' hostlist '}' 
          ;

namelist  : /* empty */
          | STRING                {AppendList( &NamesList, $<sym>1, NULL, '\0',0, NULL);}
          | namelist ',' STRING   {AppendList( &NamesList, $<sym>3, NULL, '\0',0, NULL);}
          ;

hostlist  : /* empty */
          | STRING                {AppendList( &HostList, NULL, $<sym>1, '\0',0, NULL);}
          | hostlist ','  STRING  {AppendList( &HostList, NULL, $<sym>3, '\0',0, NULL);}
          ;
%%
/********************************************************************************/
/* scanner, created by 'lex scanner.l'  */
  
#include "scanner.c"

/********************************************************************************/
/* external functions */
  
static void DoFinger();
extern void FingerAllHosts();          /* fingerroutine in finger.c            */
extern void AppendList();              /* listfunctions in listfunc.c          */
extern void DeleteList();
extern int  IsNameInList();
extern List *SearchUser();
extern void PlaceInfoshell();          /* callbacks and actions in callbacks.c */
extern void PopupInfoshell();
extern void PopdownInfoshell();
extern void SelectDialog();
extern void PopupDlg();
extern void SelectMenu();
extern void CreatePixmaps();
extern void UpdateLabel();
extern void CreateGC();
extern void SetNumChars();
extern char *MyCalloc();
extern void *MyRealloc();
/********************************************************************************/
/* evaluate all events */

void do_events()
{
  XFlush(XtDisplay(toplevel));
  while(XtAppPending(app_con)){
    XtAppNextEvent(app_con,&event);
    XtDispatchEvent(&event);
  }
}
/********************************************************************************/
/* sync for xhchat-cildren */

void DoWaitChild(sig,code,scp,addr)
   int sig, code;
     struct sigcontext *scp;
     char *addr;  
{
  wait((int *)0);
  signal(SIGUSR2,DoWaitChild);
}
/********************************************************************************/
/* returns the tty or console from finger-line */

static int getty(str)
     char *str;
{
  if ((char *)strstr(str," co ") || (char*)strstr(str," con ") ||
      (char *)strstr(str,"*co ")) {
    return ON_CONSOLE;
  }
  else{
    return ON_TTY;
  }
}
/********************************************************************************/
/* hardly tries to find out the psition of the idle value in str */

static int GetIdlePos(str)
     char *str;
{
  int i;
  char *cp;                  /* i beg, the idle value is on the left of weekday */
  for(i=0;i<=6;i++){
    if((cp=(char *)strstr(str,WeekDays[i]))!=NULL)
      break;
  }
  if((cp == NULL)||((cp-str) < IDLE_LEN))
    return IDLE_POS;
  else
    return (cp-str-IDLE_LEN);
}
/********************************************************************************/
/* tries to find out idle time of line and returns minutes */

static int GetIdleTime(str)
     char *str;
{
  char *cp;
  char idle[255];
  int i;
  int i_pos = GetIdlePos(str);

  if(strlen(str)<IDLE_POS)
    return(MAX_IDLE);
  memset((char *)idle,0,256);
  strncpy(idle,&str[i_pos],IDLE_LEN);
  if((cp=(char *)index(idle,'d')) != NULL){
    *cp = '\0';
    return 1440*atoi(idle);
  }
  if((cp=(char *)index(idle,':')) != NULL){
    if(*(cp+1)==' '){
      *cp = '\0';
      return 60*atoi(idle);
    }
    else{
      i = atoi(cp+1);
      *cp = '\0';
      return i+(60*atoi(idle));
    }
  }
  else
    return atoi(idle);
}
/********************************************************************************/
/* analyse finger data from child and create list */

static void BuildList(str)
     char *str;
{
  char *cp = str;
  char *r, *s;
  char name[256];
  char tty;
  char host[256];
  char dummy[256];
  int dif, idle, len;
  
  DeleteList(&TmpList);   /* empty list */
  while((r = (char *)index(cp,'|')) != NULL){
    if((dif = r-cp)>256)
      dif=256;
    memset((char *)dummy,0,256);
    memset((char *)name,0,256);
    memset((char *)host,0,256);
    strncpy(dummy,cp,dif);
    s = (char *)index(dummy,'!');
    strncpy(host,dummy,s-&dummy[0]);
    s++;
    sscanf(s,"%s",name);
    tty = getty(s);
    idle = GetIdleTime(s);
    len = strlen(s);
    if(len>=3)
      s[len-3] = '\0';
    AppendList(&TmpList,name,host,tty,idle,s);
    cp += dif+1;
  }
}
/********************************************************************************/
/* converts minutes to a string like hh:mm */
static char *MinutesToStr(minutes)
     int minutes;
{
  char str[256];
  int days,hours,mins;
  hours=minutes / 60;
  mins=minutes - (hours * 60);
  days=hours / 24;
  if(days!=0)
    sprintf(str,"%dd",days);
  else
    if(minutes<=9)
    sprintf(str,"%d:0%d",hours,mins);
  else
    sprintf(str,"%d:%d",hours,mins);
  return str;
}
/********************************************************************************/
/* create label string */

char *CreateLabelString(labelStr,cons,AddInfo,idle)
     Boolean AddInfo;
     char *labelStr;
     Boolean cons;
     int idle;
{
  char s[1024];
  int i,len=strlen(labelStr);
  if(DisplayIdle == True){
    for(i=0;(i < NumChars) && (i < 256) ; i++){
      if(i<len)
	s[i]=labelStr[i];
      else
	s[i]=' ';
    }
    s[NumChars]='\0';
    sprintf(s,"%s %s",s,MinutesToStr(idle));
  }
  else
    strcpy(s,labelStr);
#if XtSpecificationRelease < 5
  if((AddInfo==True) && (ShowTty == True))
    if(cons==True)
      sprintf(str,"%s %s",">",s);
    else
      sprintf(str,"%s %s"," ",s);
  else
    strcpy(str,labelStr);
#else
  sprintf(str,"%s",s);
#endif
  return str;
}
/********************************************************************************/
/* create left bitmap if X11R5 */

static void CreateLeftBitmap(w,cons,AddInfo)           
     Widget w;
     Boolean cons,AddInfo;
{
#if XtSpecificationRelease >= 5
  if((AddInfo==True) && (ShowTty == True))
    if(cons==True)
      XtVaSetValues(w,XtNleftBitmap,l_cons_PM,NULL);
    else
      XtVaSetValues(w,XtNleftBitmap,l_tty_PM,NULL);
#endif
}
/********************************************************************************/
/* create a new button widget */

static void CreateWidget(labelStr,cons,AddInfo,number)   
     Boolean AddInfo;
     char *labelStr;
     Boolean cons;
     int number;
{
  w_arr[number]=XtVaCreateWidget("",menuButtonWidgetClass,
			     box,
			     XtNborderWidth,2,
			     XtNjustify,XtJustifyLeft,
			     XtNfont,app_data.cmdFont,
			     XtNcornerRoundPercent,(Dimension)number, /* store number */
			     XtNmin,FontHeight,XtNmax,FontHeight,
			     XtNhighlightThickness,1,NULL);
  /*XtAddCallback(w_arr[number],XtNcallback,Select,(XtPointer)number);*/
  XtUninstallTranslations(w_arr[number]);
  XtOverrideTranslations(w_arr[number],TRANS(mb_trans));
}
/********************************************************************************/
/* create a button label */

static void AddLabel(labelStr,cons,AddInfo,number,idle, host, fili)        
     Boolean AddInfo;
     char *labelStr;
     Boolean cons;
     int number;
     int idle;
     char *host;
     char *fili;
{
  if(number>=MaxWidgets){          /* only create new widget if none available*/
    CreateWidget(labelStr,cons,AddInfo,number);
    MaxWidgets++;
  }
                                                  /* change label of widget      */
  XtVaSetValues(w_arr[number],
		XtNlabel, CreateLabelString(labelStr,cons,AddInfo,idle),NULL);
  CreateLeftBitmap(w_arr[number],cons,AddInfo);
  
  if(XtIsManaged(w_arr[number])!=True)
    XtManageChild(w_arr[number]);
  UI[number].Idle = idle;
  UI[number].TalkCmd=(char *)MyCalloc(1,strlen(labelStr)+1);    /* set user info     */
  strcpy(UI[number].TalkCmd,labelStr);
  UI[number].Display=(char *)MyCalloc(1,strlen(labelStr)+3);    /* set user info     */
  sprintf(UI[number].Display,"%s:0",host);
  UI[number].onConsole=cons;
  UI[number].FingerLine=(char *)MyCalloc(1,strlen(fili)+3);    /* set user info     */
  strcpy(UI[number].FingerLine,fili);
  if(strlen(UI[number].FingerLine)>=30){
    UI[number].FingerLine[8]='\n';
    UI[number].FingerLine[30]='\n';
  }
  if(strlen(UI[number].FingerLine)>=48)
    UI[number].FingerLine[48]='\n';
  SetColor(w_arr[number],idle,UseColor);
}
/********************************************************************************/
/* unmanage all unused buttons */

static void UnmanageUnused(number)
     int number;
{
  int i;
  for(i=number;i<MaxWidgets;i++)
    if(XtIsManaged(w_arr[i])==True) XtUnmanageChild(w_arr[i]);
}
/********************************************************************************/
/* cleans up UserInfo-array */

static void CleanUpUserInfo()
{
  int i;
  for(i=0;i<NumW;i++){
    XtFree(UI[i].TalkCmd);
    UI[i].TalkCmd=NULL;
    XtFree(UI[i].Display);
    UI[i].Display=NULL;
    UI[i].onConsole=False;
    XtFree(UI[i].FingerLine);
    UI[i].FingerLine=NULL;
  }
}
/********************************************************************************/
/* create buttons from finger data */

static void CreateWidgets()
{
  List *dummy=NULL;
  List *dummy2=NULL;
  List *names=NamesList;
  char str[255];
  short Mark=0;
  int AtConsole=0;
  int i=0;
  
  NumW=0;
  CleanUpUserInfo();
  for(;names;names=names->next){                       
    dummy=NULL;
    Mark=0;
    if(AllConsoles == True){                               /* list all consoles */
      dummy=TmpList;
      for(;dummy;dummy=dummy->next){
	if(!strcmp(names->Name, dummy->Name) &&
	   (dummy->tty == ON_CONSOLE) &&
	   ((dummy->idle <= Idle)||(HideWhenIdle==False))){
	  sprintf(str,"%s@%s", dummy->Name, dummy->Host);
	  AddLabel(str, True, AddInfo, NumW, dummy->idle,
		   dummy->Host, dummy->FiLi);
	  Mark++;
	  NumW++;
	}
      }
    }
    else{                                               /* list one console with */
      if(((dummy2=SearchUser(TmpList,                   /* smallest idle time    */
			     names->Name,
			     ON_CONSOLE,
			     Idle,
			     HideWhenIdle))!=NULL)&&
	 Mark==0){
	sprintf(str,"%s@%s",dummy2->Name,dummy2->Host);
	AddLabel(str,True,AddInfo,NumW,dummy2->idle,dummy2->Host,dummy2->FiLi);
	NumW++;
	Mark++;
      }
    }
    if((ShowTty==True) &&                               /* list tty, if no      */
       (Mark==0)){                                      /* console found        */
      if(((dummy2=SearchUser(TmpList,
			     names->Name,
			     ON_TTY,
			     Idle,
			     HideWhenIdle))!=NULL)&&
	 Mark==0){
	sprintf(&str[0],"%s@%s",dummy2->Name,dummy2->Host);
	AddLabel(str,False,AddInfo,NumW,dummy2->idle,
		 dummy2->Host,dummy2->FiLi);
	NumW++;
	Mark++;
      }
    }
  }
  UnmanageUnused(NumW);
}
/********************************************************************************/

static void ResizeTopLevel()
{
  Dimension height = (Dimension)(NumW * (FontHeight+1) + xh_height+4);
  unsigned int r_height;
  int x,y;
  unsigned int w,bw,dep;
  Window win;
  XtVaSetValues(box,XtNheight,height,NULL);
  do_events(); 
#ifdef CORRECT_SHELL_HEIGHT
  XGetGeometry(XtDisplay(box),XtWindow(box),&win,&x,&y,&w,&r_height,&bw,&dep);
  if(height != r_height)
    XtVaSetValues(box,XtNheight,(Dimension)(height-(r_height-height)),NULL);
  do_events(); 
#endif
}
/********************************************************************************/
/* looks at all hosts for users */

static void StartFinger()
{
  int
    to_child[2],   /* pipe descr. from parent->child */
    to_parent[2];  /* pipe descr. from child->parent */
  int
    pid,i;
  i=pipe(to_child);
  i=pipe(to_parent);
  if(pid = fork() , pid == 0){    /* child process */
/*    close(fileno(stdin)); 
    dup(to_child[0]);*/
    close(fileno(stdout));
    dup(to_parent[1]);
    close(to_child[0]);
    close(to_child[1]);
    close(to_parent[0]);
    close(to_parent[1]);
    FingerAllHosts();
  }
  else if(pid > 0){              /* parent process      */
    ChildID        = pid;        /* set global variable */
    ChildIsRunning = True;
    Redisplay(lbl);
    close(fileno(stdin)); 
    dup(to_parent[0]);
/*    close(fileno(stdout));
    dup(to_child[1]);
    setbuf(stdout,NULL);*/
    close(to_child[0]);
    close(to_child[1]);
    close(to_parent[0]);
    close(to_parent[1]);
  }
  else{
    fprintf(stderr,"coudln't fork process\n");
    exit(1);
  }
}
/********************************************************************************/
/* starts Requesting hosts, if child process is not running */

static void DoFinger()
{
  if(ChildIsRunning == False){
    StartFinger();                                     /* finger all hosts         */
    XtAppAddTimeOut(app_con,AskTime,DoFinger,NULL); /* start new timer          */
  }
  else                                              /* set flag to start finger */
    WaitForChild = True;                            /* after end of child proc  */
}
/********************************************************************************/
/* read all finger data from child-process */

static void read_input_from_stdin(sig,code,scp,addr)
   int sig, code;
     struct sigcontext *scp;
     char *addr;  
{
  char buf[1025];
  int nbytes;
  char tty[256];
  char host[256];
  static char *str;
  static int len=0;
  static char *cp;
  
  ChildIsRunning = False;
  while((nbytes = read(fileno(stdin),buf,1024)) != 0){
    if(nbytes){
      buf[nbytes]='\0';
      len+=nbytes+2;
      if(str != NULL){
	str = (char *)MyRealloc(str,len+2);
	str = (char *)strcat(str, buf);
      }
      else{
	str = (char *)MyCalloc(1,strlen(buf)+2);
	strcpy(str,buf);
      }
      if((cp = (char *)strstr(buf,ENDSYMBOL)) != NULL){
	wait((int *) 0);                       /* wait for child process */
	cp = (char *)strstr(str,ENDSYMBOL);
	*cp = '\0';
	BuildList(str);
	CreateWidgets();
	ResizeTopLevel();
	DeleteList(&TmpList);   /* empty list */
	len=0;
	XtFree(str);
	str=NULL;
      }
    }
  }
  signal(SIGUSR1,read_input_from_stdin); /* needed on hp's */
  if(WaitForChild == True){     /* if update interval is to short, wait for */
    WaitForChild = False;      /* end of child process                     */
    DoFinger();
  }
  XtFree(str);
  Redisplay(lbl);
}

/********************************************************************************/
/* prints usage of cmdline options and config file syntax */

static void PrintUsage()
{
  printf("\nusage: %s [toolkitoptions ...] [options ...]\n\n",ProgName);
  printf(" options:\n");
  printf(" --------\n");
  printf(" -f        <filename>  configuration file\n");
  printf(" -update    <minutes>  update interval in minutes ( >= 1 )\n");
  printf(" -idle      <minutes>  idle time for users (0 min: off)\n");
  printf(" -timeout   <seconds>  timeout value for connect/request\n");
  printf(" -prog      <program>  user defined program or shellscript\n");
  printf(" -all                  list all consoles\n");
  printf(" -debug                print finger messages\n");
  printf(" +tty                  turn tty mode on          (default)\n");
  printf(" -tty                  turn tty mode off\n");
  printf(" -info                 don't indicate consoles\n");
  printf(" +info                 indicate consoles         (default)\n");
  printf(" +dIdle                show idle times           (default)\n");
  printf(" -dIdle                don't show idle times\n");
  printf(" -dLight               turn off activity light\n");
  printf(" +dLight               turn on activity light    (default)\n");
  printf(" +color                turn on idle-colors       (default)\n");
  printf(" -color                turn off idle-colors\n");
  printf(" -idleOneCol   <colr>  color for 0 - 1/3   idle  (default: grey90)\n");        
  printf(" -idleTwoCol   <colr>  color for 1/3 - 2/3 idle  (default: grey80)\n");
  printf(" -idleThreeCol <colr>  color for 2/3 -     idle  (default: white)\n");
  printf(" -buttonFont   <font>  font of user-buttons\n");    
  printf(" -h | -help            print this message\n\n");
}
/********************************************************************************/
/* get commandline opts and set variables */

static void GetOptions(argc, argv, app_data)
     int argc;
     char **argv;
     AppData app_data;
{
  AskTime        = app_data.Ask_Interval*60000;            /* minutes -> msec */
  ShowTty        = app_data.tty;
  AddInfo        = app_data.Info;
  TimeOut        = app_data.Timeout;
  DisplayIdle    = app_data.dIdle;
  AllConsoles    = app_data.listall;
  ActivityLight  = app_data.light;
  HomeDir        = (char *)MyCalloc(1,strlen((char *)getenv("HOME"))+2);
  strcpy(HomeDir,(char *)getenv("HOME"));
  ProgName       = (char *)MyCalloc(1,strlen(argv[0])+2);
  strcpy(ProgName,argv[0]);
  Idle           = app_data.Idle;
  UseColor       = app_data.useColor;
  IdleColors.idleOne   = app_data.idleOneC;
  IdleColors.idleTwo   = app_data.idleTwoC;
  IdleColors.idleThree = app_data.idleThreeC;
  if(Idle<=0)
    HideWhenIdle=False;
  else
    HideWhenIdle = True;
  Debug          = app_data.Debug;
  HostList       = NULL;
  NamesList      = NULL;
  TmpList        = NULL;                    
  NumW           = 0;                                       /* # of cmd widgets */
  ChildIsRunning = False;
  WaitForChild   = False;
  NumChars       = NUM_CHARS;

  if(app_data.Help == True){                                 /* xhtalk -h(elp)  */
    PrintUsage();
    exit(2);
  }
  if(app_data.Ask_Interval < 1) {
    Error("ask-interval to low");
    exit(2);
  }
  if(app_data.Timeout <= 1) {
    Error("timeout to low. (try 10 secs)");
    exit(2);
  }
  if(app_data.prog == NULL)
    UserDefinedProg = NULL;
  else{
    UserDefinedProg = (char *)MyCalloc(1,strlen(app_data.prog)+2);
    strcpy(UserDefinedProg,app_data.prog);
  }
  if(app_data.Config_File_Name == NULL){
    ConfigFile   = (char *)MyCalloc(1,strlen(CNFG_FILE)+strlen(HomeDir)+2);
    sprintf(ConfigFile,"%s/%s",HomeDir,CNFG_FILE); /* full pathname */
  }
  else{
    if(*(app_data.Config_File_Name) == '~') {      /* looks like relative pathname ..*/
      Error("full pathname required for config file");
      exit(2);
    }
    ConfigFile = (char *)MyCalloc(1,strlen(app_data.Config_File_Name)+2);
    strcpy(ConfigFile,app_data.Config_File_Name);
  }
}
/********************************************************************************/
static void SetFontHeight()
{
  XFontStruct *FontS=app_data.cmdFont;
  Dimension bw;
  FontHeight = FontS->max_bounds.ascent +  FontS->max_bounds.descent +2 ;
  FontWidth  = FontS->max_bounds.width;
  XtVaGetValues(toplevel,XtNheight,&bw,NULL);
  HeightOfLabel = (int)bw;
  NumW = 0;
}
/********************************************************************************/
static void EvalToplevelWidth(toplabel)
     Widget toplabel;
{
#if XtSpecificationRelease >= 5
  XtVaSetValues(toplabel,XtNwidth,((NumChars+6) * FontWidth)+10,NULL);
#else
  XtVaSetValues(toplabel,XtNwidth,((NumChars+8) * FontWidth)+3,NULL);
#endif  
}
/********************************************************************************/
/* open, read, parse config file */

static void ReadConfigFile()
{
  if((yyin = fopen(ConfigFile,"r")) != NULL){
    yyparse();
    fclose(yyin);
  }
  else{
    char buffer[1024];
    sprintf(buffer, "Can't find config file: %s", ConfigFile);
    Error(buffer);
    exit(2);
  }
}
/********************************************************************************/
int yyerror(s)
     char s;
{
  fprintf(stderr,"syntax error in file %s near line: %i",ConfigFile, posix_yylineno);
  PrintUsage();
  exit(2);
}
/********************************************************************************/
/* .. */

main( argc, argv )
     int argc;
     char **argv;
{
  Pixel fg,bg;
  char LabelString[255];
  aargc=argc;
  aargv=argv;
  toplevel = XtAppInitialize(&app_con, "xhtalk",
			     options, XtNumber(options),
			     (Cardinal *) &argc, argv,
			     fallback_resources,
			     NULL, 0);
  XtGetApplicationResources(toplevel,
			    (XtPointer)&app_data,
			    resources,
			    XtNumber(resources),
			    NULL,0);

  GetOptions(argc, argv, app_data);                         /* cmdline opts...*/

  ReadConfigFile();
  
  CreatePixmaps();
  
  box     =XtVaCreateManagedWidget( "xxx",
				   panedWidgetClass,
				   toplevel,
				   XtNwidth,120,
				   NULL);
  lbl     =XtVaCreateManagedWidget("boxw",
				   commandWidgetClass,
				   box,
				   XtNborderWidth,0,
				   XtNmin,14,XtNmax,14,
				   XtNforeground,WhitePixelOfScreen(XtScreen(toplevel)),
				   XtNbackground,BlackPixelOfScreen(XtScreen(toplevel)),
				   NULL);
  if(ActivityLight == True){
    CreateGC(lbl);
    XtAddEventHandler(lbl,VisibilityChangeMask|ExposureMask,False,UpdateLabel,NULL);
  }
  XtVaSetValues(lbl,XtNbitmap,LabelPM,NULL);
  XtVaSetValues(toplevel,XtNiconPixmap,IconPM,NULL);

  dlgshell=     XtCreatePopupShell("menu",
				   transientShellWidgetClass,
				   toplevel,
				   NULL,0);
  infosh  =     XtCreatePopupShell("infosh",
				   overrideShellWidgetClass,
				   toplevel,
				   NULL,0);
  FiLiW   = XtVaCreateManagedWidget("No info",labelWidgetClass,
				    infosh,
				    XtNfont,app_data.cmdFont,
				    NULL);
  selectsh=     XtCreatePopupShell("selectsh",
				   overrideShellWidgetClass,
				   toplevel,
				   NULL, 0);
  XtUninstallTranslations(selectsh);
  XtOverrideTranslations(selectsh,TRANS(msh_trans));

  pnd=      XtVaCreateManagedWidget("paned", panedWidgetClass,
				    selectsh,
				    NULL);
  talkW=    XtVaCreateManagedWidget("    talk    ", commandWidgetClass,
				    pnd,
				    XtNfont,app_data.cmdFont,
				    XtNborderWidth,1,
				    NULL);
  XtUninstallTranslations(talkW);
  XtOverrideTranslations(talkW,TRANS(cmd_trans));
  XtAddCallback(talkW, XtNcallback, SelectMenu, (XtPointer)TALK);
  chatW=    XtVaCreateManagedWidget("xhchat",commandWidgetClass,
				    pnd,
				    XtNfont,app_data.cmdFont,
				    XtNborderWidth,1,
				    NULL);
  XtUninstallTranslations(chatW);
  XtOverrideTranslations(chatW,TRANS(cmd_trans));
  XtAddCallback(chatW, XtNcallback, SelectMenu, (XtPointer)CHAT);
  if(UserDefinedProg != NULL){
    userW=    XtVaCreateManagedWidget("userdef.",commandWidgetClass,
				      pnd,
				      XtNfont,app_data.cmdFont,
				      XtNborderWidth,1,
				      NULL);
    XtUninstallTranslations(userW);
    XtOverrideTranslations(userW,TRANS(cmd_trans));
    XtAddCallback(userW, XtNcallback, SelectMenu, (XtPointer)USERDEF);
  }
  sprintf(LabelString,INFOSTRING,
	  AskTime/60000,
	  ConfigFile,
	  ShowTty,
	  AddInfo,
	  TimeOut,
	  Idle,
	  DisplayIdle,
	  ActivityLight,
	  UseColor,
	  (UserDefinedProg ? UserDefinedProg : "none")
	  );
  
  dlg    = XtVaCreateManagedWidget("Info",
				   dialogWidgetClass,
				   dlgshell,
				   XtNlabel,LabelString,
				   NULL);
  XawDialogAddButton(dlg,"Quit",SelectDialog,(XtPointer)QUIT);
  XawDialogAddButton(dlg,"cancel",SelectDialog,(XtPointer)CANCEL);
  XtAddCallback(lbl, XtNcallback,PopupDlg,NULL);

  SetFontHeight();
  EvalToplevelWidth(box);
  XtAddEventHandler(box, ResizeRequest, False, SetNumChars, NULL);

  XtRealizeWidget(toplevel);
  SetNumChars(toplevel,NULL,NULL);

  signal(SIGUSR1,read_input_from_stdin);
  signal(SIGUSR2,DoWaitChild);
  DoFinger();
  
  XtAppAddActions(app_con, menu_actions, XtNumber(menu_actions));
		  
  for(;;){
    XtAppNextEvent(app_con,&event);
    XtDispatchEvent(&event);
  }
}

