static char SCCSID[] = "@(#)complex1.c	1.1 89/02/08";
/*
 * Copyright 1989 Siemens
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Siemens not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission.  Siemens makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * Author:  Claus Gittinger, Siemens Munich, unido!sinix!claus@uunet.uu.net
 */

#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>

#include "externals.h"

static GC drawWhite, drawBlack;

/*
 * complex benchmark
 *
 * gives an idea of xterm, xedit ... windows
 *
 * creates subwindow,
 * draw text, fill rectangle, scrolls,
 * destroys window
 */
complex1_setup(dpy, win, dummy)
Display *dpy;
Window win;
{
	return 0;
}

complex1_cleanup(dpy, win, dummy)
Display *dpy;
Window win;
{
}

complex1_bench(dpy, win, dummy)
Display *dpy;
Window win;
{
	int screen = DefaultScreen(dpy);
	int black = BlackPixel(dpy, screen);
	int white = WhitePixel(dpy, screen);
	Window subwin;
	GC subGC;
	int ncomplex = 0;

	while (benchRunning) {
	    subwin = XCreateSimpleWindow(dpy, win, 0, 0, 400, 200, 1, white, black);
	    XMapWindow(dpy, subwin);
	    subGC = XCreateGC(dpy, subwin, 0L, NULL);
	    XClearArea(dpy, subwin, 0, 90, 400, 20, False);
	    XDrawImageString(dpy, subwin, subGC, 0, 100, "hello", 5);
	    XCopyArea(dpy, subwin, subwin, subGC, 0, 10, 400, 190, 0, 0);
	    XSync(dpy, 0);
	    XDestroyWindow(dpy, subwin);
	    ncomplex++;
	}
	return ncomplex;
}

complex1_msg(deltaT, nrun, dummy, rate)
double rate;
{
	printf("WINDOW CREATE/DRAW/DESTROY\n");
	printf("\n");
	printf("%d runs %d secs\n", nrun, deltaT);
	printf("rate = %8.2f runs/sec\n", rate);
}
