typedef int  (*FUNCPTR)();
#define NOFUNC  ((FUNCPTR)0)

extern hline_setup(), hline_bench(), hline_cleanup(), hline_msg();
extern vline_setup(), vline_bench(), vline_cleanup(), vline_msg();
extern sline_setup(), sline_bench(), sline_cleanup(), sline_msg();
extern line_setup(), line_bench(), line_cleanup(), line_msg();
extern dline_setup(), dline_bench(), dline_cleanup(), dline_msg();
extern wline_setup(), wline_bench(), wline_cleanup(), wline_msg();
extern rects_setup(), rects_bench(), rects_cleanup(), rects_msg();
extern arcs_setup(), arcs_bench(), arcs_cleanup(), arcs_msg();
extern filledarcs_setup(), filledarcs_bench(), filledarcs_cleanup(), filledarcs_msg();
extern filledpoly_setup(), filledpoly_bench(), filledpoly_cleanup(), filledpoly_msg();
extern fillrects_setup(), fillrects_bench(), fillrects_cleanup(), fillrects_msg();
extern tiledrects_setup(), tiledrects_bench(), tiledrects_cleanup(), tiledrects_msg();
extern stippledrects_setup(), stippledrects_bench(), stippledrects_cleanup(), stippledrects_msg();
extern invrects_setup(), invrects_bench(), invrects_cleanup(), invrects_msg();
extern imagestring_setup(), imagestring_bench(), imagestring_cleanup(), imagestring_msg();
extern screencopy_setup(), screencopy_bench(), screencopy_cleanup(), screencopy_msg();
extern scroll_setup(), scroll_bench(), scroll_cleanup(), scroll_msg();
extern pixmapcopy_setup(), pixmapcopy_bench(), pixmapcopy_cleanup(), pixmapcopy_msg();
extern bitmapcopy_setup(), bitmapcopy_bench(), bitmapcopy_cleanup(), bitmapcopy_msg();
extern complex1_setup(), complex1_bench(), complex1_cleanup(), complex1_msg();

struct benchFunctionDescription {
    char        *name;          /* name of bench */
    int         level;          /* its level */
    FUNCPTR     setupFunc;      /* functions to do it ... */
    FUNCPTR     benchFunc;
    FUNCPTR     cleanupFunc;
    FUNCPTR     messageFunc;
    unsigned    benchArg;       /* argument to function */
} benchList[] = {
/*      name            level  functions */

    {   "line2",            2, line_setup, line_bench, line_cleanup, line_msg,   2 },
    {   "line10",           1, line_setup, line_bench, line_cleanup, line_msg,  10 },
    {   "line100",          1, line_setup, line_bench, line_cleanup, line_msg, 100 },
    {   "line400",          1, line_setup, line_bench, line_cleanup, line_msg, 400 },
    {   "line500",          2, line_setup, line_bench, line_cleanup, line_msg, 500 },

    {   "hline2",           3, hline_setup, hline_bench, hline_cleanup, hline_msg,   2 },
    {   "hline10",          2, hline_setup, hline_bench, hline_cleanup, hline_msg,  10 },
    {   "hline50",          4, hline_setup, hline_bench, hline_cleanup, hline_msg,  50 },
    {   "hline100",         2, hline_setup, hline_bench, hline_cleanup, hline_msg, 100 },
    {   "hline200",         4, hline_setup, hline_bench, hline_cleanup, hline_msg, 200 },
    {   "hline300",         4, hline_setup, hline_bench, hline_cleanup, hline_msg, 300 },
    {   "hline400",         2, hline_setup, hline_bench, hline_cleanup, hline_msg, 400 },
    {   "hline500",         3, hline_setup, hline_bench, hline_cleanup, hline_msg, 500 },
    {   "hline600",         4, hline_setup, hline_bench, hline_cleanup, hline_msg, 600 },
    {   "hline700",         4, hline_setup, hline_bench, hline_cleanup, hline_msg, 700 },
    {   "hline800",         4, hline_setup, hline_bench, hline_cleanup, hline_msg, 800 },

    {   "vline2",           3, vline_setup, vline_bench, vline_cleanup, vline_msg,   2 },
    {   "vline10",          2, vline_setup, vline_bench, vline_cleanup, vline_msg,  10 },
    {   "vline50",          4, vline_setup, vline_bench, vline_cleanup, vline_msg,  50 },
    {   "vline100",         2, vline_setup, vline_bench, vline_cleanup, vline_msg, 100 },
    {   "vline200",         4, vline_setup, vline_bench, vline_cleanup, vline_msg, 200 },
    {   "vline300",         4, vline_setup, vline_bench, vline_cleanup, vline_msg, 300 },
    {   "vline400",         2, vline_setup, vline_bench, vline_cleanup, vline_msg, 400 },
    {   "vline500",         3, vline_setup, vline_bench, vline_cleanup, vline_msg, 500 },
    {   "vline600",         4, vline_setup, vline_bench, vline_cleanup, vline_msg, 600 },
    {   "vline700",         4, vline_setup, vline_bench, vline_cleanup, vline_msg, 700 },
    {   "vline800",         4, vline_setup, vline_bench, vline_cleanup, vline_msg, 800 },

    {   "sline2",           3, sline_setup, sline_bench, sline_cleanup, sline_msg,   2 },
    {   "sline10",          2, sline_setup, sline_bench, sline_cleanup, sline_msg,  10 },
    {   "sline100",         2, sline_setup, sline_bench, sline_cleanup, sline_msg, 100 },
    {   "sline400",         2, sline_setup, sline_bench, sline_cleanup, sline_msg, 400 },
    {   "sline500",         3, sline_setup, sline_bench, sline_cleanup, sline_msg, 500 },

    {   "dline2",           2, dline_setup, dline_bench, dline_cleanup, dline_msg,   2 },
    {   "dline10",          1, dline_setup, dline_bench, dline_cleanup, dline_msg,  10 },
    {   "dline100",         1, dline_setup, dline_bench, dline_cleanup, dline_msg, 100 },
    {   "dline400",         1, dline_setup, dline_bench, dline_cleanup, dline_msg, 400 },
    {   "dline500",         2, dline_setup, dline_bench, dline_cleanup, dline_msg, 500 },

    {   "wline2",           2, wline_setup, wline_bench, wline_cleanup, wline_msg,   2 },
    {   "wline10",          1, wline_setup, wline_bench, wline_cleanup, wline_msg,  10 },
    {   "wline100",         1, wline_setup, wline_bench, wline_cleanup, wline_msg, 100 },
    {   "wline400",         1, wline_setup, wline_bench, wline_cleanup, wline_msg, 400 },
    {   "wline500",         2, wline_setup, wline_bench, wline_cleanup, wline_msg, 500 },

    {   "rects2",           2, rects_setup, rects_bench, rects_cleanup, rects_msg,   2 },
    {   "rects10",          1, rects_setup, rects_bench, rects_cleanup, rects_msg,  10 },
    {   "rects100",         1, rects_setup, rects_bench, rects_cleanup, rects_msg, 100 },
    {   "rects400",         1, rects_setup, rects_bench, rects_cleanup, rects_msg, 400 },
    {   "rects500",         2, rects_setup, rects_bench, rects_cleanup, rects_msg, 500 },

    {   "fillrects2",       2, fillrects_setup, fillrects_bench, fillrects_cleanup, fillrects_msg,   2 },
    {   "fillrects10",      1, fillrects_setup, fillrects_bench, fillrects_cleanup, fillrects_msg,  10 },
    {   "fillrects100",     1, fillrects_setup, fillrects_bench, fillrects_cleanup, fillrects_msg, 100 },
    {   "fillrects400",     1, fillrects_setup, fillrects_bench, fillrects_cleanup, fillrects_msg, 400 },
    {   "fillrects500",     2, fillrects_setup, fillrects_bench, fillrects_cleanup, fillrects_msg, 500 },

    {   "tiledrects2",      2, tiledrects_setup, tiledrects_bench, tiledrects_cleanup, tiledrects_msg,   2 },
    {   "tiledrects10",     1, tiledrects_setup, tiledrects_bench, tiledrects_cleanup, tiledrects_msg,  10 },
    {   "tiledrects100",    1, tiledrects_setup, tiledrects_bench, tiledrects_cleanup, tiledrects_msg, 100 },
    {   "tiledrects400",    1, tiledrects_setup, tiledrects_bench, tiledrects_cleanup, tiledrects_msg, 400 },
    {   "tiledrects500",    2, tiledrects_setup, tiledrects_bench, tiledrects_cleanup, tiledrects_msg, 500 },

    {   "stippledrects2",   2, stippledrects_setup, stippledrects_bench, stippledrects_cleanup, stippledrects_msg,   2 },
    {   "stippledrects10",  1, stippledrects_setup, stippledrects_bench, stippledrects_cleanup, stippledrects_msg,  10 },
    {   "stippledrects100", 1, stippledrects_setup, stippledrects_bench, stippledrects_cleanup, stippledrects_msg, 100 },
    {   "stippledrects400", 1, stippledrects_setup, stippledrects_bench, stippledrects_cleanup, stippledrects_msg, 400 },
    {   "stippledrects500", 2, stippledrects_setup, stippledrects_bench, stippledrects_cleanup, stippledrects_msg, 500 },

    {   "invrects2",        2, invrects_setup, invrects_bench, invrects_cleanup, invrects_msg,   2 },
    {   "invrects10",       1, invrects_setup, invrects_bench, invrects_cleanup, invrects_msg,  10 },
    {   "invrects100",      1, invrects_setup, invrects_bench, invrects_cleanup, invrects_msg, 100 },
    {   "invrects400",      1, invrects_setup, invrects_bench, invrects_cleanup, invrects_msg, 400 },
    {   "invrects500",      2, invrects_setup, invrects_bench, invrects_cleanup, invrects_msg, 500 },

    {   "arcs2",            2, arcs_setup, arcs_bench, arcs_cleanup, arcs_msg,   2 },
    {   "arcs10",           1, arcs_setup, arcs_bench, arcs_cleanup, arcs_msg,  10 },
    {   "arcs100",          1, arcs_setup, arcs_bench, arcs_cleanup, arcs_msg, 100 },
    {   "arcs400",          1, arcs_setup, arcs_bench, arcs_cleanup, arcs_msg, 400 },
    {   "arcs500",          2, arcs_setup, arcs_bench, arcs_cleanup, arcs_msg, 500 },

    {   "filledarcs2",      2, filledarcs_setup, filledarcs_bench, filledarcs_cleanup, filledarcs_msg,   2 },
    {   "filledarcs10",     1, filledarcs_setup, filledarcs_bench, filledarcs_cleanup, filledarcs_msg,  10 },
    {   "filledarcs100",    1, filledarcs_setup, filledarcs_bench, filledarcs_cleanup, filledarcs_msg, 100 },
    {   "filledarcs400",    1, filledarcs_setup, filledarcs_bench, filledarcs_cleanup, filledarcs_msg, 400 },
    {   "filledarcs500",    2, filledarcs_setup, filledarcs_bench, filledarcs_cleanup, filledarcs_msg, 500 },

    {   "filledpoly10",     2, filledpoly_setup, filledpoly_bench, filledpoly_cleanup, filledpoly_msg,  10 },
    {   "filledpoly100",    1, filledpoly_setup, filledpoly_bench, filledpoly_cleanup, filledpoly_msg, 100 },

    {   "screencopy2",      2, screencopy_setup, screencopy_bench, screencopy_cleanup, screencopy_msg,   2 },
    {   "screencopy10",     1, screencopy_setup, screencopy_bench, screencopy_cleanup, screencopy_msg,  10 },
    {   "screencopy100",    1, screencopy_setup, screencopy_bench, screencopy_cleanup, screencopy_msg, 100 },
    {   "screencopy400",    1, screencopy_setup, screencopy_bench, screencopy_cleanup, screencopy_msg, 400 },
    {   "screencopy500",    2, screencopy_setup, screencopy_bench, screencopy_cleanup, screencopy_msg, 500 },

    {   "scroll",           1, scroll_setup, scroll_bench, scroll_cleanup, scroll_msg, 16 },

    {   "pixmapcopy2",      3, pixmapcopy_setup, pixmapcopy_bench, pixmapcopy_cleanup, pixmapcopy_msg,   2 },
    {   "pixmapcopy10",     2, pixmapcopy_setup, pixmapcopy_bench, pixmapcopy_cleanup, pixmapcopy_msg,  10 },
    {   "pixmapcopy100",    2, pixmapcopy_setup, pixmapcopy_bench, pixmapcopy_cleanup, pixmapcopy_msg, 100 },
    {   "pixmapcopy400",    2, pixmapcopy_setup, pixmapcopy_bench, pixmapcopy_cleanup, pixmapcopy_msg, 400 },
    {   "pixmapcopy500",    3, pixmapcopy_setup, pixmapcopy_bench, pixmapcopy_cleanup, pixmapcopy_msg, 500 },

    {   "bitmapcopy2",      2, bitmapcopy_setup, bitmapcopy_bench, bitmapcopy_cleanup, bitmapcopy_msg,   2 },
    {   "bitmapcopy10",     1, bitmapcopy_setup, bitmapcopy_bench, bitmapcopy_cleanup, bitmapcopy_msg,  10 },
    {   "bitmapcopy100",    1, bitmapcopy_setup, bitmapcopy_bench, bitmapcopy_cleanup, bitmapcopy_msg, 100 },
    {   "bitmapcopy400",    1, bitmapcopy_setup, bitmapcopy_bench, bitmapcopy_cleanup, bitmapcopy_msg, 400 },
    {   "bitmapcopy500",    2, bitmapcopy_setup, bitmapcopy_bench, bitmapcopy_cleanup, bitmapcopy_msg, 500 },

    {   "imagestring:fixed",1, imagestring_setup, imagestring_bench, imagestring_cleanup, imagestring_msg, (unsigned)"fixed" },
    {   "imagestring:6x12", 2, imagestring_setup, imagestring_bench, imagestring_cleanup, imagestring_msg, (unsigned)"6x12" },
    {   "imagestring:8x13", 2, imagestring_setup, imagestring_bench, imagestring_cleanup, imagestring_msg, (unsigned)"8x13" },
    {   "imagestring:9x15", 2, imagestring_setup, imagestring_bench, imagestring_cleanup, imagestring_msg, (unsigned)"9x15" },

    {   "complex1",         1, complex1_setup, complex1_bench, complex1_cleanup, complex1_msg, 0 },

    {   "",                99, NOFUNC, NOFUNC, NOFUNC, NOFUNC, 0 },
};
