/*
 * get_load - get system load
 *
 * Authors:  Many and varied...
 */

/*
 * This is Linux version which simply reads data from /proc/loadavg.
 * It does not require any special InitLoadPoint() action or any special
 * priviledges as it does not access kernel memory
 *
 * Michal Jaegermann, michal@ellpspace.math.ualberta.ca, 1996-12-23
 */


#include <X11/Intrinsic.h>
#include <stdio.h>
#include <stdlib.h>

/*
 * GetLoadPoint() function has to be of XtCallbackProc type, hence
 * a need for unused arguments.
 */
void GetLoadPoint(Widget w,		/* unused */
		  XtPointer closure,	/* unused */
		  XtPointer call_data)	/* pointer to (double) return value */
{
    FILE *lavgp;
    char loadavg[32];

    if (NULL == (lavgp = fopen("/proc/loadavg", "r"))) {
	perror("can't open /proc/loadavg");
	exit(1);
    }
    fseek(lavgp, 0L, SEEK_SET);
    fgets(&loadavg[0], sizeof(loadavg), lavgp);
    fclose(lavgp);
    lavgp = NULL;
    *(double *)call_data = strtod(&loadavg[0], NULL);
    return;
}

