/* File: 	walk_tree.c:  
 *
 * Description:	Recursively walk the tree and apply the function to each
 *		node in the tree. Parents are processed before children.
 *		If the supplied function returns a non zero value, processing
 *		is stopped and the value is returned by walk_tree.
 *
 *		Note: No attempt is made to catch stack overflow's
 *
 *
 * Author:	George MacDonald
 *
 * Copyright:	Copyright (c) 1995, Pulsar Software Inc.
 *		All Rights Reserved, Unpublished rights reserved.
 *
 * History:	George MacDonald	2/18/95	Created
 *            
 */

#include "tree.h"
#include "debug.h"

tnode
*walk_tree( branch, func, arg )
tnode *branch;
tnode *(*func) ();
int arg;
{
	tnode 		*rc;
	child_ptr	*p, *next_p;

	if ( branch == NULL_TNODE_PTR )
		return( NULL_TNODE_PTR );

	/* Apply the function to the current node, if the function
	 * returns a value other than NULL then terminate the tree
	 * processing and bubble the result up through the calling
	 * stack. Otherwise, continue plunging into the depths of the
	 * tree using the recursive technique. Stack's don't overflow
	 * stack's don't over flow.
	 */

	rc =  (*func) ( branch, arg );
	if ( rc != NULL_TNODE_PTR )
		return( rc );

	for( p = branch->children ; p != NULL; p = next_p )
	{
		next_p = p->next;  /* In case child pointer is removed */

		rc = walk_tree( p->child, func , arg);
		if ( rc != NULL_TNODE_PTR )
			return( rc );
	}

	return( rc );
}

