/* File: 	tree_path.c:  
 *
 * Description:	Generate a path from the root of the tree to the node passed.
 *
 *		Note: user should NOT free space after use.
 *
 * Author:	George MacDonald
 *
 * Copyright:	Copyright (c) 1995, Pulsar Software Inc.
 *		All Rights Reserved, Unpublished rights reserved.
 *
 * History:	George MacDonald	4/21/95	Created
 *            
 */

#include <stdlib.h>
#include <string.h>

#include "tree.h"
#include "debug.h"

typedef struct _path_component
{
	char	*name;
	struct _path_component  *next;
} Path_component;

#define MAX_TREE_PATH	512

Path_component *new_component();
void 		free_components();

char
*tree_path( ptr, separator )
tnode *ptr;
char  *separator;
{
	static char 	path[MAX_TREE_PATH];
	tnode 		*p;
	Path_component	*components=NULL;
	Path_component	*new, *c;

	p = ptr;
	while ( p )
	{
		new = new_component( p->str_key );
		if ( new == NULL )
		{
			free_components( components );
			return( NULL );
		}

		new->next = components;
		components = new;

		p = p->parent;
	}

	path[0] = NULL_CHAR;
	c = components;
	while ( c )
	{
		(void) strcat( path, separator );
		(void) strcat( path, c->name );

		c = c->next;
	}

	free_components( components );
	
	return( path );
}

Path_component
*new_component( name )
char *name;
{
	Path_component *new;

	new = (Path_component *)malloc( sizeof(Path_component) );
	if( new == NULL )
		return( NULL );

	new->next = NULL;
	new->name = name;

	return( new );
}

void
free_components( c )
Path_component *c;
{
	Path_component *next;

	while ( c )
	{
		next = c->next;
		free( c );
		c = next;
	}
}
