/* File: tree.h 
 *
 * Description:   Include file for B tree package
 *
 * Author:	George MacDonald
 *
 * Copyright:	Copyright (c) 1995, Pulsar Software Inc.
 *		All Rights Reserved, Unpublished rights reserved.
 *
 * History:	George MacDonald	2/08/95	Created
 *            
 */

#ifndef TREEH
#define TREEH


/* Each node in the tree contains a pointer to a list of children
 * structure's of the following type.
 */

typedef struct _child_ptr {
	struct _tnode		*child;
	struct _child_ptr	*next;
} child_ptr;

typedef child_ptr	*child_list;


/* The following is the node structure definition, 
 *
 * 	Note: changing these fields directly may cause undefined behaviour
 */

typedef struct _tnode {
	int	 key;		/* Unique integer key, must be filled in*/
	char	*str_key;	/* ASCII string key, NULL if not used   */
	int	 parent_key;	/* Used to stitch together trees        */
	void	*data;		/* Pointer to node independent data 	*/
	int 	 num_children;
	child_list children;  	/* List of child pointer records	*/
	struct	_tnode	*parent;
} tnode;

typedef struct _search_record
{
	int   key;
	char *name;
	int   found_key;
} search_record;

#define NULL_TNODE_PTR   		((tnode *)(0))
#define NULL_TNODE_DATA_PTR   		((void *)(0))

#ifndef NULL_CHAR
#define NULL_CHAR	'\0'
#endif

typedef tnode     *Tnode_ptr;
typedef Tnode_ptr *Tnode_list;


/* Function declarations */

extern tnode 	*construct_tnode();
void 	      	 destroy_tnode();

extern tnode 	*add_tnode();
extern tnode 	*remove_tnode();		/* Unlink and destroy   */
extern tnode 	*extract_tnode();		/* Unlink no destroy    */

extern tnode 	*insert_tnode();		/* Find and add 	*/
extern tnode 	*delete_tnode();		/* Find and remove 	*/

extern tnode 	*move_tnode();

extern tnode 	*walk_tree();
extern tnode 	*post_walk_tree();
extern tnode 	*match_key();
extern tnode 	*match_name();   		/* Match on str_key */
extern tnode 	*next_name_after_key();   	/* Used for find_next  */

extern tnode    *load_tree();
extern tnode    *free_tree();

extern char	*tree_path();
#define make_tnode		construct_tnode
#define free_tnode		destoy_tnode

extern int debug;

#endif /* TREEH */
