/* File: 	match_name.c:  
 *
 * Description:	Function used by walk_tree to check if the supplied name
 *		matches the one in the supplied tnode pointer.
 *
 *
 * Author:	George MacDonald
 *
 * Copyright:	Copyright (c) 2001, Pulsar Software Inc.
 *		All Rights Reserved, Unpublished rights reserved.
 *
 * History:	George MacDonald	22/Nov/2001	Created
 *            
 * For efficiency we assume name is not NULL, caller can check once.
 *
 */

#include "tree.h"
#include "string.h"

tnode
*match_name( ptr, name )
tnode *ptr;
char *name;
{
	if ( ptr->str_key && ( strcmp( ptr->str_key, name ) == 0) )
		return( ptr );
	else
		return( NULL_TNODE_PTR );
}

