/* File: 	insert_tnode.c:  
 *
 * Description:	Search the tree to find the node associated with  parent_key
 *		then insert the new_node as a child of it. 
 *
 *		Duplicate entries
 *
 *		If parent does not exist, it's added to the head of the tree
 *
 * Author:	George MacDonald
 *
 * Copyright:	Copyright (c) 1995, Pulsar Software Inc.
 *		All Rights Reserved, Unpublished rights reserved.
 *
 * History:	George MacDonald	2/18/95	Created
 *            
 */

#include "tree.h"
#include "debug.h"

tnode
*insert_tnode( head, new_node, parent_key )
tnode *head;
tnode *new_node;
int    parent_key;
{
	tnode 		*parent;	/* Parent pointer 		*/

	if ( new_node == NULL_TNODE_PTR )
	{
		DEBUG0(1, "insert_tnode: ERROR new_node is NULL\n");
		return( head );
	}

	if ( head == NULL_TNODE_PTR )
	{
		DEBUG0(1, "insert_tnode: new_node is Head\n");
		head = new_node;
		return( head );
	}

	/* Find the processes parent entry or failing that
	 * use the top of the tree.
	 */

	parent = walk_tree( head, match_key, parent_key );
	if ( parent == NULL_TNODE_PTR )
	{
		/* Could'nt find parent, attach to head of the tree.  */
		DEBUG0(1, "insert_tnode: failed to find parent, add to head\n");
		parent = head;
	}

	(void) add_tnode( parent, new_node );

	return( head );
}
