/* File: 	free_tree.c:  
 *
 * Description:	Walk the tree applying the free_tree_node to free the space
 *		associated with the tree node. If free_data is set True
 *		the space pointed to by data is also freed, otherwise it is
 *		not.
 *
 * Author:	George MacDonald
 *
 * Copyright:	Copyright (c) 1995, Pulsar Software Inc.
 *		All Rights Reserved, Unpublished rights reserved.
 *
 * History:	George MacDonald	2/18/95	Created
 *            
 */

#include <stdlib.h>

#include "tree.h"
#include "debug.h"

tnode *free_tree_node();

tnode
*free_tree( branch, free_data )
tnode *branch;
int    free_data;
{
	(void) post_walk_tree( branch, free_tree_node, free_data );

	return( NULL_TNODE_PTR );
}

tnode
*free_tree_node( ptr, free_data )
tnode *ptr;
int    free_data;
{
	if ( ptr )
	{
		if ( ptr->str_key )
			free( ptr->str_key );

		if ( free_data && ptr->data )
			free( ptr->data );

		free( ptr );
	}

	return( NULL_TNODE_PTR );
}
