/* File: 	extract_tnode.c:  
 *
 * Description:	Disconnect the node from the tree and return a pointer to it
 *
 *
 * Author:	George MacDonald
 *
 * Copyright:	Copyright (c) 1995, Pulsar Software Inc.
 *		All Rights Reserved, Unpublished rights reserved.
 *
 * History:	George MacDonald	2/18/95	Created
 *            
 */

#include <stdlib.h>

#include "tree.h"
#include "debug.h"

tnode
*extract_tnode( ptr )
tnode *ptr;
{
	tnode 		*parent;
	child_ptr    	*p;
	child_ptr    	*last_p;


	if ( ptr->parent == NULL_TNODE_PTR )  /*Top of tree, just return it!!!*/
		return( ptr );

	parent = ptr->parent;

	/* Find the child node in the parent's child pointer list */

	last_p = parent->children;
	for ( p = last_p ; p != NULL ; p = p->next )
	{
		if ( p->child == ptr )
			break;
		last_p = p;
	}

	if ( p == NULL ) 			/* Failed to find node!      */
		return( NULL_TNODE_PTR );

	if ( p == parent->children )  	
		parent->children = p->next; 	/* Remove from head 	     */
	else				
		last_p->next = p->next; 	/* Remove from middle or end */

	if ( p != NULL )			/* Free up child pointer node*/
		free( p );

	parent->num_children--; 	/* Decrement the number of children */

	return( ptr );
}
