/* File: 	delete_tnode.c:  
 *
 * Description:	Find and delete tnode
 *
 * Author:	George MacDonald
 *
 * Copyright:	Copyright (c) 1995, Pulsar Software Inc.
 *		All Rights Reserved, Unpublished rights reserved.
 *
 * History:	George MacDonald	2/18/95	Created
 *            
 */

#include <stdlib.h>

#include "tree.h"
#include "debug.h"

tnode 
*delete_tnode( head, key )
tnode *head;
int key;
{
	tnode   	*ptr;
	child_ptr  	*cptr;
	child_ptr  	*last_ptr;

	ptr = walk_tree( head, match_key, key );
	if ( ptr == NULL_TNODE_PTR || ptr == head ) 	/* Can't remove head */
		return( head );

	(void) extract_tnode( ptr );

	/* Attach children to top node of tree */
	for ( cptr = ptr->children ; cptr != NULL ;  )
	{
		(void) add_tnode( head, cptr->child );

		last_ptr = cptr;
		cptr = cptr->next;
		free( last_ptr );
	}

	destroy_tnode( ptr );

	return( head );
}
