/* File: 	add_tnode.c:  
 *
 * Description:	 Add a node to the specified parent node
 *
 *
 * Author:	George MacDonald
 *
 * Copyright:	Copyright (c) 1995, Pulsar Software Inc.
 *		All Rights Reserved, Unpublished rights reserved.
 *
 * History:	George MacDonald	2/18/95	Created
 *            
 */

#include <stdlib.h>

#include "tree.h"
#include "debug.h"

tnode
*add_tnode( parent, new_node )
tnode *parent;
tnode *new_node;
{
	child_ptr 	*cptr;		/* New child pointer record	*/
	child_ptr	*p;
	child_ptr	*last_p;

	if ( parent == NULL_TNODE_PTR )
	{
		DEBUG0( 0, "add_node: Null parent\n");
		return( NULL_TNODE_PTR );
	}

	if ( new_node == NULL_TNODE_PTR )
	{
		DEBUG0( 0, "add_node: Null new_node\n");
		return(NULL_TNODE_PTR);
	}

	cptr = ( child_ptr * ) malloc( sizeof( child_ptr ) );
	if ( cptr == NULL )
	{
		DEBUG0( 0, "add_node: Malloc failed\n");
		return(NULL_TNODE_PTR);
	}

	cptr->child = new_node;	/* Set the child pointer */
	cptr->next  = NULL;


	/* Set the parent field of the new node to point to the parent */

	new_node->parent = parent;	

	/* Now perform a sorted insertion of the new child pointer structure
	 * into the list of children for the parent.
	 */

	if ( parent->children == NULL )
	{
		DEBUG0( 9, "add_node: first child\n");
		parent->children = cptr;
	}
	else
	{	/* Find position to insert new node  		*/

		last_p = parent->children;
		for ( p = last_p ; p != NULL ; p = p->next )
		{
			if ( new_node->key < p->child->key )
				break;
			last_p = p;
		}

		if ( p == NULL )		/* Append to child list     */
		{
			DEBUG0( 9, "add_node: last child\n");
			last_p->next = cptr;
		}
		else if ( p == parent->children ) /* Insert at head of list  */
		{
			DEBUG0( 9, "add_node: new first child\n");
			cptr->next = parent->children;
			parent->children = cptr;
		}
		else				/* Insert in middle of list */
		{
			DEBUG0( 9, "add_node: middle child\n");
			last_p->next = cptr;
			cptr->next   = p;
		}
	}

	parent->num_children++;

	return( new_node );
}
