/* File: 	textStreamViewer.c
 *
 * Description: A very simple app that reads it's standard input and displays it.
 *		It uses event driven input so it can "hang" on the end of a pipe
 *		like "tail" -f does.
 *
 * Author:	George MacDonald
 *
 * Copyright:	Copyright (c) 2001, Pulsar Software Inc.
 *		All Rights Reserved, Unpublished rights reserved.
 *
 * History:	George MacDonald	11/19/2001	Created
 *            
 *
 */

#include <stdio.h>		
#include <fcntl.h>
#include <time.h>
#include <sys/time.h>
#include <varargs.h>
#include <signal.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#ifndef __linux__
#include <sys/mkdev.h>		/* To get major/minor numbers 		 */
#endif
#include <sys/param.h>		/* To get PAGESIZE i.e. system page	 */
#include <dirent.h>		/* To get the /proc directory listing	 */
#include <unistd.h>

#include <X11/StringDefs.h>
#include <X11/Intrinsic.h>
#include <X11/cursorfont.h>
#include <X11/Xatom.h>
#include <Xm/Xm.h>
#include <Xm/Label.h>
#include <Xm/PushB.h>
#include <Xm/DrawnB.h>
#include <Xm/ScrolledW.h>
#include <Xm/Form.h>
#include <Xm/Frame.h>
#include <Xm/MessageB.h>
#include <Xm/Separator.h>
#include <Xm/Text.h>

#include "debug.h"	/* Macro based debug package		   */

int Debug=0;


/* ------------------ Application resource structures  -------------------- */

typedef struct {
        int     debug_level;
        int     rows;
        int     cols;
	char    *title;
} ApplicationData, *ApplicationDataPtr;


ApplicationData  AppData;

static XtResource Resources[] = {
	{ "debug_level", "Debug_level", XtRInt, sizeof(int), 
	   XtOffset(ApplicationDataPtr, debug_level ), XtRString, "0"    },
	{ "rows", "Rows", XtRInt, sizeof(int), 
	   XtOffset(ApplicationDataPtr, rows ), XtRString, "10"    },
	{ "cols", "Cols", XtRInt, sizeof(int), 
	   XtOffset(ApplicationDataPtr, cols ), XtRString, "40"    },
	{ "title", "Title", XtRString, sizeof(String), 
	   XtOffset(ApplicationDataPtr, title ), XtRString, "textStreamViewer(stdin)"    },
};


/* ----------------  Command line options structure  ---------------------- */

static XrmOptionDescRec Options[] = {
	{"-x",	"*debug_level",		XrmoptionStickyArg, NULL },
	{"-r",	"*rows",		XrmoptionStickyArg, NULL },
	{"-c",	"*cols",		XrmoptionStickyArg, NULL },
	{"-t",	"*title",		XrmoptionStickyArg, NULL },
};


/* ------------------------------- Actions -------------------------------- */

static void toggle_mem();
static void inc_debug();

static XtActionsRec actionsTable[] = {
	{ "toggle_mem",		toggle_mem 	} ,
	{ "inc_debug",		inc_debug 	} ,
};


/* ----------------------------- Translations ----------------------------- */

static char 
appWidgetTranslations[]="<Key>m:     toggle_mem()        	        \n \
		        <Key>x:	    inc_debug()";

XtTranslations	 App_Trans_table;	/* Compiled translation table	*/

static XtAppContext MainContext;

void do_input();

Widget Top_level, MainFormFW;

int InputStream_fd=0;

XtInputId InputId=0;

void do_done();
void do_top();
void do_bottom();

int Num_Text_Chars=0;

int
main(argc, argv)
int argc;
char *argv[];
{
	Widget 		 parent, textw, formw, separatorw, donew, topw, bottomw;
	int 		 rc, n;
	Arg 		 wargs[20];
	int		 rows=10;
	int		 cols=40;
	Boolean		 wrap=TRUE;
	char		*title_str;

	setvbuf( stderr, NULL, _IOLBF, 0 );  /* Unbuffered output */
	setvbuf( stdout, NULL, _IOLBF, 0 );

	setvbuf( stdin, NULL, _IONBF, 0 );


	/* Should now(Motif 2.0+?) be using XtOpenApplication */

	Top_level = XtAppInitialize( &MainContext, "TextStreamViewer", Options, 
						    XtNumber(Options), 
						    &argc, argv,
						    NULL,
						    NULL, 0); 

	/* Load application resources */

	XtGetApplicationResources( Top_level, &AppData, Resources,
				             XtNumber(Resources), 
					     NULL, 0 );
	/* Register the new actions */

	XtAppAddActions( MainContext, actionsTable, XtNumber(actionsTable) );

	App_Trans_table = XtParseTranslationTable( appWidgetTranslations );

	Debug = AppData.debug_level;   /* Set the debug packages debug level */
	rows = AppData.rows; 
	cols = AppData.cols;

	title_str = AppData.title;

	/* Create a form to hold the menu and scrolled window  */

	parent = Top_level;

        n = 0;
	formw = XmCreateForm( parent, "textStreamViewForm", wargs, n );
        XtManageChild( formw );

	parent = formw;

        n = 0;
        XtSetArg( wargs[n], XmNbottomAttachment, XmATTACH_FORM); n++;
        XtSetArg( wargs[n], XmNbottomOffset, 2); n++;
        XtSetArg( wargs[n], XmNleftAttachment, XmATTACH_POSITION); n++;
        XtSetArg( wargs[n], XmNleftPosition, 40 ); n++;
        XtSetArg( wargs[n], XmNrightAttachment, XmATTACH_POSITION); n++;
        XtSetArg( wargs[n], XmNrightPosition, 60); n++;
	donew = XtCreateManagedWidget( "Done", xmPushButtonWidgetClass, 
						parent, wargs, n );

	XtAddCallback( donew, XmNactivateCallback, do_done, NULL);

        n = 0;
        XtSetArg( wargs[n], XmNbottomAttachment, XmATTACH_FORM); n++;
        XtSetArg( wargs[n], XmNbottomOffset, 2); n++;
        XtSetArg( wargs[n], XmNleftAttachment, XmATTACH_POSITION); n++;
        XtSetArg( wargs[n], XmNleftPosition, 10 ); n++;
        XtSetArg( wargs[n], XmNrightAttachment, XmATTACH_POSITION); n++;
        XtSetArg( wargs[n], XmNrightPosition, 30); n++;
	topw = XtCreateManagedWidget( "Top", xmPushButtonWidgetClass, 
						parent, wargs, n );


        n = 0;
        XtSetArg( wargs[n], XmNbottomAttachment, XmATTACH_FORM); n++;
        XtSetArg( wargs[n], XmNbottomOffset, 2); n++;
        XtSetArg( wargs[n], XmNleftAttachment, XmATTACH_POSITION); n++;
        XtSetArg( wargs[n], XmNleftPosition, 70 ); n++;
        XtSetArg( wargs[n], XmNrightAttachment, XmATTACH_POSITION); n++;
        XtSetArg( wargs[n], XmNrightPosition, 90); n++;
	bottomw = XtCreateManagedWidget( "Bottom", xmPushButtonWidgetClass, 
						parent, wargs, n );


        n = 0;
        XtSetArg( wargs[n], XmNbottomAttachment, XmATTACH_WIDGET); n++;
        XtSetArg( wargs[n], XmNbottomWidget, donew); n++;
        XtSetArg( wargs[n], XmNleftAttachment, XmATTACH_FORM); n++;
        XtSetArg( wargs[n], XmNrightAttachment, XmATTACH_FORM); n++;
        XtSetArg( wargs[n], XmNleftOffset, 2); n++;
        XtSetArg( wargs[n], XmNtopOffset, 2); n++;
	separatorw = XtCreateManagedWidget( "separator", xmSeparatorWidgetClass, 
						parent, wargs, n );

        n = 0;
	XtSetArg( wargs[n], XmNtopAttachment,XmATTACH_FORM);n++;
        XtSetArg( wargs[n], XmNleftAttachment, XmATTACH_FORM); n++;
        XtSetArg( wargs[n], XmNrightAttachment, XmATTACH_FORM); n++;
        XtSetArg( wargs[n], XmNbottomAttachment, XmATTACH_WIDGET); n++;
        XtSetArg( wargs[n], XmNbottomWidget, separatorw); n++;
        XtSetArg( wargs[n], XmNbottomOffset, 2); n++;
        XtSetArg( wargs[n], XmNleftOffset, 2); n++;
        XtSetArg( wargs[n], XmNtopOffset, 2); n++;
        XtSetArg( wargs[n], XmNrightOffset, 2); n++;

        XtSetArg( wargs[n], XmNeditMode, XmMULTI_LINE_EDIT ); n++;
        XtSetArg( wargs[n], XmNcursorPositionVisible, False ); n++;
        XtSetArg( wargs[n], XmNeditable, False ); n++;
        XtSetArg( wargs[n], XmNrows, rows ); n++;
        XtSetArg( wargs[n], XmNcolumns, cols ); n++;
        XtSetArg( wargs[n], XmNwordWrap, wrap ); n++;
	textw = XmCreateScrolledText( parent, "textStreamView", wargs, n );

	XtAddCallback( topw, XmNactivateCallback, do_top, textw);
	XtAddCallback( bottomw, XmNactivateCallback, do_bottom, textw);

        XtManageChild( textw );
	XtAugmentTranslations( Top_level, App_Trans_table );

	n = 0;
	XtSetArg( wargs[n], XmNtitle, title_str); n++;
	XtSetValues( Top_level, wargs, n );

	InputStream_fd = fileno( stdin );

	InputId = XtAppAddInput( MainContext, InputStream_fd, (XtPointer)XtInputReadMask, 
							do_input, textw);

	XtRealizeWidget( Top_level );
	XtAppMainLoop( MainContext );
}


void
do_done( w, p, call_data)
Widget w;
char *p;
caddr_t call_data;
{
	fclose( stdin );
	exit(0);
}

void
do_top( w, textw, call_data)
Widget w;
Widget textw;
caddr_t call_data;
{
	XmTextSetTopCharacter( textw, 0 );
}

void
do_bottom( w, textw, call_data)
Widget w;
Widget textw;
caddr_t call_data;
{
	
	XmTextShowPosition( textw, Num_Text_Chars );
}

#define BUFSIZE 256

void
do_input (w, fid, id)
Widget w;
int    *fid;
XtInputId *id;
{
	int got_input=1;
	int line_num=0;
	static int pos=0;
	char buf[BUFSIZE+1];
	int nb=0;
	int i;
	static int first=1;

	if ( InputId == -1 )
		return;

	while ( got_input )
	{
	    nb = read( *fid, buf, BUFSIZE );
	    if ( nb < 0 )
	    {
	    	/* Error, report broken pipe ?*/
		got_input = 0;
		XtRemoveInput( InputId );
		InputId = -1;
	    }
	    else if ( nb == 0 )
	    {
	    	/* Error, report broken pipe? */
		got_input = 0;
		XtRemoveInput( InputId );
		InputId = -1;
	    }
	    else
	    {

		for ( i = 0 ; i < nb ; i++ )
		{
		    if ( ! isprint( buf[i] ) )
		    {
		         if ( buf[i] == '\r' ) continue;
		         if ( buf[i] == '\t' ) continue;
		         if ( buf[i] == '\n' ) continue;
		         if ( buf[i] == '\f' ) continue;
		    	 buf[i] = ' ';
		    }
		}

		buf[nb] = '\0';

	        XmTextInsert( w, pos, buf );
		pos += nb;
	    }

	    line_num++;
	    if ( line_num > 5000 )
	    {
	    	got_input = 0;
	    }
	    got_input = 0;
	}

	if ( first )
	{
	    XmTextShowPosition( w, 0 );
	    first = 0;
	}

	Num_Text_Chars = pos - 1;
}


static void inc_debug() { Debug++; }
static void toggle_mem() { }

