/* File: 	procInfoLaunchPad.c
 *
 * Description: A very simple app to make it easy to browse various bits 
 *		of info about processes. Just launches shell scripts and 
 *		feeds output to a gui viewer, xterm ...
 *
 * Author:	George MacDonald
 *
 * Copyright:	Copyright (c) 2001, Pulsar Software Inc.
 *		All Rights Reserved, Unpublished rights reserved.
 *
 * History:	George MacDonald	11/19/2001	Created
 *            
 *
 */

#include <stdio.h>		
#include <fcntl.h>
#include <time.h>
#include <sys/time.h>
#include <varargs.h>
#include <signal.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#ifndef __linux__
#include <sys/mkdev.h>		/* To get major/minor numbers 		 */
#endif
#include <sys/param.h>		/* To get PAGESIZE i.e. system page	 */
#include <dirent.h>		/* To get the /proc directory listing	 */
#include <unistd.h>

#include <X11/StringDefs.h>
#include <X11/Intrinsic.h>
#include <X11/cursorfont.h>
#include <X11/Xatom.h>
#include <Xm/Xm.h>
#include <Xm/Label.h>
#include <Xm/PushB.h>
#include <Xm/DrawnB.h>
#include <Xm/ScrolledW.h>
#include <Xm/Form.h>
#include <Xm/Frame.h>
#include <Xm/MessageB.h>
#include <Xm/Text.h>

#include "debug.h"	/* Macro based debug package		   */
#include "libXs.h"	

int Debug=0;

#ifdef __linux__
#define LINUX 1
#endif

typedef struct cmdEntry
{
  char *Category; 
  char *label; 
  char *shortCut;
  char *tooltip; 
  char *command; /* First ch is P - pipe, G - gui, X - xterm, T - CmdTip, 
		  * C - command(no output), second char is space 
		  * lower case letters append process name, upper PID */
  char *viewer;  /* override default viewer */
} CommandEntry;


/* Currently tooltips are limited to commands with one line responses */

CommandEntry Commands[] = {
 { "Process", "Map",   "",    
 	"Display process address map", "P pmap -xlF", 
		"textStreamViewer -tProcess_Address_Map -r24 -c80" },
 { NULL, "Stack",   "",    
 	"Display process stack", "P /usr/bin/pstack -F", 
		"textStreamViewer -tProcess_Stack -r24 -c80" },
 { NULL, "Signal Info",   "",    
 	"Display process signal handling info", "P psig", 
		"textStreamViewer -tProcess_Signal_Info -r24 -c60" },
 { NULL, "Credentials", "",    
 	"Process credentials", "P pcred",
		"textStreamViewer -tProcess_Credentials -r4 -c40" },
 { NULL, "Open Files", "",    
 	"Display open file information", "P pfiles -F",
		"textStreamViewer -tProcess_File_Info -r24 -c80" },
 { NULL, "Objects", "",    
 	"Display process objects", "P pmap -rF",
		"textStreamViewer -tProcess_Registers -r24 -c80" },
 { "", "Flags",   "",    
 	"Display process tracing flags, pending and held signals", "P pflags -r", 
		"textStreamViewer -tProcess_Flags -r24 -c80" },
 { NULL, "PWD",   "",    
 	"Display process working dir", "P pwdx ", 
		"textStreamViewer -tProcess_Working_Dir -r4 -c80" },
 { NULL, "Ldd",   "",    
 	"Display process dynamic libs and objects dlopen'ed", "P pldd -F", 
		"textStreamViewer -tProcess_Dynamic_Libs -r24 -c80" },
 { NULL, "BoundTo",   "",    
 	"Display processor bindings", "P /usr/sbin/pbind -q", 
		"textStreamViewer -tProcess_Bound_to_Processor -r8 -c80" },
 { NULL, "Plimit",   "",    
 	"Display process limits", "P plimit -k", 
		"textStreamViewer -tProcess_Limits -r12 -c80" },
 { NULL, "Priocntl",   "",    
 	"Display process priority parameters", "P priocntl -d -ipid ", 
		"textStreamViewer -tProcess_Priority_Settings -r8 -c80" },
 { NULL, "Man Page",   "",    "Display process man page", "x man ", NULL },
 { "Cmd", "Stop",  "",    "Stop the Process", "C pstop", NULL },
 { NULL,  "Continue", "","Start executing a Process again(if stopped)", "C prun", NULL  },
 { NULL,  "Kill",   "",  "Terminate Process", "C kill -9", NULL  },
 { NULL,  "Bind-0", "",  "Bind Process to processor 0", "P /usr/sbin/pbind -b 0", NULL  },
 { NULL,  "Bind-1", "",  "Bind Process to processor 1", "P /usr/sbin/pbind -b 1", NULL  },
};

/* ------------------ Application resource structures  -------------------- */

typedef struct {
        int     debug_level;
	char   *config_file;
} ApplicationData, *ApplicationDataPtr;


ApplicationData  AppData;

static XtResource Resources[] = {
	{ "debug_level", "Debug_level", XtRInt, sizeof(int), 
	   XtOffset(ApplicationDataPtr, debug_level ), XtRString, "0"    },
	{ "config_file", "Config_file", XtRString, sizeof(int), 
	   XtOffset(ApplicationDataPtr, config_file ), XtRString, "DEFAULT" },
};


/* ----------------  Command line options structure  ---------------------- */

static XrmOptionDescRec Options[] = {
	{"-x",	"*debug_level",		XrmoptionStickyArg, NULL },
	{"-f",	"*config_file",		XrmoptionStickyArg, NULL },
};


/* ------------------------------- Actions -------------------------------- */

static void toggle_mem();
static void inc_debug();

static XtActionsRec actionsTable[] = {
	{ "toggle_mem",		toggle_mem 	} ,
	{ "inc_debug",		inc_debug 	} ,
};


/* ----------------------------- Translations ----------------------------- */

static char 
appWidgetTranslations[]="<Key>m:     toggle_mem()        	        \n \
		         <Key>x:     inc_debug()";

XtTranslations	 App_Trans_table;	/* Compiled translation table	*/

static XtAppContext MainContext;

void do_textViewer();
void do_command();

extern void xs_cmd_tip();

Widget Top_level, MainFormFW;

char *Title="Process Info App Launcher";

char *Pid_str=NULL;
char *Proc_name=NULL;

Widget w;
main(argc, argv)
int argc;
char *argv[];
{
	Widget 		 parent, sw, label, button;
	int 		 rc, n;
	Arg 		 wargs[16];
	char		 title_str[ 128 ];
	char		 *Config_file=NULL;

	setvbuf( stderr, NULL, _IOLBF, 0 );  /* Unbuffered output */
	setvbuf( stdout, NULL, _IOLBF, 0 );


	/* should get process name ourselves */

	if ( argc < 3 )
	{
	    fprintf( stderr, "Not enough args\n" );
	    fprintf( stderr, "Synopsys: procInfoLaunchPad pid name\n" );
	    exit( 1 );
	}

	Pid_str = argv[1];
	Proc_name = argv[2];

	if( Pid_str == NULL ) 
	{
		fprintf( stderr, "Missing pid argument must be supplied!!!!\n" );
		exit( 1 );
	}

	sprintf( title_str, "%s - %s(%s) ", Title, Pid_str, Proc_name );

	/* Should be using XtOpenApplication - does it require Motif 2.0 ? */

	Top_level = XtAppInitialize( &MainContext, "ProcInfoLaunchPad", Options, 
						    XtNumber(Options), 
						    &argc, argv,
						    NULL,
						    NULL, 0); 

	/* Load application resources */

	XtGetApplicationResources( Top_level, &AppData, Resources,
				             XtNumber(Resources), 
					     NULL, 0 );
	/* Register the new actions */

	XtAppAddActions( MainContext, actionsTable, XtNumber(actionsTable) );

	App_Trans_table = XtParseTranslationTable( appWidgetTranslations );

	Debug = AppData.debug_level;   /* Set the debug packages debug level */
	Config_file = AppData.config_file;

	/* Create a form to hold the menu and scrolled window  */

	MainFormFW = XtCreateManagedWidget( "mainForm", xmFormWidgetClass,
							Top_level, NULL, 0 );
	parent    = MainFormFW;

	/* Use a config file to determine what launcher definition file to use
	 * if none found then use this builtin set.
	 */

	if ( strcmp( Config_file, "DEFAULT" ) != 0 )
	{
		/* go ahead! implement it!!!!*/
		printf("loading from file not implemented yet\n"); 
		exit(0);
	}
	else
		createDefaultLaunchPad( parent );

	XtAugmentTranslations( MainFormFW, App_Trans_table );

	n = 0;
	XtSetArg( wargs[n], XmNtitle, title_str); n++;
	XtSetValues( Top_level, wargs, n );

	XtRealizeWidget( Top_level );
	XtAppMainLoop( MainContext );
}


createDefaultLaunchPad( parent )
Widget parent;
{
	Widget 		 label, button, attach_top, attach_left, attach_top_last;
	int 		 i, n, row, numCommands;
	Arg 		 wargs[16];
	CommandEntry    *p;
	int		 firstRowButton = 1;
	int		 firstRowLabel = 1;
	char		labelString[120];
	int		ColonPosition=15;

	numCommands = sizeof( Commands ) / sizeof( CommandEntry );

	/* printf( "numCommands = %d\n", numCommands ); */

	row = 0;
	for ( i = 0 ; i < numCommands ; i++ )
	{
		p = &(Commands[i]);
		/* printf("[%d] - %s %s %s (%s) (%s)\n", row, p->Category, p->label, 
						p->shortCut, p->tooltip, 
						p->command ); */

		/* if ( (p->Category) == NULL || ( strlen(p->Category) == 0 ) ) */
		if ( (p->Category) == NULL )
		{
		    n = 0;
		    if ( firstRowButton )  /* So attach to form */
		    {
		        XtSetArg( wargs[n], XmNtopAttachment,XmATTACH_FORM);n++;
		        XtSetArg( wargs[n], XmNtopOffset, 6); n++;
		    }
		    else  /* not the first row so attach to widgets */
		    {
		        XtSetArg( wargs[n], XmNtopAttachment,XmATTACH_WIDGET);n++;
		        XtSetArg( wargs[n], XmNtopWidget, attach_top);n++;
		        XtSetArg( wargs[n], XmNtopOffset, 2); n++;
		    }

		    
		    XtSetArg( wargs[n], XmNleftAttachment, XmATTACH_WIDGET); n++;
		    XtSetArg( wargs[n], XmNleftWidget, attach_left); n++;
		    XtSetArg( wargs[n], XmNleftOffset, 2); n++;
		    button = XtCreateManagedWidget( p->label, xmPushButtonWidgetClass,
						parent, wargs, n );


		    XtAddCallback( button, XmNactivateCallback, do_command, p);
		    if ( p->command[0] == 'T' )
		        xs_cmd_tip( button, &(p->command[2]) );
		    xs_widget_tip( button, p->tooltip );


		    attach_left = button;  
		}
		else  /* Starting New Row */
		{
		    n = 0;
		    if ( firstRowLabel )   /* First Row */
		    {
			firstRowLabel = 0;
		        XtSetArg( wargs[n], XmNtopAttachment,XmATTACH_FORM);n++;
		        XtSetArg( wargs[n], XmNtopOffset, 6); n++;
		    }
		    else
		    {
		        firstRowButton = 0;

		        attach_top  = attach_top_last;

			/* Adjust the label in the row above to be vertically centered */

			n = 0;
			XtSetArg( wargs[n], XmNbottomAttachment, XmATTACH_OPPOSITE_WIDGET); n++;
			XtSetArg( wargs[n], XmNbottomWidget, attach_top_last); n++;
			XtSetArg( wargs[n], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); n++;
			XtSetArg( wargs[n], XmNtopWidget, attach_top_last); n++;
			XtSetValues( label, wargs, n ); 

		        XtSetArg( wargs[n], XmNtopAttachment,XmATTACH_WIDGET);n++;
		        XtSetArg( wargs[n], XmNtopWidget, attach_top);n++;
		        XtSetArg( wargs[n], XmNtopOffset, 2); n++;
		    }


		    XtSetArg( wargs[n], XmNrightAttachment, XmATTACH_POSITION); n++;
		    XtSetArg( wargs[n], XmNrightPosition, ColonPosition); n++;
		    XtSetArg( wargs[n], XmNrightOffset, 2); n++;
		    XtSetArg( wargs[n], XmNleftOffset, 2); n++;
		    if ( strlen( p->Category ) > 0 )
		        sprintf( labelString, "%s:", p->Category );
		    else
		        strcpy( labelString, " " );
		    label = XtCreateManagedWidget( labelString, xmLabelWidgetClass,
						parent, wargs, n );

		    /* Now add the first button in the row */

		    n = 0;
		    if ( firstRowButton )   /* First Row */
		    {
		        XtSetArg( wargs[n], XmNtopAttachment,XmATTACH_FORM);n++;
		        XtSetArg( wargs[n], XmNtopOffset, 6); n++;
		    }
		    else
		    {
		        attach_top  = attach_top_last;
		        XtSetArg( wargs[n], XmNtopAttachment,XmATTACH_WIDGET);n++;
		        XtSetArg( wargs[n], XmNtopWidget, attach_top);n++;
		        XtSetArg( wargs[n], XmNtopOffset, 2); n++;
		    }

		    XtSetArg( wargs[n], XmNleftAttachment, XmATTACH_POSITION); n++;
		    XtSetArg( wargs[n], XmNleftPosition, ColonPosition); n++;
		    XtSetArg( wargs[n], XmNleftOffset, 4); n++;


		    button = XtCreateManagedWidget( p->label, xmPushButtonWidgetClass,
						parent, wargs, n );

		    XtAddCallback( button, XmNactivateCallback, do_command, p);

		    if ( p->command[0] == 'T' )
		        xs_cmd_tip( button, &(p->command[2]) );
		    xs_widget_tip( button, p->tooltip );

		    attach_top_last  = button;  
		    attach_left      = button;  

		    row++;
		    /* printf( "Row[%d]\n", row ); */
		}
	}

	n = 0;
	XtSetArg( wargs[n], XmNbottomAttachment, XmATTACH_OPPOSITE_WIDGET); n++;
	XtSetArg( wargs[n], XmNbottomWidget, attach_top_last); n++;
	XtSetArg( wargs[n], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); n++;
	XtSetArg( wargs[n], XmNtopWidget, attach_top_last); n++;
	XtSetValues( label, wargs, n ); 

	n = 0;
	XtSetArg( wargs[n], XmNbottomAttachment, XmATTACH_FORM); n++;
	XtSetArg( wargs[n], XmNbottomOffset, 6); n++;
	XtSetValues( attach_top_last, wargs, n ); 
}

void
do_command( w, p, call_data)
Widget w;
CommandEntry *p;
caddr_t call_data;
{
    char command[256];
    char *cmd;

    cmd = p->command;

    /* printf("Command -> (%s)\n", cmd ); */

    if ( ( cmd[0] == 'P' ) || ( cmd[0] == 'T' ))  /* Execute and pipe to our own viewer */
    {
        if ( p->viewer ) /* override default viewer */
           sprintf( command, "sh -c \"%s %s 2>&1 | %s &\" ", &(cmd[2]), Pid_str, p->viewer );
	else
           sprintf( command, "sh -c \"%s %s  2>&1 | textStreamViewer -t%s&\" ", &(cmd[2]), 
							Pid_str, p->label );
    	spawnExternal( command );
    }
    else if ( ( cmd[0] == 'p' ) || ( cmd[0] == 't' ))  /* Execute pipe to our own viewer */
    {
        if ( p->viewer ) /* override default viewer */
           sprintf( command, "sh -c \"%s %s 2>&1 | %s &\" ", &(cmd[2]), Proc_name, p->viewer );
	else
           sprintf( command, "sh -c \"%s %s  2>&1 | textStreamViewer -t%s&\" ", &(cmd[2]), 
							Proc_name, p->label );
    	spawnExternal( command );
    }
    else if ( cmd[0] == 'G' )  /* A GUI tool */
    {
        sprintf( command, "%s %s &", &(cmd[2]), Pid_str );

    	spawnExternal( command );
    }
    else if ( cmd[0] == 'g' )  /* A GUI tool */
    {
        sprintf( command, "%s %s &", &(cmd[2]), Proc_name );

    	spawnExternal( command );
    }
    else if ( cmd[0] == 'X' )   /* use xterm */
    {
        sprintf( command, "xterm -ls -e %s %s &", &(cmd[2]), Pid_str );

    	spawnExternal( command );
    }
    else if ( cmd[0] == 'x' )   /* use xterm */
    {
        sprintf( command, "xterm -ls -e %s %s &", &(cmd[2]), Proc_name);

    	spawnExternal( command );
    }
    else if ( ( cmd[0] == 'C' ) )  /* Execute and ignore output */
    {
           sprintf( command, "sh -c \"%s %s 2>&1 &\" ", &(cmd[2]), Pid_str );
    	   spawnExternal( command );
    }
    else if ( ( cmd[0] == 'C' ) )  /* Execute and ignore output */
    {
           sprintf( command, "sh -c \"%s %s 2>&1 &\" ", &(cmd[2]), Proc_name );
    	   spawnExternal( command );
    }
    else
    {
    	printf("Command Type Unknown-> (%s)\n", cmd );
    }
}

int
spawnExternal( cmd )
char *cmd;
{
        system( cmd );
}

static void inc_debug()
{
	Debug++;
}
static void toggle_mem()
{
}
