/* File: 	os_info.c
 *
 * Description: shared code to get os related info. Simple cache wrapper of
 *              uname(2).
 *
 * Author:	George MacDonald
 *
 * Copyright:	GPL
 *
 * History:	George MacDonald	6/21/99	Created
 *            
 *
 */

#include <sys/utsname.h>		

static struct utsname uname_buf;

static os_info_initialized=0;

int osMajorReleaseNumber;
int osMinorReleaseNumber;

void
os_info_initialize()
{
    if ( ! os_info_initialized )
    {
        uname( &uname_buf );
        os_info_initialized++;

	osMajorReleaseNumber = atoi( uname_buf.release );
	osMinorReleaseNumber = atoi( &(uname_buf.release[2]) );
    }
}

#define I os_info_initialize()

char *os_get_sysname()  { I; return uname_buf.sysname; }
char *os_get_nodename() { I; return uname_buf.nodename; }
char *os_get_release()  { I; return uname_buf.release; }
char *os_get_version()  { I; return uname_buf.version; }
char *os_get_machine()  { I; return uname_buf.machine; }

