/* File: print_list.c 
 *
 * Description:   
 *	        Print the list, using supplied label.
 *
 *		Doesn't print data.
 *
 * Author:	George MacDonald
 *
 * Copyright:	Copyright (c) 1995, Pulsar Software Inc.
 *		All Rights Reserved, Unpublished rights reserved.
 *
 * History:	George MacDonald	2/08/95	Created
 *         	George MacDonald	4/11/95	Broke out into separate file
 *            
 */


#include <stdio.h>

#include "list.h"	/* Package definitions */

void
print_list( label, list )
char *label;
lnode *list;
{
	lnode *p;

	fprintf( stderr, "%s: ", label );

	for ( p = list; p != NULL_LNODE_PTR ; p = p->next )
		fprintf( stderr, "%d,", p->key );
	fprintf( stderr, "\n");
}

